/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.logutils;

import android.os.Environment;
import android.os.HandlerThread;
import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.LogAdapter;
import com.orhanobut.logger.LogStrategy;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.PrettyFormatStrategy;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.tcshare.logutils.MyDiskLogStrategy;

public class MyAndroidLogAdapter {
    private static final int MAX_BYTES = 5120000;
    private static final int DEFAULT_KEEP_DAYS = 90;
    private static MyAndroidLogAdapter instance;
    private String folder;
    private Timer timer;

    private MyAndroidLogAdapter() {
        String diskPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        this.folder = diskPath + File.separatorChar + "logger";
        this.init(this.folder);
    }

    public void init(final String folder, final int keeDays) {
        this.folder = folder;
        HandlerThread ht = new HandlerThread("AndroidFileLogger." + folder);
        ht.start();
        MyDiskLogStrategy.WriteHandler handler = new MyDiskLogStrategy.WriteHandler(ht.getLooper(), folder, 5120000);
        MyDiskLogStrategy logStrategy = new MyDiskLogStrategy(handler);
        PrettyFormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder().logStrategy((LogStrategy)logStrategy).build();
        Logger.clearLogAdapters();
        Logger.addLogAdapter((LogAdapter)new AndroidLogAdapter((FormatStrategy)formatStrategy));
        try {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        MyAndroidLogAdapter.deleteOverDateFile(new File(folder), keeDays < 0 ? 90 : keeDays);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Logger.e((String)(new Date() + "\u5220\u9664\u65e5\u5fd7\u65f6\u5f02\u5e38\uff1a" + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }, 10000L, 86400000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.e((String)("\u5b9a\u65f6\u5220\u9664\u65e5\u5fd7\u9519\u8bef\u3002" + e.getMessage()), (Object[])new Object[0]);
        }
    }

    public void init(String folder) {
        this.init(folder, 90);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MyAndroidLogAdapter getInstance() {
        Class<MyAndroidLogAdapter> clazz = MyAndroidLogAdapter.class;
        synchronized (MyAndroidLogAdapter.class) {
            if (instance == null) {
                instance = new MyAndroidLogAdapter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void deleteOverDateFile(File dirPath, final int keepDays) {
        File[] files = dirPath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                try {
                    Date currentDate = new Date(System.currentTimeMillis());
                    Date lastModifyDate = new Date(file.lastModified());
                    long diff = currentDate.getTime() - lastModifyDate.getTime();
                    long days = diff / 86400000L;
                    return days > (long)keepDays;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        });
        if (files != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }
}

