/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.logcatviewer.service;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILogcatViewerService
extends IInterface {
    public static final String DESCRIPTOR = "org.tcshare.logcatviewer.service.ILogcatViewerService";

    public void changeLogcatSource(String var1) throws RemoteException;

    public void restart() throws RemoteException;

    public void stop() throws RemoteException;

    public void startRecording(String var1, String var2) throws RemoteException;

    public void stopRecording() throws RemoteException;

    public boolean isRecording() throws RemoteException;

    public void pause() throws RemoteException;

    public void resume() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILogcatViewerService {
        static final int TRANSACTION_changeLogcatSource = 1;
        static final int TRANSACTION_restart = 2;
        static final int TRANSACTION_stop = 3;
        static final int TRANSACTION_startRecording = 4;
        static final int TRANSACTION_stopRecording = 5;
        static final int TRANSACTION_isRecording = 6;
        static final int TRANSACTION_pause = 7;
        static final int TRANSACTION_resume = 8;

        public Stub() {
            this.attachInterface(this, ILogcatViewerService.DESCRIPTOR);
        }

        public static ILogcatViewerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILogcatViewerService.DESCRIPTOR);
            if (iin != null && iin instanceof ILogcatViewerService) {
                return (ILogcatViewerService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILogcatViewerService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    this.changeLogcatSource(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.restart();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    this.stop();
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.startRecording(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.stopRecording();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    boolean _result = this.isRecording();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    break;
                }
                case 7: {
                    this.pause();
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.resume();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ILogcatViewerService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILogcatViewerService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeLogcatSource(String buffer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogcatViewerService.DESCRIPTOR);
                    _data.writeString(buffer);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restart() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogcatViewerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogcatViewerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRecording(String logFilename, String filterText) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogcatViewerService.DESCRIPTOR);
                    _data.writeString(logFilename);
                    _data.writeString(filterText);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRecording() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogcatViewerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRecording() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogcatViewerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pause() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogcatViewerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resume() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ILogcatViewerService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILogcatViewerService {
        @Override
        public void changeLogcatSource(String buffer) throws RemoteException {
        }

        @Override
        public void restart() throws RemoteException {
        }

        @Override
        public void stop() throws RemoteException {
        }

        @Override
        public void startRecording(String logFilename, String filterText) throws RemoteException {
        }

        @Override
        public void stopRecording() throws RemoteException {
        }

        @Override
        public boolean isRecording() throws RemoteException {
            return false;
        }

        @Override
        public void pause() throws RemoteException {
        }

        @Override
        public void resume() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

