/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.jsbridge;

import android.graphics.Bitmap;
import android.os.Build;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.tcshare.jsbridge.BridgeUtil;
import org.tcshare.jsbridge.BridgeWebView;
import org.tcshare.jsbridge.Message;

public class BridgeWebViewClient
extends WebViewClient {
    private BridgeWebView webView;

    public BridgeWebViewClient(BridgeWebView webView) {
        this.webView = webView;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (url.startsWith("yy://return/")) {
            this.webView.handlerReturnData(url);
            return true;
        }
        if (url.startsWith("yy://")) {
            this.webView.flushMessageQueue();
            return true;
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        if (Build.VERSION.SDK_INT >= 24) {
            String url = request.getUrl().toString();
            try {
                url = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
            if (url.startsWith("yy://return/")) {
                this.webView.handlerReturnData(url);
                return true;
            }
            if (url.startsWith("yy://")) {
                this.webView.flushMessageQueue();
                return true;
            }
            return super.shouldOverrideUrlLoading(view, request);
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        BridgeUtil.webViewLoadLocalJs(view, "WebViewJavascriptBridge.js");
        if (this.webView.getStartupMessage() != null) {
            for (Message m : this.webView.getStartupMessage()) {
                this.webView.dispatchMessage(m);
            }
            this.webView.setStartupMessage(null);
        }
    }
}

