/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.fileselectorlib.Utils;

import android.content.Context;
import android.content.UriPermission;
import android.net.Uri;
import androidx.annotation.RequiresApi;
import androidx.documentfile.provider.DocumentFile;
import java.io.File;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.tcshare.fileselectorlib.Objects.BasicParams;
import org.tcshare.fileselectorlib.Objects.FileInfo;

public class FileUtil {
    public static String sFileExtensions;
    public static final int FILE_TYPE_MP3 = 1;
    public static final int FILE_TYPE_M4A = 2;
    public static final int FILE_TYPE_WAV = 3;
    public static final int FILE_TYPE_AMR = 4;
    public static final int FILE_TYPE_AWB = 5;
    public static final int FILE_TYPE_WMA = 6;
    public static final int FILE_TYPE_OGG = 7;
    private static final int FIRST_AUDIO_FILE_TYPE = 1;
    private static final int LAST_AUDIO_FILE_TYPE = 7;
    public static final int FILE_TYPE_MID = 11;
    public static final int FILE_TYPE_SMF = 12;
    public static final int FILE_TYPE_IMY = 13;
    private static final int FIRST_MIDI_FILE_TYPE = 11;
    private static final int LAST_MIDI_FILE_TYPE = 13;
    public static final int FILE_TYPE_MP4 = 21;
    public static final int FILE_TYPE_M4V = 22;
    public static final int FILE_TYPE_3GPP = 23;
    public static final int FILE_TYPE_3GPP2 = 24;
    public static final int FILE_TYPE_WMV = 25;
    private static final int FIRST_VIDEO_FILE_TYPE = 21;
    private static final int LAST_VIDEO_FILE_TYPE = 25;
    public static final int FILE_TYPE_JPEG = 31;
    public static final int FILE_TYPE_GIF = 32;
    public static final int FILE_TYPE_PNG = 33;
    public static final int FILE_TYPE_BMP = 34;
    public static final int FILE_TYPE_WBMP = 35;
    private static final int FIRST_IMAGE_FILE_TYPE = 31;
    private static final int LAST_IMAGE_FILE_TYPE = 35;
    public static final int FILE_TYPE_M3U = 41;
    public static final int FILE_TYPE_PLS = 42;
    public static final int FILE_TYPE_WPL = 43;
    private static final int FIRST_PLAYLIST_FILE_TYPE = 41;
    private static final int LAST_PLAYLIST_FILE_TYPE = 43;
    public static final int FILE_TYPE_TXT = 51;
    public static final int FILE_TYPE_DOC = 52;
    public static final int FILE_TYPE_RTF = 53;
    public static final int FILE_TYPE_LOG = 54;
    public static final int FILE_TYPE_CONF = 55;
    public static final int FILE_TYPE_SH = 56;
    public static final int FILE_TYPE_XML = 57;
    private static final int FIRST_TEXT_FILE_TYPE = 51;
    private static final int LAST_TEXT_FILE_TYPE = 57;
    private static HashMap<String, MediaFileType> sFileTypeMap;
    private static HashMap<String, Integer> sMimeTypeMap;
    public static final String UNKNOWN_STRING = "<unknown>";

    static void addFileType(String extension, int fileType, String mimeType) {
        sFileTypeMap.put(extension, new MediaFileType(fileType, mimeType));
        sMimeTypeMap.put(mimeType, fileType);
    }

    public static boolean isAudioFileType(int fileType) {
        return fileType >= 1 && fileType <= 7 || fileType >= 11 && fileType <= 13;
    }

    public static boolean isVideoFileType(int fileType) {
        return fileType >= 21 && fileType <= 25;
    }

    public static boolean isImageFileType(int fileType) {
        return fileType >= 31 && fileType <= 35;
    }

    public static boolean isPlayListFileType(int fileType) {
        return fileType >= 41 && fileType <= 43;
    }

    public static boolean isTextFileType(int fileType) {
        return fileType >= 51 && fileType <= 57;
    }

    public static MediaFileType getFileType(String path) {
        int lastDot = path.lastIndexOf(".");
        if (lastDot < 0) {
            return null;
        }
        return sFileTypeMap.get(path.substring(lastDot + 1).toUpperCase());
    }

    public static boolean isVideoFileType(String path) {
        MediaFileType type = FileUtil.getFileType(path);
        if (null != type) {
            return FileUtil.isVideoFileType(type.fileType);
        }
        return false;
    }

    public static boolean isAudioFileType(String path) {
        MediaFileType type = FileUtil.getFileType(path);
        if (null != type) {
            return FileUtil.isAudioFileType(type.fileType);
        }
        return false;
    }

    public static boolean isImageFileType(String path) {
        MediaFileType type = FileUtil.getFileType(path);
        if (null != type) {
            return FileUtil.isImageFileType(type.fileType);
        }
        return false;
    }

    public static boolean isTextFileType(String path) {
        MediaFileType type = FileUtil.getFileType(path);
        if (null != type) {
            return FileUtil.isTextFileType(type.fileType);
        }
        return false;
    }

    public static int getFileTypeForMimeType(String mimeType) {
        Integer value = sMimeTypeMap.get(mimeType);
        return value == null ? 0 : value;
    }

    public static int getSubfolderNum(String path) {
        int i = 0;
        File[] files = new File(path).listFiles();
        if (files == null) {
            return -1;
        }
        for (File f : files) {
            if (f.getName().indexOf(".") == 0) continue;
            ++i;
        }
        return i;
    }

    public static int getSubFolderNum(DocumentFile documentFile) {
        DocumentFile[] documentFiles;
        int i = 0;
        for (DocumentFile file : documentFiles = documentFile.listFiles()) {
            if (file.getName() == null || file.getName().indexOf(".") == 0) continue;
            ++i;
        }
        return i;
    }

    public static String getFileSize(long size) {
        StringBuffer bytes = new StringBuffer();
        DecimalFormat format = new DecimalFormat("###.0");
        if (size >= 0x40000000L) {
            double i = (double)size / 1.073741824E9;
            bytes.append(format.format(i)).append("GB");
        } else if (size >= 0x100000L) {
            double i = (double)size / 1048576.0;
            bytes.append(format.format(i)).append("MB");
        } else if (size >= 1024L) {
            double i = (double)size / 1024.0;
            bytes.append(format.format(i)).append("KB");
        } else if (size <= 0L) {
            bytes.append("0B");
        } else {
            bytes.append((int)size).append("B");
        }
        return bytes.toString();
    }

    public static void SortFilesByName(List<File> fileList) {
        Collections.sort(fileList, (o1, o2) -> {
            if (o1.isDirectory() && o2.isFile()) {
                return -1;
            }
            if (o1.isFile() && o2.isDirectory()) {
                return 1;
            }
            return Collator.getInstance(Locale.CHINA).compare(o1.getName(), o2.getName());
        });
    }

    public static void SortFilesByName(List<FileInfo> fileList, boolean ignore) {
        Collections.sort(fileList, (o1, o2) -> {
            if (o1.isDirectory() && !o2.isDirectory()) {
                return -1;
            }
            if (!o1.isDirectory() && o2.isDirectory()) {
                return 1;
            }
            return Collator.getInstance(Locale.CHINA).compare(o1.getFileName(), o2.getFileName());
        });
    }

    public static ArrayList<String> getRelativePaths(String path) {
        ArrayList<String> paths = new ArrayList<String>();
        if (path.contains(BasicParams.BasicPath)) {
            String[] p;
            int startIndex = path.indexOf(BasicParams.BasicPath) + BasicParams.BasicPath.length();
            String rawPath = path.substring(startIndex);
            for (String l : p = rawPath.split("/")) {
                if (l.equals("")) continue;
                paths.add(l);
            }
        }
        return paths;
    }

    public static boolean fileFilter(String path, String ... extensions) {
        path = path.toUpperCase();
        for (String extension : extensions) {
            String ext = extension.toUpperCase();
            if (!path.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(api=26)
    public static String mergeAbsolutePath(ArrayList<String> paths) {
        return BasicParams.BasicPath + File.separator + String.join((CharSequence)"/", paths);
    }

    public static boolean isGrant(Context context, String path) {
        String uri = FileUtil.changeToUriNormal(path);
        for (UriPermission persistedUriPermission : context.getContentResolver().getPersistedUriPermissions()) {
            if (!persistedUriPermission.isReadPermission() || !persistedUriPermission.getUri().toString().equals(uri)) continue;
            return true;
        }
        return false;
    }

    public static String changeToUriAndroidOrigin(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String path2 = path.replace("/storage/emulated/0/", "").replace("/", "%2F");
        return "content://com.android.externalstorage.documents/tree/primary%3AAndroid%2Fdata/document/primary%3A" + path2;
    }

    public static String changeToUriNormal(String path) {
        path = path.replace("/storage/emulated/0/", "");
        path = Uri.encode((String)path).replace("/", "%2F");
        return "content://com.android.externalstorage.documents/tree/primary%3A" + path;
    }

    public static String changeToPath(String uri) {
        String path = uri;
        if (uri.contains("content://com.android.externalstorage.documents/tree/primary%3AAndroid%2Fdata")) {
            path = uri.replace("content://com.android.externalstorage.documents/tree/primary%3AAndroid%2Fdata/document/primary%3A", "").replace("%2F", "/");
        } else if (uri.contains("content://com.android.externalstorage.documents/tree/primary%3AAndroid%2Fobb")) {
            path = uri.replace("content://com.android.externalstorage.documents/tree/primary%3AAndroid%2Fobb/document/primary%3A", "").replace("%2F", "/");
        }
        path = Uri.decode((String)path);
        return "/storage/emulated/0/" + path;
    }

    public static DocumentFile getDocumentFilePath(Context context, String path) {
        String path_pattern = "/storage/emulated/0";
        String rootUri = "content://com.android.externalstorage.documents/tree/primary%3A";
        if (path.contains("/Android/data")) {
            path_pattern = "/storage/emulated/0/Android/data";
            rootUri = "content://com.android.externalstorage.documents/tree/primary%3AAndroid%2Fdata";
        }
        if (path.contains("/Android/obb")) {
            path_pattern = "/storage/emulated/0/Android/obb";
            rootUri = "content://com.android.externalstorage.documents/tree/primary%3AAndroid%2Fobb";
        }
        DocumentFile document = DocumentFile.fromTreeUri((Context)context, (Uri)Uri.parse((String)rootUri));
        path = path.replace(path_pattern, "");
        String[] parts = path.split("/");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].equals("")) continue;
            String encoded_path = Uri.decode((String)parts[i]);
            if (document == null) break;
            document = document.findFile(encoded_path);
        }
        return document;
    }

    static {
        sFileTypeMap = new HashMap();
        sMimeTypeMap = new HashMap();
        FileUtil.addFileType("MP3", 1, "audio/mpeg");
        FileUtil.addFileType("M4A", 2, "audio/mp4");
        FileUtil.addFileType("WAV", 3, "audio/x-wav");
        FileUtil.addFileType("AMR", 4, "audio/amr");
        FileUtil.addFileType("AWB", 5, "audio/amr-wb");
        FileUtil.addFileType("WMA", 6, "audio/x-ms-wma");
        FileUtil.addFileType("OGG", 7, "application/ogg");
        FileUtil.addFileType("MID", 11, "audio/midi");
        FileUtil.addFileType("XMF", 11, "audio/midi");
        FileUtil.addFileType("RTTTL", 11, "audio/midi");
        FileUtil.addFileType("SMF", 12, "audio/sp-midi");
        FileUtil.addFileType("IMY", 13, "audio/imelody");
        FileUtil.addFileType("MP4", 21, "video/mp4");
        FileUtil.addFileType("M4V", 22, "video/mp4");
        FileUtil.addFileType("3GP", 23, "video/3gpp");
        FileUtil.addFileType("3GPP", 23, "video/3gpp");
        FileUtil.addFileType("3G2", 24, "video/3gpp2");
        FileUtil.addFileType("3GPP2", 24, "video/3gpp2");
        FileUtil.addFileType("WMV", 25, "video/x-ms-wmv");
        FileUtil.addFileType("JPG", 31, "image/jpeg");
        FileUtil.addFileType("JPEG", 31, "image/jpeg");
        FileUtil.addFileType("GIF", 32, "image/gif");
        FileUtil.addFileType("PNG", 33, "image/png");
        FileUtil.addFileType("BMP", 34, "image/x-ms-bmp");
        FileUtil.addFileType("WBMP", 35, "image/vnd.wap.wbmp");
        FileUtil.addFileType("M3U", 41, "audio/x-mpegurl");
        FileUtil.addFileType("PLS", 42, "audio/x-scpls");
        FileUtil.addFileType("WPL", 43, "application/vnd.ms-wpl");
        FileUtil.addFileType("TXT", 51, "text/plain");
        FileUtil.addFileType("DOC", 52, "application/msword");
        FileUtil.addFileType("RTF", 53, "application/rtf");
        FileUtil.addFileType("LOG", 54, "text/plain");
        FileUtil.addFileType("CONF", 55, "text/plain");
        FileUtil.addFileType("SH", 56, "text/plain");
        FileUtil.addFileType("XML", 57, "text/plain");
        StringBuilder builder = new StringBuilder();
        for (String s : sFileTypeMap.keySet()) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(s);
        }
        sFileExtensions = builder.toString();
    }

    static class MediaFileType {
        int fileType;
        String mimeType;

        MediaFileType(int fileType, String mimeType) {
            this.fileType = fileType;
            this.mimeType = mimeType;
        }
    }
}

