/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import org.tcshare.androidutils.R;
import org.tcshare.utils.ImmerseUtil;

public class LoadingDialog {
    public static Dialog createLoadingDialog(Context context, @Nullable String msg) {
        return LoadingDialog.createLoadingDialog(context, msg, false);
    }

    public static Dialog createLoadingDialog(Context context, @Nullable String msg, boolean immerse) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.dialog_loading, null);
        LinearLayout layout2 = (LinearLayout)view.findViewById(R.id.dialog_view);
        final ImageView img = (ImageView)view.findViewById(R.id.img);
        TextView tipText = (TextView)view.findViewById(R.id.tipTextView);
        tipText.setVisibility(TextUtils.isEmpty((CharSequence)msg) ? 8 : 0);
        tipText.setText((CharSequence)msg);
        Animation animation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.dialog_loading);
        final Dialog loadingDialog = new Dialog(context, R.style.loading_dialog);
        loadingDialog.setOnShowListener(dialog -> img.startAnimation(animation));
        loadingDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                Animation anim2 = img.getAnimation();
                if (anim2 != null) {
                    anim2.cancel();
                }
            }
        });
        loadingDialog.setCancelable(false);
        loadingDialog.setCanceledOnTouchOutside(false);
        loadingDialog.setContentView((View)layout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        if (immerse) {
            loadingDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(DialogInterface dialog) {
                    ImmerseUtil.hidden(loadingDialog.getWindow());
                }
            });
        }
        return loadingDialog;
    }
}

