/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.adapter;

import android.annotation.SuppressLint;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

public abstract class ExpandableRecyclerViewAdapter<P, C>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int VIEW_TYPE_PARENT = 1;
    public static final int VIEW_TYPE_CHILD = 2;
    protected final List<P> parentList = new ArrayList<P>();
    protected final List<List<C>> childList = new ArrayList<List<C>>();
    protected final List<ItemWrapper> flatFilterList = new ArrayList<ItemWrapper>();
    protected final List<ItemWrapper> flatList = new ArrayList<ItemWrapper>();

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        ItemWrapper item = this.flatFilterList.get(position);
        if (item.type == 1) {
            this.onBindParent(holder, item.parent);
        } else {
            this.onBindChild(holder, item.child);
        }
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder holder;
        if (viewType == 1) {
            holder = this.getParentViewHolder(parent);
            GestureDetector gestureDetector = new GestureDetector(parent.getContext(), (GestureDetector.OnGestureListener)new SingleTapConfirm());
            holder.itemView.setOnTouchListener((arg0, arg1) -> {
                if (gestureDetector.onTouchEvent(arg1)) {
                    int flatListPos = holder.getAdapterPosition();
                    this.collapseOrExpandList(flatListPos);
                    arg0.performClick();
                }
                return true;
            });
        } else {
            holder = this.getChildViewHolder(parent);
        }
        return holder;
    }

    protected void collapseOrExpandList(int flatListPos) {
        if (this.childList.size() == 0) {
            return;
        }
        ItemWrapper item = this.flatFilterList.get(flatListPos);
        if (item.isExpand) {
            this.doCollapseList(flatListPos, item);
        } else {
            this.doExpandList(flatListPos, item);
        }
    }

    private void doExpandList(int pos, ItemWrapper item) {
        item.isExpand = true;
        List cList = item.cList;
        ArrayList<ItemWrapper> wrapperList = new ArrayList<ItemWrapper>();
        for (Object o : cList) {
            wrapperList.add(new ItemWrapper(2, item.parent, o, false, null));
        }
        this.flatFilterList.addAll(pos + 1, wrapperList);
        this.notifyItemRangeInserted(pos + 1, wrapperList.size());
    }

    private void doCollapseList(int pos, ItemWrapper item) {
        item.isExpand = false;
        this.flatFilterList.removeAll(this.flatFilterList.subList(pos + 1, pos + 1 + item.cList.size()));
        this.notifyItemRangeRemoved(pos + 1, item.cList.size());
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void setList(List<P> parent, List<List<C>> child, boolean isExpand) {
        if (parent.size() != child.size() && child.size() != 0) {
            throw new IllegalArgumentException("\u7236\u957f\u5ea6\u4e0e\u5b50\u957f\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        this.parentList.clear();
        this.parentList.addAll(parent);
        this.childList.clear();
        this.childList.addAll(child);
        this.flatList.clear();
        int pSize = parent.size();
        boolean isChildISEmpty = child.size() == 0;
        for (int i = 0; i < pSize; ++i) {
            P item = this.parentList.get(i);
            ArrayList cList = isChildISEmpty ? new ArrayList() : this.childList.get(i);
            this.flatList.add(new ItemWrapper(1, item, null, isExpand, cList));
            if (!isExpand) continue;
            for (Object o : cList) {
                this.flatList.add(new ItemWrapper(2, item, o, false, null));
            }
        }
        this.flatFilterList.clear();
        this.flatFilterList.addAll(this.flatList);
        this.notifyDataSetChanged();
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void append(List<P> parent, List<List<C>> child) {
        if (parent.size() != child.size() && child.size() != 0) {
            throw new IllegalArgumentException("\u7236\u957f\u5ea6\u4e0e\u5b50\u957f\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        this.parentList.addAll(parent);
        this.childList.addAll(child);
        int pSize = parent.size();
        boolean isChildISEmpty = child.size() == 0;
        for (int i = 0; i < pSize; ++i) {
            P item = this.parentList.get(i);
            ArrayList cList = isChildISEmpty ? new ArrayList() : this.childList.get(i);
            this.flatList.add(new ItemWrapper(1, item, null, false, cList));
        }
        this.flatFilterList.clear();
        this.flatFilterList.addAll(this.flatList);
        this.notifyDataSetChanged();
    }

    public ItemWrapper getItemFromFlatList(int pos) {
        return this.flatFilterList.get(pos);
    }

    public int getItemViewType(int position) {
        return this.flatFilterList.get((int)position).type;
    }

    public int getItemCount() {
        return this.flatFilterList.size();
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void performFilter(CharSequence filter) {
        this.flatFilterList.clear();
        for (ItemWrapper wrapper : this.flatList) {
            if (!this.doFilter(filter, wrapper)) continue;
            this.flatFilterList.add(wrapper);
        }
        this.notifyDataSetChanged();
    }

    protected boolean doFilter(CharSequence filter, ItemWrapper wrapper) {
        return true;
    }

    protected abstract void onBindChild(RecyclerView.ViewHolder var1, C var2);

    protected abstract void onBindParent(RecyclerView.ViewHolder var1, P var2);

    public abstract RecyclerView.ViewHolder getParentViewHolder(ViewGroup var1);

    public abstract RecyclerView.ViewHolder getChildViewHolder(ViewGroup var1);

    public class ItemWrapper {
        public boolean isExpand;
        public int type;
        public C child;
        public P parent;
        public List<C> cList;

        public ItemWrapper(int type, P parent, C child, boolean isExpand, List<C> cList) {
            this.isExpand = isExpand;
            this.type = type;
            this.child = child;
            this.parent = parent;
            this.cList = cList;
        }
    }

    private static class SingleTapConfirm
    extends GestureDetector.SimpleOnGestureListener {
        private SingleTapConfirm() {
        }

        public boolean onSingleTapUp(MotionEvent event) {
            return true;
        }
    }
}

