/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.adapter;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import org.tcshare.androidutils.R;

public class DevAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<BluetoothDevice> datas = new ArrayList<BluetoothDevice>();
    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickLitener(OnItemClickListener mOnItemClickListener) {
        this.mOnItemClickListener = mOnItemClickListener;
    }

    public void setDatas(List<BluetoothDevice> list) {
        this.datas.clear();
        this.datas.addAll(list);
        this.notifyDataSetChanged();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_dev, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        BluetoothDevice item = this.datas.get(position);
        holder.mTvName.setText((CharSequence)item.getName());
        holder.mTvMac.setText((CharSequence)item.getAddress());
    }

    public int getItemViewType(int position) {
        return 3;
    }

    public int getItemCount() {
        return this.datas.size();
    }

    public void addItem(BluetoothDevice device) {
        this.datas.add(device);
        this.notifyItemChanged(this.datas.size() - 1);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void clear() {
        this.datas.clear();
        this.notifyDataSetChanged();
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, BluetoothDevice var2);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView mTvName;
        TextView mTvMac;
        Button mBtnConnect;

        public ViewHolder(View itemView) {
            super(itemView);
            this.mTvName = (TextView)itemView.findViewById(R.id.tv_name);
            this.mTvMac = (TextView)itemView.findViewById(R.id.tv_mac);
            this.mBtnConnect = (Button)itemView.findViewById(R.id.btn_connect);
            View.OnClickListener onItemClickListener = v -> {
                int pos = this.getAdapterPosition();
                try {
                    BluetoothDevice item = (BluetoothDevice)DevAdapter.this.datas.get(pos);
                    if (DevAdapter.this.mOnItemClickListener != null) {
                        DevAdapter.this.mOnItemClickListener.onItemClick(itemView, item);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            this.mBtnConnect.setOnClickListener(onItemClickListener);
        }
    }
}

