/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import androidx.documentfile.provider.DocumentFile;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.tcshare.androidutils.R;
import org.tcshare.fileselectorlib.FileSelectorSettings;
import org.tcshare.fileselectorlib.FileSelectorTheme;
import org.tcshare.fileselectorlib.Objects.BasicParams;
import org.tcshare.fileselectorlib.Objects.FileInfo;
import org.tcshare.fileselectorlib.Objects.FileList;
import org.tcshare.fileselectorlib.Threads.ListFileThread;
import org.tcshare.fileselectorlib.Utils.FileUtil;
import org.tcshare.fileselectorlib.Utils.PermissionUtil;
import org.tcshare.fileselectorlib.Utils.StatusBarUtil;
import org.tcshare.fileselectorlib.adapter.FileListAdapter;
import org.tcshare.fileselectorlib.adapter.NavigationAdapter;

public class TCFileSelectorActivity
extends AppCompatActivity {
    private static final int REQUEST_FOR_DATA_PATH = 20;
    public static final String RESULT_RECEIVER = "file_result_receiver";
    private ResultReceiver resultReceiver;
    private FileList fileList;
    private ArrayList<FileInfo> currentFileList = new ArrayList();
    private ArrayList<String> FileSelected = new ArrayList();
    private ArrayList<String> RelativePaths = new ArrayList();
    private String currentPath;
    private ListView lvFileList;
    private TextView tvTips;
    private TextView tv_select_num;
    private RelativeLayout llTopView;
    private ImageView imBack;
    private LinearLayout llBottomView;
    private Button select_confirm;
    private Button select_cancel;
    private RecyclerView navigation_view;
    private LinearLayout llRoot;
    private NavigationAdapter navigationAdapter;
    private ImageView imMore;
    private PopupWindow moreOptions;
    private SwipeRefreshLayout refreshLayout;
    private Window window;
    private AdapterView.OnItemClickListener onItemClickListener;
    private AdapterView.OnItemLongClickListener itemLongClickListener;
    private FileListAdapter fileListAdapter;
    private Context context;
    private SharedPreferences sharedPreferences;
    private ListFileThread.FileListHandler handler;
    private boolean init = true;
    private boolean onSelect = false;
    private int SelectNum = 0;
    private int parent_list_pos = 0;
    private Orientation orientation = Orientation.Init;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_file_selector);
        this.resultReceiver = (ResultReceiver)this.getIntent().getParcelableExtra(RESULT_RECEIVER);
        this.tv_select_num = (TextView)this.findViewById(R.id.select_num);
        this.tvTips = (TextView)this.findViewById(R.id.tips);
        this.lvFileList = (ListView)this.findViewById(R.id.FileList);
        this.imBack = (ImageView)this.findViewById(R.id.back);
        this.llTopView = (RelativeLayout)this.findViewById(R.id.top_view);
        this.llBottomView = (LinearLayout)this.findViewById(R.id.bottom_view);
        this.select_confirm = (Button)this.findViewById(R.id.select_confirm);
        this.select_cancel = (Button)this.findViewById(R.id.select_cancel);
        this.navigation_view = (RecyclerView)this.findViewById(R.id.navigation_view);
        this.llRoot = (LinearLayout)this.findViewById(R.id.root);
        this.imMore = (ImageView)this.findViewById(R.id.more);
        this.context = this;
        this.sharedPreferences = this.getSharedPreferences("FSConf", 0);
        this.setOnItemClick();
        this.setOnItemLongClick();
        this.initSelectNum();
        this.initTips();
        this.initBackBtn();
        this.initTopView();
        this.initBottomView();
        this.initRootButton();
        this.initMoreOptionsView();
        FileSelectorTheme theme = BasicParams.getInstance().getTheme();
        int theme_color = theme.getThemeColor();
        this.refreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.fs_refresh);
        this.refreshLayout.setColorSchemeColors(new int[]{theme_color});
        this.refreshLayout.setOnRefreshListener(() -> this.refreshFileList(this.currentPath, Orientation.Init));
        this.fileList = (FileList)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)ViewModelProvider.AndroidViewModelFactory.getInstance((Application)this.getApplication())).get(FileList.class);
        this.fileList.getFileList().observe((LifecycleOwner)this, fileInfo -> {
            this.currentFileList = fileInfo;
            if (this.init) {
                this.setFileList();
                this.init = false;
            }
            this.fileListAdapter.updateFileList(this.currentFileList);
            if (this.onSelect) {
                this.fileListAdapter.clearSelections();
            }
        });
        this.handler = new ListFileThread.FileListHandler(fileInfoList -> {
            if (fileInfoList.size() == 0) {
                if (this.refreshLayout.isRefreshing()) {
                    this.refreshLayout.setRefreshing(false);
                }
                return;
            }
            this.fileList.addToResult(fileInfoList);
            this.fileList.sortByName();
        });
        if (PermissionUtil.isStoragePermissionGranted((Activity)this)) {
            this.initFileList();
        }
    }

    public void onBackPressed() {
        if (this.onSelect) {
            this.quitSelectMod();
        } else if (!this.currentPath.equals(BasicParams.BasicPath)) {
            this.refreshFileList(new File(this.currentPath).getParent(), Orientation.Backward);
        } else {
            super.onBackPressed();
        }
    }

    private void initMoreOptionsView() {
        if (BasicParams.getInstance().isNeedMoreOptions()) {
            this.imMore.setVisibility(0);
        } else {
            this.imMore.setVisibility(4);
        }
        this.imMore.setOnClickListener(v -> {
            LinearLayout layout2 = (LinearLayout)LayoutInflater.from((Context)this).inflate(R.layout.popup_more_options, null);
            layout2.measure(0, 0);
            ListView listView = (ListView)layout2.findViewById(R.id.options);
            listView.setAdapter((ListAdapter)new ArrayAdapter((Context)this, R.layout.option_list_item, R.id.option_text, (Object[])BasicParams.getInstance().getOptionsName()));
            this.moreOptions = new PopupWindow((View)layout2, -2, -2);
            this.moreOptions.setFocusable(true);
            this.moreOptions.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.popwindow_white));
            this.BackGroundAlpha(0.6f);
            this.moreOptions.showAsDropDown((View)this.imMore, -layout2.getMeasuredWidth() + this.imMore.getWidth(), -this.imMore.getHeight() + 30);
            this.moreOptions.setOnDismissListener(() -> this.BackGroundAlpha(1.0f));
            listView.setOnItemClickListener((parent, view, position, id2) -> {
                this.moreOptions.dismiss();
                ArrayList<String> filePathList = new ArrayList<String>();
                for (FileInfo fi : this.currentFileList) {
                    if (fi.getFileType() == FileInfo.FileType.Parent) continue;
                    filePathList.add(fi.getFilePath());
                }
                BasicParams.getInstance().getOnOptionClicks()[position].onclick(this, this.currentPath, filePathList, this.FileSelected);
            });
        });
    }

    private void BackGroundAlpha(float f) {
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        layoutParams.alpha = f;
        this.getWindow().setAttributes(layoutParams);
    }

    private void initRootButton() {
        FileSelectorTheme theme = BasicParams.getInstance().getTheme();
        int naviBarTextColor = theme.getNaviBarTextColor();
        int naviBarTextSize = theme.getNaviBarTextSize();
        int naviBarArrowIcon = theme.getNaviBarArrowIcon();
        TextView tv_root_name = (TextView)this.findViewById(R.id.root_name);
        ImageView im_path_segment = (ImageView)this.findViewById(R.id.path_segment);
        tv_root_name.setTextColor(naviBarTextColor);
        tv_root_name.setTextSize((float)naviBarTextSize);
        im_path_segment.setImageResource(naviBarArrowIcon);
        this.llRoot.setOnClickListener(v -> {
            String rootPath = BasicParams.BasicPath;
            this.refreshFileList(rootPath, Orientation.Skip);
        });
    }

    private void setNavigationBar(String initPath) {
        this.RelativePaths = FileUtil.getRelativePaths(initPath);
        this.navigation_view.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 0, false));
        this.navigationAdapter = new NavigationAdapter((Context)this, this.RelativePaths);
        this.navigationAdapter.setRecycleItemClickListener((view, position) -> {
            List<String> sublist = this.RelativePaths.subList(0, position + 1);
            this.RelativePaths = new ArrayList<String>(sublist);
            if (Build.VERSION.SDK_INT >= 26) {
                this.refreshFileList(FileUtil.mergeAbsolutePath(this.RelativePaths), Orientation.Skip);
            }
        });
        this.navigation_view.setAdapter((RecyclerView.Adapter)this.navigationAdapter);
    }

    private void setFileList() {
        this.fileListAdapter = new FileListAdapter(this.currentFileList, (Context)this);
        this.lvFileList.setAdapter((ListAdapter)this.fileListAdapter);
        this.lvFileList.setOnItemClickListener(this.onItemClickListener);
        this.lvFileList.setOnItemLongClickListener(this.itemLongClickListener);
    }

    private void initBottomView() {
        this.BottomViewShow(4, 0);
        this.select_confirm.setOnClickListener(v -> {
            Bundle bundle_back = new Bundle();
            bundle_back.putStringArrayList(FileSelectorSettings.FILE_PATH_LIST_REQUEST, this.FileSelected);
            this.resultReceiver.send(FileSelectorSettings.BACK_WITH_SELECTIONS, bundle_back);
            this.finish();
        });
        this.select_cancel.setOnClickListener(v -> this.quitSelectMod());
    }

    private void quitSelectMod() {
        this.fileListAdapter.clearSelections();
        this.fileListAdapter.setSelect(false);
        this.BottomViewShow(4, 0);
        this.onSelect = false;
        this.SelectNum = 0;
        this.FileSelected.clear();
        this.changeSelectNum(0);
        this.tv_select_num.setVisibility(4);
    }

    private void setOnItemLongClick() {
        this.itemLongClickListener = (parent, view, position, id2) -> {
            if (!this.onSelect && this.currentFileList.get(position).getFileType() != FileInfo.FileType.Parent) {
                if (BasicParams.getInstance().getMaxSelectNum() != -1) {
                    this.tv_select_num.setVisibility(0);
                }
                this.BottomViewShow(0, 140);
                this.fileListAdapter.clearSelections();
                this.fileListAdapter.setSelect(true);
                this.onSelect = true;
            }
            return true;
        };
    }

    private void BottomViewShow(int visible, int i) {
        this.llBottomView.setVisibility(visible);
        ViewGroup.LayoutParams params = this.llBottomView.getLayoutParams();
        params.height = i;
        this.llBottomView.setLayoutParams(params);
    }

    private void initBackBtn() {
        this.imBack.setOnClickListener(v -> {
            this.setResult(FileSelectorSettings.BACK_WITHOUT_SELECT);
            this.resultReceiver.send(FileSelectorSettings.BACK_WITHOUT_SELECT, new Bundle());
            this.finish();
        });
    }

    private void initTopView() {
        FileSelectorTheme theme = BasicParams.getInstance().getTheme();
        int theme_color = theme.getThemeColor();
        int back_icon_id = theme.getTopToolBarBackIcon();
        int title_color = theme.getTopToolBarTitleColor();
        int title_size = theme.getTopToolBarTitleSize();
        int menu_icon_id = theme.getTopToolBarMenuIcon();
        this.llTopView.setBackgroundColor(theme_color);
        ImageView back_arrow = (ImageView)this.findViewById(R.id.back);
        back_arrow.setImageResource(back_icon_id);
        this.tvTips.setTextColor(title_color);
        this.tvTips.setTextSize((float)title_size);
        this.tv_select_num.setTextColor(title_color);
        this.tv_select_num.setTextSize((float)title_size);
        this.imMore.setImageResource(menu_icon_id);
        this.window = this.getWindow();
        this.window.clearFlags(1024);
        this.window.setStatusBarColor(theme_color);
        if (ColorUtils.calculateLuminance((int)theme_color) > 0.5) {
            StatusBarUtil.setStatusBarDarkTheme((Activity)this, true);
        } else {
            StatusBarUtil.setStatusBarDarkTheme((Activity)this, false);
        }
    }

    private void initTips() {
        this.tvTips.setText((CharSequence)BasicParams.getInstance().getTips());
    }

    private void initSelectNum() {
        this.changeSelectNum(0);
        this.tv_select_num.setVisibility(4);
    }

    private void changeSelectNum(int num) {
        String selectNum = this.getString(R.string.selectNum);
        selectNum = String.format(selectNum, num, BasicParams.getInstance().getMaxSelectNum());
        this.tv_select_num.setText((CharSequence)selectNum);
    }

    private boolean reachSelectNumLimit(int selectNum) {
        int maxSelectNum = BasicParams.getInstance().getMaxSelectNum();
        if (maxSelectNum == -1) {
            return false;
        }
        return selectNum >= maxSelectNum;
    }

    private void setOnItemClick() {
        this.onItemClickListener = (parent, view, position, id2) -> {
            FileInfo file_select = this.currentFileList.get(position);
            if (this.onSelect && file_select.getFileType() != FileInfo.FileType.Parent) {
                FileListAdapter.ViewHolder viewHolder = (FileListAdapter.ViewHolder)view.getTag();
                if (file_select.FileFilter(BasicParams.getInstance().getSelectableFileTypes())) {
                    if (!this.reachSelectNumLimit(this.SelectNum) || viewHolder.ckSelector.isChecked()) {
                        viewHolder.ckSelector.toggle();
                        if (file_select.getFileType() != FileInfo.FileType.Parent) {
                            this.fileListAdapter.notifyFileSelected(position, viewHolder.ckSelector.isChecked());
                            if (viewHolder.ckSelector.isChecked()) {
                                this.FileSelected.add(file_select.getFilePath());
                            } else {
                                this.FileSelected.remove(file_select.getFilePath());
                            }
                            this.SelectNum = this.FileSelected.size();
                            this.changeSelectNum(this.SelectNum);
                        }
                    }
                } else {
                    Toast.makeText((Context)this, (CharSequence)"\u8be5\u6587\u4ef6\u7c7b\u578b\u4e0d\u53ef\u9009", (int)0).show();
                }
            } else if (file_select.getFileType() == FileInfo.FileType.Folder) {
                this.parent_list_pos = this.lvFileList.getFirstVisiblePosition();
                this.refreshFileList(file_select, Orientation.Forward);
            } else if (file_select.getFileType() == FileInfo.FileType.Parent) {
                this.refreshFileList(file_select, Orientation.Backward);
            }
        };
    }

    private void refreshFileList(FileInfo parent, Orientation orientation) {
        String path;
        if (!PermissionUtil.isStoragePermissionGranted((Activity)this)) {
            return;
        }
        if (!this.refreshLayout.isRefreshing()) {
            this.refreshLayout.setRefreshing(true);
        }
        this.orientation = orientation;
        this.currentPath = path = parent.getFilePath();
        this.startListFileThread(parent);
        this.RelativePaths = FileUtil.getRelativePaths(path);
        this.navigationAdapter.UpdatePathList(this.RelativePaths);
        this.navigation_view.scrollToPosition(this.navigationAdapter.getItemCount() - 1);
        if (this.onSelect) {
            this.fileListAdapter.clearSelections();
        }
    }

    private void refreshFileList(String parent_path, Orientation orientation) {
        if (!PermissionUtil.isStoragePermissionGranted((Activity)this)) {
            return;
        }
        if (!this.refreshLayout.isRefreshing()) {
            this.refreshLayout.setRefreshing(true);
        }
        this.orientation = orientation;
        this.currentPath = parent_path;
        this.startListFileThread(parent_path);
        this.RelativePaths = FileUtil.getRelativePaths(parent_path);
        this.navigationAdapter.UpdatePathList(this.RelativePaths);
        this.navigation_view.scrollToPosition(this.navigationAdapter.getItemCount() - 1);
        if (this.onSelect) {
            this.fileListAdapter.clearSelections();
        }
    }

    private void startListFileThread(String initPath) {
        File file = new File(initPath);
        FileInfo initFile = new FileInfo();
        initFile.setFileName(file.getName());
        initFile.setAccessType(FileInfo.judgeAccess(initPath));
        initFile.setFileType(file.isDirectory() ? FileInfo.FileType.Folder : FileInfo.FileType.Unknown);
        initFile.setFilePath(initPath);
        this.startListFileThread(initFile);
    }

    private void startListFileThread(FileInfo parent) {
        this.fileList.clear();
        File initFile = new File(parent.getFilePath());
        if (!parent.getFilePath().equals(BasicParams.BasicPath)) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileName("\u8fd4\u56de\u4e0a\u4e00\u7ea7");
            fileInfo.setFileLastUpdateTime("");
            fileInfo.setFileType(FileInfo.FileType.Parent);
            fileInfo.setFilePath(initFile.getParent());
            fileInfo.setFileCount(-1L);
            fileInfo.setAccessType(FileInfo.judgeAccess(fileInfo.getFilePath()));
            this.fileList.addToResult(fileInfo);
        }
        if (parent.getAccessType() == FileInfo.AccessType.Open) {
            File[] files = initFile.listFiles();
            if (files == null) {
                if (parent.getFilePath().contains("Android/data")) {
                    Log.d((String)"list file", (String)"enter Android/data");
                    this.handleProtectedFiles(parent);
                } else if (parent.getFilePath().contains("Android/obb")) {
                    this.handleProtectedFiles(parent);
                } else {
                    Log.d((String)"list file", (String)"can not list file");
                    if (this.refreshLayout.isRefreshing()) {
                        this.refreshLayout.setRefreshing(false);
                    }
                    return;
                }
            }
            this.handleNormalFiles(files);
        } else {
            this.handleProtectedFiles(parent);
        }
    }

    private void handleNormalFiles(File[] files) {
        int step = 20;
        int parts = files.length / step;
        parts = files.length % step == 0 ? parts : parts + 1;
        CountDownLatch countDownLatch = new CountDownLatch(parts);
        for (int i = 0; i < files.length; i += step) {
            File[] subFiles = new File[i + step > files.length ? files.length - i : step];
            System.arraycopy(files, i, subFiles, 0, subFiles.length);
            ListFileThread thread = new ListFileThread(subFiles);
            thread.setHandler(this.handler);
            thread.setCountDownLatch(countDownLatch);
            thread.start();
        }
        new Thread(() -> {
            try {
                countDownLatch.await();
                this.runOnUiThread(() -> {
                    if (this.orientation == Orientation.Backward) {
                        this.lvFileList.post(() -> this.lvFileList.setSelection(this.parent_list_pos));
                    }
                    if (this.refreshLayout.isRefreshing()) {
                        this.refreshLayout.setRefreshing(false);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    private void handleProtectedFiles(FileInfo parent) {
        String grant_key = "";
        if (parent.getFilePath().contains("Android/data")) {
            grant_key = "data_path_granted";
        }
        if (parent.getFilePath().contains("Android/obb")) {
            grant_key = "obb_path_granted";
        }
        boolean data_all_granted = this.sharedPreferences.getBoolean(grant_key, false);
        boolean granted = FileUtil.isGrant(this.context, parent.getFilePath());
        if (!granted && !data_all_granted) {
            this.grantPermissionForProtectedFile(parent.getFilePath());
        } else {
            DocumentFile documentFile = FileUtil.getDocumentFilePath(this.context, parent.getFilePath());
            if (documentFile == null) {
                Toast.makeText((Context)this.context, (CharSequence)"\u8be5\u8def\u5f84\u65e0\u6cd5\u8bc6\u522b", (int)0).show();
                if (this.refreshLayout.isRefreshing()) {
                    this.refreshLayout.setRefreshing(false);
                }
                return;
            }
            if (documentFile.isDirectory()) {
                DocumentFile[] documentFiles = documentFile.listFiles();
                int parts = documentFiles.length / 20;
                CountDownLatch countDownLatch = new CountDownLatch(parts + 1);
                int index = 0;
                boolean isEmpty = false;
                for (int i = 0; i < parts + 1; ++i) {
                    int size = 20;
                    if (i == parts) {
                        size = documentFiles.length % 20;
                    }
                    if (size == 0) {
                        isEmpty = true;
                        break;
                    }
                    DocumentFile[] sub_files = new DocumentFile[size];
                    for (int j = 0; j < size; ++j) {
                        sub_files[j] = documentFiles[index];
                        ++index;
                    }
                    ListFileThread thread = new ListFileThread(sub_files);
                    thread.setHandler(this.handler);
                    thread.setCountDownLatch(countDownLatch);
                    thread.start();
                }
                if (isEmpty) {
                    if (this.refreshLayout.isRefreshing()) {
                        this.refreshLayout.setRefreshing(false);
                    }
                    return;
                }
                new Thread(() -> {
                    try {
                        countDownLatch.await();
                        this.runOnUiThread(() -> {
                            if (this.orientation == Orientation.Backward) {
                                this.lvFileList.post(() -> this.lvFileList.setSelection(this.parent_list_pos));
                            }
                            if (this.refreshLayout.isRefreshing()) {
                                this.refreshLayout.setRefreshing(false);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        }
    }

    private void grantPermissionForProtectedFile(String path) {
        String uri = FileUtil.changeToUriAndroidOrigin(path);
        Uri parse = Uri.parse((String)uri);
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
        intent.addFlags(195);
        if (Build.VERSION.SDK_INT >= 26) {
            intent.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)parse);
        }
        this.startActivityForResult(intent, 20);
    }

    public void updateFileSelectList(List<Integer> select_index_list) {
        if (!this.onSelect) {
            return;
        }
        this.fileListAdapter.clearSelections();
        this.FileSelected.clear();
        for (Integer index : select_index_list) {
            this.fileListAdapter.notifyFileSelected(index + 1, true);
            this.FileSelected.add(this.currentFileList.get(index + 1).getFilePath());
        }
        this.SelectNum = this.FileSelected.size();
        this.changeSelectNum(this.SelectNum);
    }

    public void updateFileList(String new_path) {
        this.refreshFileList(new_path, Orientation.Skip);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.v((String)"permission", (String)("onRequestPermissionsResult requestCode \uff1a " + requestCode + " Permission: " + permissions[0] + " was " + grantResults[0] + " Permission: " + permissions[1] + " was " + grantResults[1]));
        if (grantResults[0] == 0) {
            Log.i((String)"permission", (String)"granted");
            this.initFileList();
        } else {
            Toast.makeText((Context)this.context, (CharSequence)"\u672a\u83b7\u5f97\u6587\u4ef6\u8bfb\u5199\u6743\u9650", (int)0).show();
        }
    }

    private void initFileList() {
        if (!this.refreshLayout.isRefreshing()) {
            this.refreshLayout.setRefreshing(true);
        }
        String initPath = BasicParams.getInstance().getRootPath();
        File[] test = new File(initPath).listFiles();
        DocumentFile documentFile = FileUtil.getDocumentFilePath(this.context, initPath);
        if (test == null && documentFile == null) {
            initPath = BasicParams.BasicPath;
        }
        this.startListFileThread(initPath);
        this.currentPath = initPath;
        this.setNavigationBar(initPath);
    }

    @SuppressLint(value={"WrongConstant"})
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        Uri uri;
        super.onActivityResult(requestCode, resultCode, data);
        if (this.refreshLayout.isRefreshing()) {
            this.refreshLayout.setRefreshing(false);
        }
        if (data == null & requestCode == 20) {
            Log.d((String)"file permission", (String)"request permission failed");
            return;
        }
        if (requestCode == 20 && (uri = data.getData()) != null) {
            this.getContentResolver().takePersistableUriPermission(uri, data.getFlags() & 3);
            String grant_key = "";
            if (this.currentPath.contains("Android/data")) {
                grant_key = "data_path_granted";
            }
            if (this.currentPath.contains("Android/obb")) {
                grant_key = "obb_path_granted";
            }
            this.sharedPreferences.edit().putBoolean(grant_key, true).apply();
            this.refreshFileList(this.currentPath, Orientation.Forward);
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private static enum Orientation {
        Forward,
        Backward,
        Init,
        Skip;

    }
}

