/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.rabbitmq.stream.metrics.MetricsCollector;

public class DropwizardMetricsCollector
implements MetricsCollector {
    private final Counter connections;
    private final Meter publish;
    private final Meter publishConfirm;
    private final Meter publishError;
    private final Meter chunk;
    private final Meter consume;
    private final Meter writtenBytes;
    private final Meter readBytes;
    private final Counter outstandingPublishConfirm;
    private final Histogram chunkSize;

    public DropwizardMetricsCollector(MetricRegistry registry, String metricsPrefix) {
        this.connections = registry.counter(metricsPrefix + ".connections");
        this.publish = registry.meter(metricsPrefix + ".published");
        this.publishConfirm = registry.meter(metricsPrefix + ".confirmed");
        this.publishError = registry.meter(metricsPrefix + ".errored");
        this.chunk = registry.meter(metricsPrefix + ".chunk");
        this.chunkSize = registry.histogram(metricsPrefix + ".chunk_size");
        this.consume = registry.meter(metricsPrefix + ".consumed");
        this.writtenBytes = registry.meter(metricsPrefix + ".written_bytes");
        this.readBytes = registry.meter(metricsPrefix + ".read_bytes");
        this.outstandingPublishConfirm = registry.counter(metricsPrefix + ".outstanding_publish_confirm");
    }

    public DropwizardMetricsCollector() {
        this(new MetricRegistry());
    }

    public DropwizardMetricsCollector(MetricRegistry metricRegistry) {
        this(metricRegistry, "rabbitmq.stream");
    }

    @Override
    public void openConnection() {
        this.connections.inc();
    }

    @Override
    public void closeConnection() {
        this.connections.dec();
    }

    @Override
    public void publish(int count) {
        this.publish.mark((long)count);
        this.outstandingPublishConfirm.inc((long)count);
    }

    @Override
    public void publishConfirm(int count) {
        this.publishConfirm.mark((long)count);
        this.outstandingPublishConfirm.dec((long)count);
    }

    @Override
    public void publishError(int count) {
        this.publishError.mark((long)count);
        this.outstandingPublishConfirm.dec((long)count);
    }

    @Override
    public void chunk(int entriesCount) {
        this.chunk.mark();
        this.chunkSize.update(entriesCount);
    }

    @Override
    public void consume(long count) {
        this.consume.mark(count);
    }

    @Override
    public void writtenBytes(int writtenBytes) {
        this.writtenBytes.mark((long)writtenBytes);
    }

    @Override
    public void readBytes(int readBytes) {
        this.readBytes.mark((long)readBytes);
    }
}

