/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.ChunkChecksum;
import com.rabbitmq.stream.ChunkChecksumValidationException;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

class JdkChunkChecksum
implements ChunkChecksum {
    private static final Supplier<Checksum> CRC32_SUPPLIER = CRC32::new;
    static final ChunkChecksum CRC32_SINGLETON = new JdkChunkChecksum(CRC32_SUPPLIER);
    private final Supplier<Checksum> checksumSupplier;

    JdkChunkChecksum(Supplier<Checksum> checksumSupplier) {
        this.checksumSupplier = checksumSupplier;
    }

    @Override
    public void checksum(ByteBuf byteBuf, long dataLength, long expected) {
        Checksum checksum = this.checksumSupplier.get();
        if (byteBuf.hasArray()) {
            checksum.update(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), byteBuf.readableBytes());
        } else {
            checksum.update(byteBuf.nioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes()));
        }
        if (expected != checksum.getValue()) {
            throw new ChunkChecksumValidationException(expected, checksum.getValue());
        }
    }
}

