/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ByteCapacity
implements Comparable<ByteCapacity> {
    private static final String UNIT_MB = "mb";
    private static final int KILOBYTES_MULTIPLIER = 1000;
    private static final int MEGABYTES_MULTIPLIER = 1000000;
    private static final int GIGABYTES_MULTIPLIER = 1000000000;
    private static final long TERABYTES_MULTIPLIER = 1000000000000L;
    private static final Pattern PATTERN = Pattern.compile("^(?<size>\\d*)((?<unit>kb|mb|gb|tb))?$", 2);
    private static final String GROUP_SIZE = "size";
    private static final String GROUP_UNIT = "unit";
    private static final String UNIT_KB = "kb";
    private static final String UNIT_GB = "gb";
    private static final String UNIT_TB = "tb";
    private static final Map<String, BiFunction<Long, String, ByteCapacity>> CONSTRUCTORS = Map.of("kb", ByteCapacity::kB, "mb", ByteCapacity::MB, "gb", ByteCapacity::GB, "tb", ByteCapacity::TB);
    private final long bytes;
    private final String input;

    private ByteCapacity(long bytes) {
        this(bytes, String.valueOf(bytes));
    }

    private ByteCapacity(long bytes, String input) {
        this.bytes = bytes;
        this.input = input;
    }

    public static ByteCapacity B(long bytes) {
        return new ByteCapacity(bytes);
    }

    public static ByteCapacity kB(long kilobytes) {
        return new ByteCapacity(kilobytes * 1000L);
    }

    public static ByteCapacity MB(long megabytes) {
        return new ByteCapacity(megabytes * 1000000L);
    }

    public static ByteCapacity GB(long gigabytes) {
        return new ByteCapacity(gigabytes * 1000000000L);
    }

    public static ByteCapacity TB(long terabytes) {
        return new ByteCapacity(terabytes * 1000000000000L);
    }

    private static ByteCapacity kB(long kilobytes, String input) {
        return new ByteCapacity(kilobytes * 1000L, input);
    }

    private static ByteCapacity MB(long megabytes, String input) {
        return new ByteCapacity(megabytes * 1000000L, input);
    }

    private static ByteCapacity GB(long gigabytes, String input) {
        return new ByteCapacity(gigabytes * 1000000000L, input);
    }

    private static ByteCapacity TB(long terabytes, String input) {
        return new ByteCapacity(terabytes * 1000000000000L, input);
    }

    public long toBytes() {
        return this.bytes;
    }

    public static ByteCapacity from(String value) {
        Matcher matcher = PATTERN.matcher(value);
        if (matcher.matches()) {
            long size = Long.parseLong(matcher.group(GROUP_SIZE));
            String unit = matcher.group(GROUP_UNIT);
            if (unit != null) {
                return CONSTRUCTORS.getOrDefault(unit.toLowerCase(), (v, input) -> {
                    throw new IllegalArgumentException("Unknown capacity unit: " + unit);
                }).apply(size, value);
            }
            ByteCapacity result = ByteCapacity.B(size);
            return result;
        }
        throw new IllegalArgumentException("Cannot parse value for byte capacity: " + value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteCapacity that = (ByteCapacity)o;
        return this.bytes == that.bytes;
    }

    public int hashCode() {
        return Objects.hash(this.bytes);
    }

    public String toString() {
        return this.input;
    }

    @Override
    public int compareTo(ByteCapacity other) {
        return Long.compare(this.bytes, other.bytes);
    }
}

