/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream;

import com.rabbitmq.stream.MessageHandler;
import java.util.concurrent.atomic.AtomicLong;

public interface ConsumerFlowStrategy {
    public int initialCredits();

    public MessageProcessedCallback start(Context var1);

    public static ConsumerFlowStrategy creditOnChunkArrival() {
        return ConsumerFlowStrategy.creditOnChunkArrival(1);
    }

    public static ConsumerFlowStrategy creditOnChunkArrival(int initialCredits) {
        return new CreditOnChunkArrivalConsumerFlowStrategy(initialCredits);
    }

    public static ConsumerFlowStrategy creditWhenHalfMessagesProcessed() {
        return ConsumerFlowStrategy.creditOnProcessedMessageCount(1, 0.5);
    }

    public static ConsumerFlowStrategy creditWhenHalfMessagesProcessed(int initialCredits) {
        return ConsumerFlowStrategy.creditOnProcessedMessageCount(initialCredits, 0.5);
    }

    public static ConsumerFlowStrategy creditOnProcessedMessageCount(int initialCredits, double ratio) {
        return new MessageCountConsumerFlowStrategy(initialCredits, ratio);
    }

    public static class MessageCountConsumerFlowStrategy
    implements ConsumerFlowStrategy {
        private final int initialCredits;
        private final double ratio;

        private MessageCountConsumerFlowStrategy(int initialCredits, double ratio) {
            this.initialCredits = initialCredits;
            this.ratio = ratio;
        }

        @Override
        public int initialCredits() {
            return this.initialCredits;
        }

        @Override
        public MessageProcessedCallback start(Context context) {
            long l = (long)((double)context.messageCount() * this.ratio);
            long limit = Math.max(1L, l);
            AtomicLong processedMessages = new AtomicLong(0L);
            return messageOffset -> {
                if (processedMessages.incrementAndGet() == limit) {
                    context.credits(1);
                }
            };
        }
    }

    public static class CreditOnChunkArrivalConsumerFlowStrategy
    implements ConsumerFlowStrategy {
        private final int initialCredits;

        private CreditOnChunkArrivalConsumerFlowStrategy(int initialCredits) {
            this.initialCredits = initialCredits;
        }

        @Override
        public int initialCredits() {
            return this.initialCredits;
        }

        @Override
        public MessageProcessedCallback start(Context context) {
            context.credits(1);
            return value -> {};
        }
    }

    @FunctionalInterface
    public static interface MessageProcessedCallback {
        public void processed(MessageHandler.Context var1);
    }

    public static interface Context {
        public void credits(int var1);

        public long messageCount();
    }
}

