/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.sql.SqlExpressionType;
import java.util.List;

class SqlExpressionValue {
    private SqlExpressionType expType;
    private Object expValue;

    SqlExpressionValue() {
        this(SqlExpressionType.NOT_SET, null);
    }

    private SqlExpressionValue(SqlExpressionType expType, Object expValue) {
        this.expType = expType;
        this.expValue = SqlExpressionValue.filterValType(expType, expValue);
    }

    SqlExpressionType getType() {
        return this.expType;
    }

    void setType(SqlExpressionType expType) {
        this.expType = expType;
        this.expValue = null;
    }

    Object getValue() {
        return this.expValue;
    }

    void setValue(Object val) {
        this.expValue = SqlExpressionValue.filterValType(this.expType, val);
    }

    private static final Object filterValType(SqlExpressionType type, Object val) {
        if (val == null) {
            return null;
        }
        switch (type) {
            case ANY: {
                return SqlExpressionValue.filter(val, String.class, Boolean.class, Float.class, Double.class, Integer.class, Long.class);
            }
            case ARITH: {
                return SqlExpressionValue.filter(val, Float.class, Double.class, Integer.class, Long.class);
            }
            case BOOL: {
                return SqlExpressionValue.filter(val, Boolean.class);
            }
            case LIST: {
                return SqlExpressionValue.filter(val, List.class);
            }
            case STRING: {
                return SqlExpressionValue.filter(val, String.class);
            }
        }
        return null;
    }

    private static final Object filter(Object val, Class<?> ... clzs) {
        for (Class<?> clz : clzs) {
            if (!clz.isInstance(val)) continue;
            return val;
        }
        return null;
    }

    public String toString() {
        return String.format("<%s: %s>", new Object[]{this.expType, this.expValue});
    }
}

