/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ShovelDetails {
    @JsonProperty(value="src-uri")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private List<String> sourceURIs;
    @JsonProperty(value="src-exchange")
    private String sourceExchange;
    @JsonProperty(value="src-exchange-key")
    private String sourceExchangeKey;
    @JsonProperty(value="src-queue")
    private String sourceQueue;
    @JsonProperty(value="src-prefetch-count")
    private Long sourcePrefetchCount;
    @JsonProperty(value="src-delete-after")
    private String sourceDeleteAfter;
    @JsonProperty(value="dest-uri")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED})
    private List<String> destinationURIs;
    @JsonProperty(value="dest-exchange")
    private String destinationExchange;
    @JsonProperty(value="dest-exchange-key")
    private String destinationExchangeKey;
    @JsonProperty(value="dest-queue")
    private String destinationQueue;
    @JsonProperty(value="dest-add-timestamp-header")
    private Boolean destinationAddTimestampHeader;
    @JsonProperty(value="reconnect-delay")
    private long reconnectDelay;
    @JsonProperty(value="add-forward-headers")
    private boolean addForwardHeaders;
    @JsonProperty(value="ack-mode")
    private String ackMode;
    @JsonProperty(value="publish-properties")
    private Map<String, Object> publishProperties;

    public ShovelDetails() {
    }

    public ShovelDetails(String sourceURI, String destURI, long reconnectDelay, boolean addForwardHeaders, Map<String, Object> publishProperties) {
        this(Collections.singletonList(sourceURI), Collections.singletonList(destURI), reconnectDelay, addForwardHeaders, publishProperties);
    }

    public ShovelDetails(List<String> sourceURIs, List<String> destURIs, long reconnectDelay, boolean addForwardHeaders, Map<String, Object> publishProperties) {
        ShovelDetails.checkURIsArgument("sourceURIs", sourceURIs);
        ShovelDetails.checkURIsArgument("destURIs", destURIs);
        this.sourceURIs = Collections.unmodifiableList(sourceURIs);
        this.destinationURIs = Collections.unmodifiableList(destURIs);
        this.reconnectDelay = reconnectDelay;
        this.addForwardHeaders = addForwardHeaders;
        this.publishProperties = publishProperties;
    }

    public List<String> getSourceURIs() {
        return this.sourceURIs;
    }

    public void setSourceURIs(List<String> sourceURIs) {
        ShovelDetails.checkURIsArgument("sourceURIs", sourceURIs);
        this.sourceURIs = Collections.unmodifiableList(sourceURIs);
    }

    public String getSourceExchange() {
        return this.sourceExchange;
    }

    public void setSourceExchange(String sourceExchange) {
        this.sourceExchange = sourceExchange;
    }

    public String getSourceExchangeKey() {
        return this.sourceExchangeKey;
    }

    public void setSourceExchangeKey(String sourceExchangeKey) {
        this.sourceExchangeKey = sourceExchangeKey;
    }

    public String getSourceQueue() {
        return this.sourceQueue;
    }

    public void setSourceQueue(String sourceQueue) {
        this.sourceQueue = sourceQueue;
    }

    public List<String> getDestinationURIs() {
        return this.destinationURIs;
    }

    public void setDestinationURIs(List<String> destURIs) {
        ShovelDetails.checkURIsArgument("destURIs", destURIs);
        this.destinationURIs = Collections.unmodifiableList(destURIs);
    }

    public String getDestinationExchange() {
        return this.destinationExchange;
    }

    public void setDestinationExchange(String destExchange) {
        this.destinationExchange = destExchange;
    }

    public String getDestinationExchangeKey() {
        return this.destinationExchangeKey;
    }

    public void setDestinationExchangeKey(String destExchangeKey) {
        this.destinationExchangeKey = destExchangeKey;
    }

    public String getDestinationQueue() {
        return this.destinationQueue;
    }

    public void setDestinationQueue(String destQueue) {
        this.destinationQueue = destQueue;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public boolean isAddForwardHeaders() {
        return this.addForwardHeaders;
    }

    public void setAddForwardHeaders(boolean addForwardHeaders) {
        this.addForwardHeaders = addForwardHeaders;
    }

    public String getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(String ackMode) {
        this.ackMode = ackMode;
    }

    public Map<String, Object> getPublishProperties() {
        return this.publishProperties;
    }

    public void setPublishProperties(Map<String, Object> publishProperties) {
        this.publishProperties = publishProperties;
    }

    public Long getSourcePrefetchCount() {
        return this.sourcePrefetchCount;
    }

    public void setSourcePrefetchCount(Long sourcePrefetchCount) {
        this.sourcePrefetchCount = sourcePrefetchCount;
    }

    public String getSourceDeleteAfter() {
        return this.sourceDeleteAfter;
    }

    public void setSourceDeleteAfter(String sourceDeleteAfter) {
        this.sourceDeleteAfter = sourceDeleteAfter;
    }

    public Boolean isDestinationAddTimestampHeader() {
        return this.destinationAddTimestampHeader;
    }

    public void setDestinationAddTimestampHeader(Boolean destinationAddTimestampHeader) {
        this.destinationAddTimestampHeader = destinationAddTimestampHeader;
    }

    public String toString() {
        return "ShovelDetails{sourceURIs='" + ShovelDetails.URIsToString(this.sourceURIs) + "', sourceExchange='" + this.sourceExchange + "', sourceExchangeKey='" + this.sourceExchangeKey + "', sourceQueue='" + this.sourceQueue + "', sourcePrefetchCount='" + this.sourcePrefetchCount + "', sourceDeleteAfter='" + this.sourceDeleteAfter + "', destinationURIs='" + ShovelDetails.URIsToString(this.destinationURIs) + "', destinationExchange='" + this.destinationExchange + "', destinationExchangeKey='" + this.destinationExchangeKey + "', destinationQueue='" + this.destinationQueue + "', destinationAddTimestampHeader=" + this.destinationAddTimestampHeader + ", reconnectDelay=" + this.reconnectDelay + ", addForwardHeaders=" + this.addForwardHeaders + ", ackMode='" + this.ackMode + "', publishProperties=" + String.valueOf(this.publishProperties) + "}";
    }

    private static void checkURIsArgument(String argumentName, List<String> argument) {
        if (argument == null || argument.isEmpty()) {
            throw new IllegalArgumentException(argumentName + " argument must contains at least one URI");
        }
    }

    private static String URIsToString(List<String> uris) {
        if (uris.size() == 1) {
            return uris.get(0);
        }
        return Arrays.toString(uris.toArray());
    }
}

