/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client.domain;

import com.rabbitmq.http.client.domain.Page;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryParameters {
    private final Map<String, Object> parameters;
    private final Pagination pagination = new Pagination();
    private final Columns columns = new Columns();

    public QueryParameters() {
        this(new HashMap<String, Object>());
    }

    QueryParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Pagination pagination() {
        return this.pagination;
    }

    public QueryParameters name(String name) {
        this.name(name, false);
        return this;
    }

    public QueryParameters name(String name, boolean usesRegex) {
        this.parameters.put("name", name);
        this.parameters.put("use_regex", usesRegex);
        this.pagination.setFirstPageIfNotSet();
        return this;
    }

    public Columns columns() {
        return this.columns;
    }

    public QueryParameters clear() {
        this.parameters.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public Map<String, String> parameters() {
        return this.parameters.entrySet().stream().reduce(new LinkedHashMap(), (acc, entry) -> {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            String valueAsString = value instanceof Collection ? String.join((CharSequence)",", (Iterable)value) : String.valueOf(value);
            acc.put(name, valueAsString);
            return acc;
        }, (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        });
    }

    QueryParameters parameter(String field, Object value) {
        this.parameters.put(field, value);
        return this;
    }

    public class Pagination {
        public Pagination pageSize(int pageSize) {
            QueryParameters.this.parameters.put("page_size", pageSize);
            this.setFirstPageIfNotSet();
            return this;
        }

        private void setFirstPageIfNotSet() {
            QueryParameters.this.parameters.putIfAbsent("page", 1);
        }

        public Pagination nextPage(Page page) {
            QueryParameters.this.parameters.put("page", page.getPage() + 1);
            return this;
        }

        public Pagination clear() {
            QueryParameters.this.parameters.remove("name");
            QueryParameters.this.parameters.remove("use_regex");
            QueryParameters.this.parameters.remove("page_size");
            QueryParameters.this.parameters.remove("page");
            return this;
        }

        public QueryParameters query() {
            return QueryParameters.this;
        }

        public boolean hasAny() {
            return QueryParameters.this.parameters.containsKey("name") || QueryParameters.this.parameters.containsKey("page_size") || QueryParameters.this.parameters.containsKey("page");
        }
    }

    public class Columns {
        public Columns add(String name) {
            HashSet<String> columns = (HashSet<String>)QueryParameters.this.parameters.get("columns");
            if (columns == null) {
                columns = new HashSet<String>();
                QueryParameters.this.parameters.put("columns", columns);
            }
            columns.add(name);
            return this;
        }

        public Columns sort(String name) {
            QueryParameters.this.parameters.put("sort", name);
            return this;
        }

        public Columns sortReverse(boolean sortReverse) {
            QueryParameters.this.parameters.put("sort_reverse", sortReverse);
            return this;
        }

        public Columns clear() {
            QueryParameters.this.parameters.remove("columns");
            QueryParameters.this.parameters.remove("sort");
            QueryParameters.this.parameters.remove("sort_reverse");
            return this;
        }

        public QueryParameters query() {
            return QueryParameters.this;
        }

        public boolean hasAny() {
            return QueryParameters.this.parameters.containsKey("columns") || QueryParameters.this.parameters.containsKey("sort") || QueryParameters.this.parameters.containsKey("sort_reverse");
        }
    }
}

