/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client.domain;

import com.rabbitmq.http.client.domain.QueryParameters;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class DetailsParameters {
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private QueryParameters queryParameters;

    private static void checkGreaterThanZero(int value, String field) {
        if (value <= 0) {
            throw new IllegalArgumentException(String.format("'%s' must be greater than 0", field));
        }
    }

    private static void checkGreaterThanZero(Duration value, String field) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("'%s' cannot be null", field));
        }
        if (value.toSeconds() <= 0L) {
            throw new IllegalArgumentException(String.format("'%s' must be greater than 0", field));
        }
    }

    public DetailsParameters messageRates(int ageSeconds, int incrementSeconds) {
        DetailsParameters.checkGreaterThanZero(ageSeconds, "age");
        DetailsParameters.checkGreaterThanZero(incrementSeconds, "increment");
        this.parameters.put("msg_rates_age", String.valueOf(ageSeconds));
        this.parameters.put("msg_rates_incr", String.valueOf(incrementSeconds));
        return this;
    }

    public DetailsParameters messageRates(Duration age, Duration increment) {
        DetailsParameters.checkGreaterThanZero(age, "age");
        DetailsParameters.checkGreaterThanZero(increment, "increment");
        return this.messageRates((int)age.toSeconds(), (int)increment.toSeconds());
    }

    public DetailsParameters lengths(int ageSeconds, int incrementSeconds) {
        DetailsParameters.checkGreaterThanZero(ageSeconds, "age");
        DetailsParameters.checkGreaterThanZero(incrementSeconds, "increment");
        this.parameters.put("lengths_age", String.valueOf(ageSeconds));
        this.parameters.put("lengths_incr", String.valueOf(incrementSeconds));
        return this;
    }

    public DetailsParameters lengths(Duration age, Duration increment) {
        DetailsParameters.checkGreaterThanZero(age, "age");
        DetailsParameters.checkGreaterThanZero(increment, "increment");
        return this.lengths((int)age.toSeconds(), (int)increment.toSeconds());
    }

    public Map<String, String> parameters() {
        return this.parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }

    public QueryParameters queryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new QueryParameters(this.parameters);
        }
        return this.queryParameters;
    }
}

