/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.http.client.ClientParameters;
import com.rabbitmq.http.client.HttpClientException;
import com.rabbitmq.http.client.HttpException;
import com.rabbitmq.http.client.HttpLayer;
import com.rabbitmq.http.client.HttpServerException;
import com.rabbitmq.http.client.JsonUtils;
import com.rabbitmq.http.client.ParameterizedTypeReference;
import com.rabbitmq.http.client.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class JdkHttpClientHttpLayer
implements HttpLayer {
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(30L);
    private final HttpClient client;
    private final ObjectMapper mapper;
    private final Consumer<HttpRequest.Builder> requestBuilderConsumer;

    private JdkHttpClientHttpLayer(HttpClient client, ObjectMapper mapper, Consumer<HttpRequest.Builder> requestBuilderConsumer) {
        this.client = client;
        this.mapper = mapper;
        this.requestBuilderConsumer = requestBuilderConsumer;
    }

    static <T> T get(URI uri, ObjectMapper mapper, HttpClient client, Consumer<HttpRequest.Builder> requestBuilderConsumer, Type type) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri);
        requestBuilder.header("accept", "application/json");
        requestBuilderConsumer.accept(requestBuilder);
        HttpRequest request = requestBuilder.GET().build();
        try {
            HttpResponse response = client.send(request, new JsonBodyHandler(mapper, type));
            int statusCode = response.statusCode();
            if (statusCode == 404) {
                return null;
            }
            if (statusCode == 200) {
                return ((Supplier)response.body()).get();
            }
            int errorClass = JdkHttpClientHttpLayer.errorClass(statusCode);
            if (errorClass == 400) {
                throw new HttpClientException(statusCode, "GET returned " + statusCode);
            }
            if (errorClass == 500) {
                throw new HttpServerException(statusCode, "GET returned " + statusCode);
            }
            throw new HttpException("GET returned " + statusCode);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HttpException(e);
        }
    }

    private static <W> HttpResponse.BodySubscriber<Supplier<W>> asJson(ObjectMapper mapper, Type type) {
        HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodySubscribers.ofInputStream();
        return HttpResponse.BodySubscribers.mapping(upstream, inputStream -> JdkHttpClientHttpLayer.toSupplierOfType(mapper, inputStream, type));
    }

    private static <W> Supplier<W> toSupplierOfType(ObjectMapper mapper, InputStream inputStream, Type type) {
        return () -> {
            Object object;
            block8: {
                InputStream stream = inputStream;
                try {
                    object = mapper.readValue(stream, mapper.constructType(type));
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new HttpException(e);
                    }
                }
                stream.close();
            }
            return object;
        };
    }

    static void maybeThrowClientServerException(int statusCode, String message, int ... ignores) {
        for (int ignore : ignores) {
            if (statusCode != ignore) continue;
            return;
        }
        int errorClass = JdkHttpClientHttpLayer.errorClass(statusCode);
        if (errorClass == 400) {
            throw new HttpClientException(statusCode, message);
        }
        if (errorClass == 500) {
            throw new HttpServerException(statusCode, message);
        }
    }

    private static int errorClass(int statusCode) {
        return statusCode - statusCode % 100;
    }

    public static Configuration configure() {
        return new Configuration();
    }

    public static String authorization(String username, String password) {
        return "Basic " + Utils.base64(username + ":" + password);
    }

    @Override
    public <T> T get(URI uri, Class<T> responseClass) {
        return JdkHttpClientHttpLayer.get(uri, this.mapper, this.client, this.requestBuilderConsumer, responseClass);
    }

    @Override
    public <T> T get(URI uri, ParameterizedTypeReference<T> typeReference) {
        return JdkHttpClientHttpLayer.get(uri, this.mapper, this.client, this.requestBuilderConsumer, typeReference.getType());
    }

    @Override
    public <T> T post(URI uri, Object requestBody, Class<T> responseClass) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri);
        requestBuilder.header("content-type", "application/json");
        this.requestBuilderConsumer.accept(requestBuilder);
        try {
            HttpRequest request = requestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(this.mapper.writeValueAsBytes(requestBody))).build();
            if (responseClass == null) {
                HttpResponse<Void> response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
                int statusCode = response.statusCode();
                JdkHttpClientHttpLayer.maybeThrowClientServerException(statusCode, "POST returned " + statusCode, new int[0]);
                return null;
            }
            HttpResponse response = this.client.send(request, new JsonBodyHandler(this.mapper, responseClass));
            int statusCode = response.statusCode();
            JdkHttpClientHttpLayer.maybeThrowClientServerException(statusCode, "POST returned " + statusCode, new int[0]);
            return ((Supplier)response.body()).get();
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HttpException(e);
        }
    }

    @Override
    public void put(URI uri, Object requestBody) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri);
        requestBuilder.header("content-type", "application/json");
        this.requestBuilderConsumer.accept(requestBuilder);
        try {
            HttpRequest request = requestBuilder.PUT(HttpRequest.BodyPublishers.ofByteArray(this.mapper.writeValueAsBytes(requestBody))).build();
            HttpResponse<Void> response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
            int statusCode = response.statusCode();
            JdkHttpClientHttpLayer.maybeThrowClientServerException(statusCode, "PUT returned " + statusCode, new int[0]);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HttpException(e);
        }
    }

    @Override
    public void delete(URI uri, Map<String, String> headers) {
        headers = headers == null ? Collections.emptyMap() : headers;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri);
        headers.forEach((n, v) -> requestBuilder.header((String)n, (String)v));
        this.requestBuilderConsumer.accept(requestBuilder);
        try {
            HttpRequest request = requestBuilder.DELETE().build();
            HttpResponse<Void> response = this.client.send(request, HttpResponse.BodyHandlers.discarding());
            int statusCode = response.statusCode();
            JdkHttpClientHttpLayer.maybeThrowClientServerException(statusCode, "DELETE returned " + statusCode, 404);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HttpException(e);
        }
    }

    public static class Configuration {
        private Consumer<HttpClient.Builder> clientBuilderConsumer = b -> {};
        private Consumer<HttpRequest.Builder> requestBuilderConsumer = null;

        public Configuration clientBuilderConsumer(Consumer<HttpClient.Builder> clientBuilderConsumer) {
            if (clientBuilderConsumer == null) {
                throw new IllegalArgumentException("Client builder consumer cannot be null");
            }
            this.clientBuilderConsumer = clientBuilderConsumer;
            return this;
        }

        public Configuration requestBuilderConsumer(Consumer<HttpRequest.Builder> requestBuilderConsumer) {
            if (requestBuilderConsumer == null) {
                throw new IllegalArgumentException("Request builder consumer cannot be null");
            }
            this.requestBuilderConsumer = requestBuilderConsumer;
            return this;
        }

        HttpLayer.HttpLayerFactory create() {
            return new Factory(this.clientBuilderConsumer, this.requestBuilderConsumer);
        }
    }

    private static class JsonBodyHandler<W>
    implements HttpResponse.BodyHandler<Supplier<W>> {
        private final ObjectMapper mapper;
        private final Type type;

        public JsonBodyHandler(ObjectMapper mapper, Type type) {
            this.mapper = mapper;
            this.type = type;
        }

        @Override
        public HttpResponse.BodySubscriber<Supplier<W>> apply(HttpResponse.ResponseInfo responseInfo) {
            return JdkHttpClientHttpLayer.asJson(this.mapper, this.type);
        }
    }

    private static class Factory
    implements HttpLayer.HttpLayerFactory {
        private final Consumer<HttpClient.Builder> clientBuilderConsumer;
        private final Consumer<HttpRequest.Builder> requestBuilderConsumer;

        Factory(Consumer<HttpClient.Builder> clientBuilderConsumer, Consumer<HttpRequest.Builder> requestBuilderConsumer) {
            this.clientBuilderConsumer = clientBuilderConsumer;
            this.requestBuilderConsumer = requestBuilderConsumer;
        }

        @Override
        public HttpLayer create(ClientParameters parameters) {
            HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(CONNECT_TIMEOUT);
            this.clientBuilderConsumer.accept(builder);
            HttpClient client = builder.build();
            ObjectMapper mapper = JsonUtils.createDefaultObjectMapper();
            String username = parameters.getUsername();
            String password = parameters.getPassword();
            Consumer<HttpRequest.Builder> requestBuilderConsumer = this.requestBuilderConsumer == null ? requestBuilder -> requestBuilder.timeout(REQUEST_TIMEOUT).setHeader("Authorization", JdkHttpClientHttpLayer.authorization(username, password)) : this.requestBuilderConsumer;
            return new JdkHttpClientHttpLayer(client, mapper, requestBuilderConsumer);
        }
    }
}

