/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.rabbitmq.http.client.GetAckMode;
import com.rabbitmq.http.client.GetEncoding;
import com.rabbitmq.http.client.domain.OutboundMessage;
import com.rabbitmq.http.client.domain.QueryParameters;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class Utils {
    private static final Charset CHARSET_UTF8;
    private static final int RADIX = 16;
    private static final BitSet UNRESERVED;
    private static final BitSet PUNCT;
    private static final BitSet USERINFO;
    private static final BitSet PATHSAFE;
    private static final BitSet URIC;
    private static final BitSet RESERVED;
    private static final BitSet URLENCODER;

    private Utils() {
    }

    static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    static Map<String, Object> bodyForPublish(String routingKey, OutboundMessage outboundMessage) {
        if (routingKey == null) {
            throw new IllegalArgumentException("routing key cannot be null");
        }
        if (outboundMessage == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (outboundMessage.getPayload() == null) {
            throw new IllegalArgumentException("message payload cannot be null");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("routing_key", routingKey);
        body.put("properties", outboundMessage.getProperties() == null ? Collections.EMPTY_MAP : outboundMessage.getProperties());
        body.put("payload", outboundMessage.getPayload());
        body.put("payload_encoding", outboundMessage.getPayloadEncoding());
        return body;
    }

    static Map<String, Object> bodyForGet(int count, GetAckMode ackMode, GetEncoding encoding, int truncate) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater than 0");
        }
        if (ackMode == null) {
            throw new IllegalArgumentException("acknowledgment mode cannot be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding cannot be null");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("count", count);
        body.put("ackmode", ackMode.ackMode);
        body.put("encoding", encoding.encoding);
        if (truncate >= 0) {
            body.put("truncate", truncate);
        }
        return body;
    }

    static String[] extractUsernamePassword(String url) {
        String userInfo = null;
        try {
            userInfo = new URL(url).getUserInfo();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL", e);
        }
        if (userInfo == null) {
            throw new IllegalArgumentException("Could not extract password from URL. URL should be like 'https://guest:guest@localhost:15672/api/'");
        }
        String[] usernamePassword = userInfo.split(":");
        if (usernamePassword == null || usernamePassword.length != 2) {
            throw new IllegalArgumentException("Could not extract password from URL. URL should be like 'https://guest:guest@localhost:15672/api/'");
        }
        return new String[]{Utils.decode(usernamePassword[0]), Utils.decode(usernamePassword[1])};
    }

    static URI rootUri(URL url) throws URISyntaxException, MalformedURLException {
        if (url.toString().endsWith("/")) {
            return url.toURI();
        }
        return new URL(url + "/").toURI();
    }

    static String decode(String potentiallyEncodedString) {
        if (potentiallyEncodedString != null && !potentiallyEncodedString.isEmpty()) {
            try {
                return URLDecoder.decode(potentiallyEncodedString, CHARSET_UTF8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Error while decoding string", e);
            }
        }
        return potentiallyEncodedString;
    }

    static String urlWithoutCredentials(String url) {
        URL url1 = null;
        try {
            url1 = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is malformed");
        }
        return url.replace(url1.getUserInfo() + "@", "");
    }

    static String base64(String in) {
        return Base64.getEncoder().encodeToString(in.getBytes(StandardCharsets.UTF_8));
    }

    static String encodePath(String content, Charset charset) {
        return Utils.appendEncodePath(new StringBuilder(), content, charset).toString();
    }

    static StringBuilder appendEncodePath(StringBuilder buf, String content, Charset charset) {
        ByteBuffer bb = charset.encode(content);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (PATHSAFE.get(b)) {
                buf.append((char)b);
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf;
    }

    static String encodeHttpParameter(String value) {
        return URLEncoder.encode(value, CHARSET_UTF8);
    }

    static String encode(String pathSegment) {
        return Utils.encodePath(pathSegment, CHARSET_UTF8);
    }

    static {
        int i;
        CHARSET_UTF8 = Charset.forName("UTF-8");
        UNRESERVED = new BitSet(256);
        PUNCT = new BitSet(256);
        USERINFO = new BitSet(256);
        PATHSAFE = new BitSet(256);
        URIC = new BitSet(256);
        RESERVED = new BitSet(256);
        URLENCODER = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(95);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(42);
        URLENCODER.or(UNRESERVED);
        UNRESERVED.set(33);
        UNRESERVED.set(126);
        UNRESERVED.set(39);
        UNRESERVED.set(40);
        UNRESERVED.set(41);
        PUNCT.set(44);
        PUNCT.set(59);
        PUNCT.set(58);
        PUNCT.set(36);
        PUNCT.set(38);
        PUNCT.set(43);
        PUNCT.set(61);
        USERINFO.or(UNRESERVED);
        USERINFO.or(PUNCT);
        PATHSAFE.or(UNRESERVED);
        PATHSAFE.set(59);
        PATHSAFE.set(58);
        PATHSAFE.set(64);
        PATHSAFE.set(38);
        PATHSAFE.set(61);
        PATHSAFE.set(43);
        PATHSAFE.set(36);
        PATHSAFE.set(44);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        RESERVED.set(91);
        RESERVED.set(93);
        URIC.or(RESERVED);
        URIC.or(UNRESERVED);
    }

    static class URIBuilder {
        URI rootURI;
        StringBuilder sb = new StringBuilder();
        QueryParameters queryParameters;
        Map<String, String> mapOfParameters;

        public URIBuilder(URI rootURI) {
            this.rootURI = rootURI;
        }

        URIBuilder withEncodedPath(String path) {
            if (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) != '/') {
                this.sb.append("/");
            }
            this.sb.append(path);
            return this;
        }

        URIBuilder withPath(String path) {
            if (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) != '/') {
                this.sb.append("/");
            }
            Utils.appendEncodePath(this.sb, path, CHARSET_UTF8);
            return this;
        }

        URIBuilder withQueryParameters(QueryParameters queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        URIBuilder withQueryParameters(Map<String, String> mapOfParameters) {
            this.mapOfParameters = mapOfParameters;
            return this;
        }

        URI get() {
            try {
                if (this.queryParameters != null && !this.queryParameters.isEmpty() || this.mapOfParameters != null && !this.mapOfParameters.isEmpty()) {
                    this.sb.append("?");
                }
                if (this.queryParameters != null && !this.queryParameters.isEmpty()) {
                    for (Map.Entry<String, String> param : this.queryParameters.parameters().entrySet()) {
                        this.sb.append(param.getKey()).append("=").append(Utils.encodeHttpParameter(param.getValue())).append("&");
                    }
                    this.sb.deleteCharAt(this.sb.length() - 1);
                }
                if (this.mapOfParameters != null && !this.mapOfParameters.isEmpty()) {
                    for (Map.Entry<String, String> param : this.mapOfParameters.entrySet()) {
                        this.sb.append(param.getKey()).append("=").append(Utils.encodeHttpParameter(param.getValue())).append("&");
                    }
                    this.sb.deleteCharAt(this.sb.length() - 1);
                }
                Iterator<Map.Entry<String, String>> iterator = this.rootURI.resolve(this.sb.toString());
                return iterator;
            }
            finally {
                this.sb.setLength(0);
            }
        }

        public URIBuilder withPathSeparator() {
            this.sb.append("/");
            return this;
        }
    }
}

