/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.rabbitmq.http.client.domain.ChannelDetails;
import com.rabbitmq.http.client.domain.CurrentUserDetails;
import com.rabbitmq.http.client.domain.UserInfo;
import com.rabbitmq.http.client.domain.VhostLimits;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class JsonUtils {
    static final JsonDeserializer<VhostLimits> VHOST_LIMITS_DESERIALIZER_INSTANCE = new VhostLimitsDeserializer();
    static final JsonDeserializer<CurrentUserDetails> CURRENT_USER_DETAILS_DESERIALIZER_INSTANCE = new CurrentUserDetailsDeserializer();
    static final JsonDeserializer<UserInfo> USER_INFO_DESERIALIZER_INSTANCE = new UserInfoDeserializer();
    static final JsonDeserializer<ChannelDetails> CHANNEL_DETAILS_DESERIALIZER_INSTANCE = new ChannelDetailsDeserializer();

    private JsonUtils() {
    }

    private static String get(JsonNode jp, String name) {
        return jp.get(name).asText();
    }

    private static final class ChannelDetailsDeserializer
    extends StdDeserializer<ChannelDetails> {
        private static final String CONNECTION_NAME_FIELD = "connection_name";
        private static final String NAME_FIELD = "name";
        private static final String NUMBER_FIELD = "number";
        private static final String PEER_HOST_FIELD = "peer_host";
        private static final String PEER_PORT_FIELD = "peer_port";
        private static final long serialVersionUID = -1831999885508961350L;

        protected ChannelDetailsDeserializer() {
            super(ChannelDetails.class);
        }

        private static int getPeerPort(JsonNode node) {
            return node.asInt(0);
        }

        public ChannelDetails deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            ChannelDetails channelDetails = new ChannelDetails();
            channelDetails.setConnectionName(JsonUtils.get(node, CONNECTION_NAME_FIELD));
            channelDetails.setName(JsonUtils.get(node, NAME_FIELD));
            channelDetails.setNumber(node.get(NUMBER_FIELD).asInt());
            channelDetails.setPeerHost(JsonUtils.get(node, PEER_HOST_FIELD));
            channelDetails.setPeerPort(ChannelDetailsDeserializer.getPeerPort(node.get(PEER_PORT_FIELD)));
            return channelDetails;
        }
    }

    private static final class CurrentUserDetailsDeserializer
    extends UserDeserializer<CurrentUserDetails> {
        private static final long serialVersionUID = -1871403623406830843L;

        private CurrentUserDetailsDeserializer() {
            super(UserInfo.class);
        }

        public CurrentUserDetails deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return new CurrentUserDetails(JsonUtils.get(node, "name"), this.getTags(node));
        }
    }

    private static final class UserInfoDeserializer
    extends UserDeserializer<UserInfo> {
        private static final long serialVersionUID = -1871403623406830843L;
        private static final String PASSWORD_HASH_FIELD = "password_hash";
        private static final String HASHING_ALGORITHM_FIELD = "hashing_algorithm";

        private UserInfoDeserializer() {
            super(UserInfo.class);
        }

        public UserInfo deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return new UserInfo(this.getUsername(node), JsonUtils.get(node, PASSWORD_HASH_FIELD), JsonUtils.get(node, HASHING_ALGORITHM_FIELD), this.getTags(node));
        }
    }

    private static abstract class UserDeserializer<T>
    extends StdDeserializer<T> {
        protected static final String USERNAME_FIELD = "name";
        protected static final String TAGS_FIELD = "tags";
        private static final long serialVersionUID = 3473030985825959020L;

        protected UserDeserializer(Class<?> vc) {
            super(vc);
        }

        protected String getUsername(JsonNode node) {
            return node.get(USERNAME_FIELD).asText();
        }

        protected List<String> getTags(JsonNode parent) {
            List<String> tags;
            JsonNode node = parent.get(TAGS_FIELD);
            if (node.isArray()) {
                if (node.isEmpty()) {
                    tags = Collections.emptyList();
                } else {
                    tags = new ArrayList<String>(node.size());
                    for (int i = 0; i < node.size(); ++i) {
                        tags.add(node.get(i).asText());
                    }
                }
            } else {
                tags = node.asText() == null || node.asText().isEmpty() ? Collections.emptyList() : Arrays.asList(node.asText().split(","));
            }
            return tags;
        }
    }

    private static final class VhostLimitsDeserializer
    extends StdDeserializer<VhostLimits> {
        private static final String VHOST_FIELD = "vhost";
        private static final String VALUE_FIELD = "value";
        private static final String MAX_QUEUES_FIELD = "max-queues";
        private static final String MAX_CONNECTIONS_FIELD = "max-connections";
        private static final long serialVersionUID = -1881403692606830843L;

        private VhostLimitsDeserializer() {
            super(VhostLimits.class);
        }

        public VhostLimits deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (node.isArray()) {
                if (node.isEmpty()) {
                    return new VhostLimits(null, -1, -1);
                }
                node = node.get(0);
            }
            JsonNode value = node.get(VALUE_FIELD);
            return new VhostLimits(JsonUtils.get(node, VHOST_FIELD), this.getLimit(value, MAX_QUEUES_FIELD), this.getLimit(value, MAX_CONNECTIONS_FIELD));
        }

        private int getLimit(JsonNode value, String name) {
            JsonNode limit = value.get(name);
            if (limit == null) {
                return -1;
            }
            return limit.asInt(-1);
        }
    }
}

