/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.SocketConfigurator;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public abstract class SocketConfigurators {
    public static final AbstractSocketConfigurator DISABLE_NAGLE_ALGORITHM;
    public static final AbstractSocketConfigurator DEFAULT;
    public static final AbstractSocketConfigurator ENABLE_HOSTNAME_VERIFICATION;

    static final SSLParameters enableHostnameVerification(SSLParameters sslParameters) {
        if (sslParameters == null) {
            sslParameters = new SSLParameters();
        }
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        return sslParameters;
    }

    public static AbstractSocketConfigurator defaultConfigurator() {
        return DEFAULT;
    }

    public static AbstractSocketConfigurator disableNagleAlgorithm() {
        return DISABLE_NAGLE_ALGORITHM;
    }

    public static AbstractSocketConfigurator enableHostnameVerification() {
        return ENABLE_HOSTNAME_VERIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        DEFAULT = DISABLE_NAGLE_ALGORITHM = new AbstractSocketConfigurator(){

            @Override
            public void configure(Socket socket) throws IOException {
                socket.setTcpNoDelay(true);
            }
        };
        ENABLE_HOSTNAME_VERIFICATION = new AbstractSocketConfigurator(){

            @Override
            public void configure(Socket socket) {
                if (socket instanceof SSLSocket) {
                    SSLSocket sslSocket = (SSLSocket)socket;
                    SSLParameters sslParameters = SocketConfigurators.enableHostnameVerification(sslSocket.getSSLParameters());
                    sslSocket.setSSLParameters(sslParameters);
                }
            }
        };
    }

    public static class Builder {
        private AbstractSocketConfigurator configurator = new AbstractSocketConfigurator(){

            @Override
            public void configure(Socket socket) {
            }
        };

        public Builder defaultConfigurator() {
            this.configurator = this.configurator.andThen(DEFAULT);
            return this;
        }

        public Builder disableNagleAlgorithm() {
            this.configurator = this.configurator.andThen(DISABLE_NAGLE_ALGORITHM);
            return this;
        }

        public Builder enableHostnameVerification() {
            this.configurator = this.configurator.andThen(ENABLE_HOSTNAME_VERIFICATION);
            return this;
        }

        public Builder add(SocketConfigurator extraConfiguration) {
            this.configurator = this.configurator.andThen(extraConfiguration);
            return this;
        }

        public SocketConfigurator build() {
            return this.configurator;
        }
    }

    public static abstract class AbstractSocketConfigurator
    implements SocketConfigurator {
        public AbstractSocketConfigurator andThen(final SocketConfigurator after) {
            if (after == null) {
                throw new NullPointerException();
            }
            return new AbstractSocketConfigurator(){

                @Override
                public void configure(Socket t) throws IOException {
                    AbstractSocketConfigurator.this.configure(t);
                    after.configure(t);
                }
            };
        }
    }
}

