/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.UnexpectedMethodError;
import com.rabbitmq.client.UnknownClassOrMethodId;
import com.rabbitmq.client.impl.AMQContentHeader;
import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.client.impl.MethodArgumentReader;
import com.rabbitmq.client.impl.MethodArgumentWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class AMQImpl
implements AMQP {
    public static Method readMethodFrom(DataInputStream in) throws IOException {
        short classId = in.readShort();
        short methodId = in.readShort();
        switch (classId) {
            case 10: {
                switch (methodId) {
                    case 10: {
                        Connection.Start result = new Connection.Start();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Connection.StartOk result = new Connection.StartOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Connection.Secure result = new Connection.Secure();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Connection.SecureOk result = new Connection.SecureOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Connection.Tune result = new Connection.Tune();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Connection.TuneOk result = new Connection.TuneOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Connection.Open result = new Connection.Open();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 41: {
                        Connection.OpenOk result = new Connection.OpenOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 50: {
                        Connection.Close result = new Connection.Close();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 51: {
                        Connection.CloseOk result = new Connection.CloseOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 20: {
                switch (methodId) {
                    case 10: {
                        Channel.Open result = new Channel.Open();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Channel.OpenOk result = new Channel.OpenOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Channel.Flow result = new Channel.Flow();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Channel.FlowOk result = new Channel.FlowOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Channel.Close result = new Channel.Close();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 41: {
                        Channel.CloseOk result = new Channel.CloseOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 30: {
                switch (methodId) {
                    case 10: {
                        Access.Request result = new Access.Request();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Access.RequestOk result = new Access.RequestOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 40: {
                switch (methodId) {
                    case 10: {
                        Exchange.Declare result = new Exchange.Declare();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Exchange.DeclareOk result = new Exchange.DeclareOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Exchange.Delete result = new Exchange.Delete();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Exchange.DeleteOk result = new Exchange.DeleteOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Exchange.Bind result = new Exchange.Bind();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Exchange.BindOk result = new Exchange.BindOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Exchange.Unbind result = new Exchange.Unbind();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 51: {
                        Exchange.UnbindOk result = new Exchange.UnbindOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 50: {
                switch (methodId) {
                    case 10: {
                        Queue.Declare result = new Queue.Declare();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Queue.DeclareOk result = new Queue.DeclareOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Queue.Bind result = new Queue.Bind();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Queue.BindOk result = new Queue.BindOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Queue.Purge result = new Queue.Purge();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Queue.PurgeOk result = new Queue.PurgeOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Queue.Delete result = new Queue.Delete();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 41: {
                        Queue.DeleteOk result = new Queue.DeleteOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 50: {
                        Queue.Unbind result = new Queue.Unbind();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 51: {
                        Queue.UnbindOk result = new Queue.UnbindOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 60: {
                switch (methodId) {
                    case 10: {
                        Basic.Qos result = new Basic.Qos();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Basic.QosOk result = new Basic.QosOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Basic.Consume result = new Basic.Consume();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Basic.ConsumeOk result = new Basic.ConsumeOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Basic.Cancel result = new Basic.Cancel();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Basic.CancelOk result = new Basic.CancelOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 40: {
                        Basic.Publish result = new Basic.Publish();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 50: {
                        Basic.Return result = new Basic.Return();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 60: {
                        Basic.Deliver result = new Basic.Deliver();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 70: {
                        Basic.Get result = new Basic.Get();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 71: {
                        Basic.GetOk result = new Basic.GetOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 72: {
                        Basic.GetEmpty result = new Basic.GetEmpty();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 80: {
                        Basic.Ack result = new Basic.Ack();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 90: {
                        Basic.Reject result = new Basic.Reject();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 100: {
                        Basic.RecoverAsync result = new Basic.RecoverAsync();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 110: {
                        Basic.Recover result = new Basic.Recover();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 111: {
                        Basic.RecoverOk result = new Basic.RecoverOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
            case 90: {
                switch (methodId) {
                    case 10: {
                        Tx.Select result = new Tx.Select();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 11: {
                        Tx.SelectOk result = new Tx.SelectOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 20: {
                        Tx.Commit result = new Tx.Commit();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 21: {
                        Tx.CommitOk result = new Tx.CommitOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 30: {
                        Tx.Rollback result = new Tx.Rollback();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                    case 31: {
                        Tx.RollbackOk result = new Tx.RollbackOk();
                        result.readArgumentsFrom(new MethodArgumentReader(in));
                        return result;
                    }
                }
            }
        }
        throw new UnknownClassOrMethodId(classId, methodId);
    }

    public static AMQContentHeader readContentHeaderFrom(DataInputStream in) throws IOException {
        short classId = in.readShort();
        switch (classId) {
            case 60: {
                return new AMQP.BasicProperties();
            }
        }
        throw new UnknownClassOrMethodId(classId, -1);
    }

    public static class DefaultMethodVisitor
    implements MethodVisitor {
        public Object visit(Connection.Start x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.StartOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Secure x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.SecureOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Tune x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.TuneOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Open x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.OpenOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.Close x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Connection.CloseOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Open x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.OpenOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Flow x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.FlowOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.Close x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Channel.CloseOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Access.Request x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Access.RequestOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Declare x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.DeclareOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Delete x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.DeleteOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Bind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.BindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.Unbind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Exchange.UnbindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Declare x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.DeclareOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Bind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.BindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Purge x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.PurgeOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Delete x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.DeleteOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.Unbind x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Queue.UnbindOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Qos x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.QosOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Consume x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.ConsumeOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Cancel x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.CancelOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Publish x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Return x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Deliver x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Get x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.GetOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.GetEmpty x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Ack x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Reject x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.RecoverAsync x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.Recover x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Basic.RecoverOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Select x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.SelectOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Commit x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.CommitOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.Rollback x) throws IOException {
            throw new UnexpectedMethodError(x);
        }

        public Object visit(Tx.RollbackOk x) throws IOException {
            throw new UnexpectedMethodError(x);
        }
    }

    public static interface MethodVisitor {
        public Object visit(Connection.Start var1) throws IOException;

        public Object visit(Connection.StartOk var1) throws IOException;

        public Object visit(Connection.Secure var1) throws IOException;

        public Object visit(Connection.SecureOk var1) throws IOException;

        public Object visit(Connection.Tune var1) throws IOException;

        public Object visit(Connection.TuneOk var1) throws IOException;

        public Object visit(Connection.Open var1) throws IOException;

        public Object visit(Connection.OpenOk var1) throws IOException;

        public Object visit(Connection.Close var1) throws IOException;

        public Object visit(Connection.CloseOk var1) throws IOException;

        public Object visit(Channel.Open var1) throws IOException;

        public Object visit(Channel.OpenOk var1) throws IOException;

        public Object visit(Channel.Flow var1) throws IOException;

        public Object visit(Channel.FlowOk var1) throws IOException;

        public Object visit(Channel.Close var1) throws IOException;

        public Object visit(Channel.CloseOk var1) throws IOException;

        public Object visit(Access.Request var1) throws IOException;

        public Object visit(Access.RequestOk var1) throws IOException;

        public Object visit(Exchange.Declare var1) throws IOException;

        public Object visit(Exchange.DeclareOk var1) throws IOException;

        public Object visit(Exchange.Delete var1) throws IOException;

        public Object visit(Exchange.DeleteOk var1) throws IOException;

        public Object visit(Exchange.Bind var1) throws IOException;

        public Object visit(Exchange.BindOk var1) throws IOException;

        public Object visit(Exchange.Unbind var1) throws IOException;

        public Object visit(Exchange.UnbindOk var1) throws IOException;

        public Object visit(Queue.Declare var1) throws IOException;

        public Object visit(Queue.DeclareOk var1) throws IOException;

        public Object visit(Queue.Bind var1) throws IOException;

        public Object visit(Queue.BindOk var1) throws IOException;

        public Object visit(Queue.Purge var1) throws IOException;

        public Object visit(Queue.PurgeOk var1) throws IOException;

        public Object visit(Queue.Delete var1) throws IOException;

        public Object visit(Queue.DeleteOk var1) throws IOException;

        public Object visit(Queue.Unbind var1) throws IOException;

        public Object visit(Queue.UnbindOk var1) throws IOException;

        public Object visit(Basic.Qos var1) throws IOException;

        public Object visit(Basic.QosOk var1) throws IOException;

        public Object visit(Basic.Consume var1) throws IOException;

        public Object visit(Basic.ConsumeOk var1) throws IOException;

        public Object visit(Basic.Cancel var1) throws IOException;

        public Object visit(Basic.CancelOk var1) throws IOException;

        public Object visit(Basic.Publish var1) throws IOException;

        public Object visit(Basic.Return var1) throws IOException;

        public Object visit(Basic.Deliver var1) throws IOException;

        public Object visit(Basic.Get var1) throws IOException;

        public Object visit(Basic.GetOk var1) throws IOException;

        public Object visit(Basic.GetEmpty var1) throws IOException;

        public Object visit(Basic.Ack var1) throws IOException;

        public Object visit(Basic.Reject var1) throws IOException;

        public Object visit(Basic.RecoverAsync var1) throws IOException;

        public Object visit(Basic.Recover var1) throws IOException;

        public Object visit(Basic.RecoverOk var1) throws IOException;

        public Object visit(Tx.Select var1) throws IOException;

        public Object visit(Tx.SelectOk var1) throws IOException;

        public Object visit(Tx.Commit var1) throws IOException;

        public Object visit(Tx.CommitOk var1) throws IOException;

        public Object visit(Tx.Rollback var1) throws IOException;

        public Object visit(Tx.RollbackOk var1) throws IOException;
    }

    public static class Tx {
        public static final int INDEX = 90;

        public static class RollbackOk
        extends Method
        implements AMQP.Tx.RollbackOk {
            public static final int INDEX = 31;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "tx.rollback-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Rollback
        extends Method
        implements AMQP.Tx.Rollback {
            public static final int INDEX = 30;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "tx.rollback";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class CommitOk
        extends Method
        implements AMQP.Tx.CommitOk {
            public static final int INDEX = 21;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "tx.commit-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Commit
        extends Method
        implements AMQP.Tx.Commit {
            public static final int INDEX = 20;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "tx.commit";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class SelectOk
        extends Method
        implements AMQP.Tx.SelectOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "tx.select-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Select
        extends Method
        implements AMQP.Tx.Select {
            public static final int INDEX = 10;

            public int protocolClassId() {
                return 90;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "tx.select";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }
    }

    public static class Basic {
        public static final int INDEX = 60;

        public static class RecoverOk
        extends Method
        implements AMQP.Basic.RecoverOk {
            public static final int INDEX = 111;

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 111;
            }

            public String protocolMethodName() {
                return "basic.recover-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Recover
        extends Method
        implements AMQP.Basic.Recover {
            public static final int INDEX = 110;
            public boolean requeue;

            public boolean getRequeue() {
                return this.requeue;
            }

            public Recover(boolean requeue) {
                this.requeue = requeue;
            }

            public Recover() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 110;
            }

            public String protocolMethodName() {
                return "basic.recover";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("requeue=");
                acc.append(this.requeue);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.requeue = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.requeue);
            }
        }

        public static class RecoverAsync
        extends Method
        implements AMQP.Basic.RecoverAsync {
            public static final int INDEX = 100;
            public boolean requeue;

            public boolean getRequeue() {
                return this.requeue;
            }

            public RecoverAsync(boolean requeue) {
                this.requeue = requeue;
            }

            public RecoverAsync() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 100;
            }

            public String protocolMethodName() {
                return "basic.recover-async";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("requeue=");
                acc.append(this.requeue);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.requeue = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.requeue);
            }
        }

        public static class Reject
        extends Method
        implements AMQP.Basic.Reject {
            public static final int INDEX = 90;
            public long deliveryTag;
            public boolean requeue;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRequeue() {
                return this.requeue;
            }

            public Reject(long deliveryTag, boolean requeue) {
                this.deliveryTag = deliveryTag;
                this.requeue = requeue;
            }

            public Reject() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 90;
            }

            public String protocolMethodName() {
                return "basic.reject";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("requeue=");
                acc.append(this.requeue);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.deliveryTag = reader.readLonglong();
                this.requeue = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.requeue);
            }
        }

        public static class Ack
        extends Method
        implements AMQP.Basic.Ack {
            public static final int INDEX = 80;
            public long deliveryTag;
            public boolean multiple;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getMultiple() {
                return this.multiple;
            }

            public Ack(long deliveryTag, boolean multiple) {
                this.deliveryTag = deliveryTag;
                this.multiple = multiple;
            }

            public Ack() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 80;
            }

            public String protocolMethodName() {
                return "basic.ack";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("multiple=");
                acc.append(this.multiple);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.deliveryTag = reader.readLonglong();
                this.multiple = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.multiple);
            }
        }

        public static class GetEmpty
        extends Method
        implements AMQP.Basic.GetEmpty {
            public static final int INDEX = 72;
            public String clusterId;

            public String getClusterId() {
                return this.clusterId;
            }

            public GetEmpty(String clusterId) {
                this.clusterId = clusterId;
            }

            public GetEmpty() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 72;
            }

            public String protocolMethodName() {
                return "basic.get-empty";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("cluster-id=");
                acc.append(this.clusterId);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.clusterId = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.clusterId);
            }
        }

        public static class GetOk
        extends Method
        implements AMQP.Basic.GetOk {
            public static final int INDEX = 71;
            public long deliveryTag;
            public boolean redelivered;
            public String exchange;
            public String routingKey;
            public int messageCount;

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRedelivered() {
                return this.redelivered;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public int getMessageCount() {
                return this.messageCount;
            }

            public GetOk(long deliveryTag, boolean redelivered, String exchange, String routingKey, int messageCount) {
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.messageCount = messageCount;
            }

            public GetOk() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 71;
            }

            public String protocolMethodName() {
                return "basic.get-ok";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("redelivered=");
                acc.append(this.redelivered);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("message-count=");
                acc.append(this.messageCount);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.deliveryTag = reader.readLonglong();
                this.redelivered = reader.readBit();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.messageCount = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeLong(this.messageCount);
            }
        }

        public static class Get
        extends Method
        implements AMQP.Basic.Get {
            public static final int INDEX = 70;
            public int ticket;
            public String queue;
            public boolean noAck;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getNoAck() {
                return this.noAck;
            }

            public Get(int ticket, String queue, boolean noAck) {
                this.ticket = ticket;
                this.queue = queue;
                this.noAck = noAck;
            }

            public Get() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 70;
            }

            public String protocolMethodName() {
                return "basic.get";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("no-ack=");
                acc.append(this.noAck);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.noAck = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.noAck);
            }
        }

        public static class Deliver
        extends Method
        implements AMQP.Basic.Deliver {
            public static final int INDEX = 60;
            public String consumerTag;
            public long deliveryTag;
            public boolean redelivered;
            public String exchange;
            public String routingKey;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public long getDeliveryTag() {
                return this.deliveryTag;
            }

            public boolean getRedelivered() {
                return this.redelivered;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public Deliver(String consumerTag, long deliveryTag, boolean redelivered, String exchange, String routingKey) {
                this.consumerTag = consumerTag;
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }

            public Deliver() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 60;
            }

            public String protocolMethodName() {
                return "basic.deliver";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("delivery-tag=");
                acc.append(this.deliveryTag);
                acc.append(",");
                acc.append("redelivered=");
                acc.append(this.redelivered);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
                this.deliveryTag = reader.readLonglong();
                this.redelivered = reader.readBit();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Return
        extends Method
        implements AMQP.Basic.Return {
            public static final int INDEX = 50;
            public int replyCode;
            public String replyText;
            public String exchange;
            public String routingKey;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public Return(int replyCode, String replyText, String exchange, String routingKey) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }

            public Return() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 50;
            }

            public String protocolMethodName() {
                return "basic.return";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Publish
        extends Method
        implements AMQP.Basic.Publish {
            public static final int INDEX = 40;
            public int ticket;
            public String exchange;
            public String routingKey;
            public boolean mandatory;
            public boolean immediate;

            public int getTicket() {
                return this.ticket;
            }

            public String getExchange() {
                return this.exchange;
            }

            public String getRoutingKey() {
                return this.routingKey;
            }

            public boolean getMandatory() {
                return this.mandatory;
            }

            public boolean getImmediate() {
                return this.immediate;
            }

            public Publish(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate) {
                this.ticket = ticket;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.mandatory = mandatory;
                this.immediate = immediate;
            }

            public Publish() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "basic.publish";
            }

            public boolean hasContent() {
                return true;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("mandatory=");
                acc.append(this.mandatory);
                acc.append(",");
                acc.append("immediate=");
                acc.append(this.immediate);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.mandatory = reader.readBit();
                this.immediate = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.mandatory);
                writer.writeBit(this.immediate);
            }
        }

        public static class CancelOk
        extends Method
        implements AMQP.Basic.CancelOk {
            public static final int INDEX = 31;
            public String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public CancelOk(String consumerTag) {
                this.consumerTag = consumerTag;
            }

            public CancelOk() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "basic.cancel-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Cancel
        extends Method
        implements AMQP.Basic.Cancel {
            public static final int INDEX = 30;
            public String consumerTag;
            public boolean nowait;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Cancel(String consumerTag, boolean nowait) {
                this.consumerTag = consumerTag;
                this.nowait = nowait;
            }

            public Cancel() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "basic.cancel";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.nowait);
            }
        }

        public static class ConsumeOk
        extends Method
        implements AMQP.Basic.ConsumeOk {
            public static final int INDEX = 21;
            public String consumerTag;

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public ConsumeOk(String consumerTag) {
                this.consumerTag = consumerTag;
            }

            public ConsumeOk() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "basic.consume-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.consumerTag = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.consumerTag);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Consume
        extends Method
        implements AMQP.Basic.Consume {
            public static final int INDEX = 20;
            public int ticket;
            public String queue;
            public String consumerTag;
            public boolean noLocal;
            public boolean noAck;
            public boolean exclusive;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getConsumerTag() {
                return this.consumerTag;
            }

            @Override
            public boolean getNoLocal() {
                return this.noLocal;
            }

            @Override
            public boolean getNoAck() {
                return this.noAck;
            }

            @Override
            public boolean getExclusive() {
                return this.exclusive;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Consume(int ticket, String queue, String consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.queue = queue;
                this.consumerTag = consumerTag;
                this.noLocal = noLocal;
                this.noAck = noAck;
                this.exclusive = exclusive;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Consume() {
            }

            @Override
            public int protocolClassId() {
                return 60;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "basic.consume";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("consumer-tag=");
                acc.append(this.consumerTag);
                acc.append(",");
                acc.append("no-local=");
                acc.append(this.noLocal);
                acc.append(",");
                acc.append("no-ack=");
                acc.append(this.noAck);
                acc.append(",");
                acc.append("exclusive=");
                acc.append(this.exclusive);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.consumerTag = reader.readShortstr();
                this.noLocal = reader.readBit();
                this.noAck = reader.readBit();
                this.exclusive = reader.readBit();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.noLocal);
                writer.writeBit(this.noAck);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class QosOk
        extends Method
        implements AMQP.Basic.QosOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "basic.qos-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Qos
        extends Method
        implements AMQP.Basic.Qos {
            public static final int INDEX = 10;
            public int prefetchSize;
            public int prefetchCount;
            public boolean global;

            public int getPrefetchSize() {
                return this.prefetchSize;
            }

            public int getPrefetchCount() {
                return this.prefetchCount;
            }

            public boolean getGlobal() {
                return this.global;
            }

            public Qos(int prefetchSize, int prefetchCount, boolean global) {
                this.prefetchSize = prefetchSize;
                this.prefetchCount = prefetchCount;
                this.global = global;
            }

            public Qos() {
            }

            public int protocolClassId() {
                return 60;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "basic.qos";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("prefetch-size=");
                acc.append(this.prefetchSize);
                acc.append(",");
                acc.append("prefetch-count=");
                acc.append(this.prefetchCount);
                acc.append(",");
                acc.append("global=");
                acc.append(this.global);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.prefetchSize = reader.readLong();
                this.prefetchCount = reader.readShort();
                this.global = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.prefetchSize);
                writer.writeShort(this.prefetchCount);
                writer.writeBit(this.global);
            }
        }
    }

    public static class Queue {
        public static final int INDEX = 50;

        public static class UnbindOk
        extends Method
        implements AMQP.Queue.UnbindOk {
            public static final int INDEX = 51;

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 51;
            }

            public String protocolMethodName() {
                return "queue.unbind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Unbind
        extends Method
        implements AMQP.Queue.Unbind {
            public static final int INDEX = 50;
            public int ticket;
            public String queue;
            public String exchange;
            public String routingKey;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Unbind(int ticket, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.queue = queue;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.arguments = arguments;
            }

            public Unbind() {
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 50;
            }

            @Override
            public String protocolMethodName() {
                return "queue.unbind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeleteOk
        extends Method
        implements AMQP.Queue.DeleteOk {
            public static final int INDEX = 41;
            public int messageCount;

            public int getMessageCount() {
                return this.messageCount;
            }

            public DeleteOk(int messageCount) {
                this.messageCount = messageCount;
            }

            public DeleteOk() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "queue.delete-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("message-count=");
                acc.append(this.messageCount);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.messageCount = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.messageCount);
            }
        }

        public static class Delete
        extends Method
        implements AMQP.Queue.Delete {
            public static final int INDEX = 40;
            public int ticket;
            public String queue;
            public boolean ifUnused;
            public boolean ifEmpty;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getIfUnused() {
                return this.ifUnused;
            }

            public boolean getIfEmpty() {
                return this.ifEmpty;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Delete(int ticket, String queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
                this.ticket = ticket;
                this.queue = queue;
                this.ifUnused = ifUnused;
                this.ifEmpty = ifEmpty;
                this.nowait = nowait;
            }

            public Delete() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "queue.delete";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("if-unused=");
                acc.append(this.ifUnused);
                acc.append(",");
                acc.append("if-empty=");
                acc.append(this.ifEmpty);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.ifUnused = reader.readBit();
                this.ifEmpty = reader.readBit();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.ifUnused);
                writer.writeBit(this.ifEmpty);
                writer.writeBit(this.nowait);
            }
        }

        public static class PurgeOk
        extends Method
        implements AMQP.Queue.PurgeOk {
            public static final int INDEX = 31;
            public int messageCount;

            public int getMessageCount() {
                return this.messageCount;
            }

            public PurgeOk(int messageCount) {
                this.messageCount = messageCount;
            }

            public PurgeOk() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "queue.purge-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("message-count=");
                acc.append(this.messageCount);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.messageCount = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLong(this.messageCount);
            }
        }

        public static class Purge
        extends Method
        implements AMQP.Queue.Purge {
            public static final int INDEX = 30;
            public int ticket;
            public String queue;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getQueue() {
                return this.queue;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Purge(int ticket, String queue, boolean nowait) {
                this.ticket = ticket;
                this.queue = queue;
                this.nowait = nowait;
            }

            public Purge() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "queue.purge";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.nowait);
            }
        }

        public static class BindOk
        extends Method
        implements AMQP.Queue.BindOk {
            public static final int INDEX = 21;

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "queue.bind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind
        extends Method
        implements AMQP.Queue.Bind {
            public static final int INDEX = 20;
            public int ticket;
            public String queue;
            public String exchange;
            public String routingKey;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Bind(int ticket, String queue, String exchange, String routingKey, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.queue = queue;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Bind() {
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 20;
            }

            @Override
            public String protocolMethodName() {
                return "queue.bind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.exchange = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeclareOk
        extends Method
        implements AMQP.Queue.DeclareOk {
            public static final int INDEX = 11;
            public String queue;
            public int messageCount;
            public int consumerCount;

            public String getQueue() {
                return this.queue;
            }

            public int getMessageCount() {
                return this.messageCount;
            }

            public int getConsumerCount() {
                return this.consumerCount;
            }

            public DeclareOk(String queue, int messageCount, int consumerCount) {
                this.queue = queue;
                this.messageCount = messageCount;
                this.consumerCount = consumerCount;
            }

            public DeclareOk() {
            }

            public int protocolClassId() {
                return 50;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "queue.declare-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("message-count=");
                acc.append(this.messageCount);
                acc.append(",");
                acc.append("consumer-count=");
                acc.append(this.consumerCount);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.queue = reader.readShortstr();
                this.messageCount = reader.readLong();
                this.consumerCount = reader.readLong();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.queue);
                writer.writeLong(this.messageCount);
                writer.writeLong(this.consumerCount);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Declare
        extends Method
        implements AMQP.Queue.Declare {
            public static final int INDEX = 10;
            public int ticket;
            public String queue;
            public boolean passive;
            public boolean durable;
            public boolean exclusive;
            public boolean autoDelete;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getQueue() {
                return this.queue;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public boolean getDurable() {
                return this.durable;
            }

            @Override
            public boolean getExclusive() {
                return this.exclusive;
            }

            @Override
            public boolean getAutoDelete() {
                return this.autoDelete;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Declare(int ticket, String queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.queue = queue;
                this.passive = passive;
                this.durable = durable;
                this.exclusive = exclusive;
                this.autoDelete = autoDelete;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Declare() {
            }

            @Override
            public int protocolClassId() {
                return 50;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "queue.declare";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("queue=");
                acc.append(this.queue);
                acc.append(",");
                acc.append("passive=");
                acc.append(this.passive);
                acc.append(",");
                acc.append("durable=");
                acc.append(this.durable);
                acc.append(",");
                acc.append("exclusive=");
                acc.append(this.exclusive);
                acc.append(",");
                acc.append("auto-delete=");
                acc.append(this.autoDelete);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.queue = reader.readShortstr();
                this.passive = reader.readBit();
                this.durable = reader.readBit();
                this.exclusive = reader.readBit();
                this.autoDelete = reader.readBit();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.passive);
                writer.writeBit(this.durable);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.autoDelete);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }
    }

    public static class Exchange {
        public static final int INDEX = 40;

        public static class UnbindOk
        extends Method
        implements AMQP.Exchange.UnbindOk {
            public static final int INDEX = 51;

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 51;
            }

            public String protocolMethodName() {
                return "exchange.unbind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Unbind
        extends Method
        implements AMQP.Exchange.Unbind {
            public static final int INDEX = 40;
            public int ticket;
            public String destination;
            public String source;
            public String routingKey;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getDestination() {
                return this.destination;
            }

            @Override
            public String getSource() {
                return this.source;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Unbind(int ticket, String destination, String source, String routingKey, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.destination = destination;
                this.source = source;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Unbind() {
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 40;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.unbind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("destination=");
                acc.append(this.destination);
                acc.append(",");
                acc.append("source=");
                acc.append(this.source);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.destination = reader.readShortstr();
                this.source = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.destination);
                writer.writeShortstr(this.source);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class BindOk
        extends Method
        implements AMQP.Exchange.BindOk {
            public static final int INDEX = 31;

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "exchange.bind-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind
        extends Method
        implements AMQP.Exchange.Bind {
            public static final int INDEX = 30;
            public int ticket;
            public String destination;
            public String source;
            public String routingKey;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getDestination() {
                return this.destination;
            }

            @Override
            public String getSource() {
                return this.source;
            }

            @Override
            public String getRoutingKey() {
                return this.routingKey;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Bind(int ticket, String destination, String source, String routingKey, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.destination = destination;
                this.source = source;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Bind() {
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 30;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.bind";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("destination=");
                acc.append(this.destination);
                acc.append(",");
                acc.append("source=");
                acc.append(this.source);
                acc.append(",");
                acc.append("routing-key=");
                acc.append(this.routingKey);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.destination = reader.readShortstr();
                this.source = reader.readShortstr();
                this.routingKey = reader.readShortstr();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.destination);
                writer.writeShortstr(this.source);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeleteOk
        extends Method
        implements AMQP.Exchange.DeleteOk {
            public static final int INDEX = 21;

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "exchange.delete-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Delete
        extends Method
        implements AMQP.Exchange.Delete {
            public static final int INDEX = 20;
            public int ticket;
            public String exchange;
            public boolean ifUnused;
            public boolean nowait;

            public int getTicket() {
                return this.ticket;
            }

            public String getExchange() {
                return this.exchange;
            }

            public boolean getIfUnused() {
                return this.ifUnused;
            }

            public boolean getNowait() {
                return this.nowait;
            }

            public Delete(int ticket, String exchange, boolean ifUnused, boolean nowait) {
                this.ticket = ticket;
                this.exchange = exchange;
                this.ifUnused = ifUnused;
                this.nowait = nowait;
            }

            public Delete() {
            }

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "exchange.delete";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("if-unused=");
                acc.append(this.ifUnused);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.exchange = reader.readShortstr();
                this.ifUnused = reader.readBit();
                this.nowait = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeBit(this.ifUnused);
                writer.writeBit(this.nowait);
            }
        }

        public static class DeclareOk
        extends Method
        implements AMQP.Exchange.DeclareOk {
            public static final int INDEX = 11;

            public int protocolClassId() {
                return 40;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "exchange.declare-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Declare
        extends Method
        implements AMQP.Exchange.Declare {
            public static final int INDEX = 10;
            public int ticket;
            public String exchange;
            public String type;
            public boolean passive;
            public boolean durable;
            public boolean autoDelete;
            public boolean internal;
            public boolean nowait;
            public Map<String, Object> arguments;

            @Override
            public int getTicket() {
                return this.ticket;
            }

            @Override
            public String getExchange() {
                return this.exchange;
            }

            @Override
            public String getType() {
                return this.type;
            }

            @Override
            public boolean getPassive() {
                return this.passive;
            }

            @Override
            public boolean getDurable() {
                return this.durable;
            }

            @Override
            public boolean getAutoDelete() {
                return this.autoDelete;
            }

            @Override
            public boolean getInternal() {
                return this.internal;
            }

            @Override
            public boolean getNowait() {
                return this.nowait;
            }

            @Override
            public Map<String, Object> getArguments() {
                return this.arguments;
            }

            public Declare(int ticket, String exchange, String type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, Map<String, Object> arguments) {
                this.ticket = ticket;
                this.exchange = exchange;
                this.type = type;
                this.passive = passive;
                this.durable = durable;
                this.autoDelete = autoDelete;
                this.internal = internal;
                this.nowait = nowait;
                this.arguments = arguments;
            }

            public Declare() {
            }

            @Override
            public int protocolClassId() {
                return 40;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "exchange.declare";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(",");
                acc.append("exchange=");
                acc.append(this.exchange);
                acc.append(",");
                acc.append("type=");
                acc.append(this.type);
                acc.append(",");
                acc.append("passive=");
                acc.append(this.passive);
                acc.append(",");
                acc.append("durable=");
                acc.append(this.durable);
                acc.append(",");
                acc.append("auto-delete=");
                acc.append(this.autoDelete);
                acc.append(",");
                acc.append("internal=");
                acc.append(this.internal);
                acc.append(",");
                acc.append("nowait=");
                acc.append(this.nowait);
                acc.append(",");
                acc.append("arguments=");
                acc.append(this.arguments);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
                this.exchange = reader.readShortstr();
                this.type = reader.readShortstr();
                this.passive = reader.readBit();
                this.durable = reader.readBit();
                this.autoDelete = reader.readBit();
                this.internal = reader.readBit();
                this.nowait = reader.readBit();
                this.arguments = reader.readTable();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.type);
                writer.writeBit(this.passive);
                writer.writeBit(this.durable);
                writer.writeBit(this.autoDelete);
                writer.writeBit(this.internal);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }
    }

    public static class Access {
        public static final int INDEX = 30;

        public static class RequestOk
        extends Method
        implements AMQP.Access.RequestOk {
            public static final int INDEX = 11;
            public int ticket;

            public int getTicket() {
                return this.ticket;
            }

            public RequestOk(int ticket) {
                this.ticket = ticket;
            }

            public RequestOk() {
            }

            public int protocolClassId() {
                return 30;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "access.request-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("ticket=");
                acc.append(this.ticket);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.ticket = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.ticket);
            }
        }

        public static class Request
        extends Method
        implements AMQP.Access.Request {
            public static final int INDEX = 10;
            public String realm;
            public boolean exclusive;
            public boolean passive;
            public boolean active;
            public boolean write;
            public boolean read;

            public String getRealm() {
                return this.realm;
            }

            public boolean getExclusive() {
                return this.exclusive;
            }

            public boolean getPassive() {
                return this.passive;
            }

            public boolean getActive() {
                return this.active;
            }

            public boolean getWrite() {
                return this.write;
            }

            public boolean getRead() {
                return this.read;
            }

            public Request(String realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
                this.realm = realm;
                this.exclusive = exclusive;
                this.passive = passive;
                this.active = active;
                this.write = write;
                this.read = read;
            }

            public Request() {
            }

            public int protocolClassId() {
                return 30;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "access.request";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("realm=");
                acc.append(this.realm);
                acc.append(",");
                acc.append("exclusive=");
                acc.append(this.exclusive);
                acc.append(",");
                acc.append("passive=");
                acc.append(this.passive);
                acc.append(",");
                acc.append("active=");
                acc.append(this.active);
                acc.append(",");
                acc.append("write=");
                acc.append(this.write);
                acc.append(",");
                acc.append("read=");
                acc.append(this.read);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.realm = reader.readShortstr();
                this.exclusive = reader.readBit();
                this.passive = reader.readBit();
                this.active = reader.readBit();
                this.write = reader.readBit();
                this.read = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.realm);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.passive);
                writer.writeBit(this.active);
                writer.writeBit(this.write);
                writer.writeBit(this.read);
            }
        }
    }

    public static class Channel {
        public static final int INDEX = 20;

        public static class CloseOk
        extends Method
        implements AMQP.Channel.CloseOk {
            public static final int INDEX = 41;

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "channel.close-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Close
        extends Method
        implements AMQP.Channel.Close {
            public static final int INDEX = 40;
            public int replyCode;
            public String replyText;
            public int classId;
            public int methodId;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public int getClassId() {
                return this.classId;
            }

            public int getMethodId() {
                return this.methodId;
            }

            public Close(int replyCode, String replyText, int classId, int methodId) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.classId = classId;
                this.methodId = methodId;
            }

            public Close() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "channel.close";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("class-id=");
                acc.append(this.classId);
                acc.append(",");
                acc.append("method-id=");
                acc.append(this.methodId);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.classId = reader.readShort();
                this.methodId = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShort(this.classId);
                writer.writeShort(this.methodId);
            }
        }

        public static class FlowOk
        extends Method
        implements AMQP.Channel.FlowOk {
            public static final int INDEX = 21;
            public boolean active;

            public boolean getActive() {
                return this.active;
            }

            public FlowOk(boolean active) {
                this.active = active;
            }

            public FlowOk() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "channel.flow-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("active=");
                acc.append(this.active);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.active = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.active);
            }
        }

        public static class Flow
        extends Method
        implements AMQP.Channel.Flow {
            public static final int INDEX = 20;
            public boolean active;

            public boolean getActive() {
                return this.active;
            }

            public Flow(boolean active) {
                this.active = active;
            }

            public Flow() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "channel.flow";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("active=");
                acc.append(this.active);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.active = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeBit(this.active);
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.Channel.OpenOk {
            public static final int INDEX = 11;
            public LongString channelId;

            public LongString getChannelId() {
                return this.channelId;
            }

            public OpenOk(LongString channelId) {
                this.channelId = channelId;
            }

            public OpenOk() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 11;
            }

            public String protocolMethodName() {
                return "channel.open-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("channel-id=");
                acc.append(this.channelId);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.channelId = reader.readLongstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.channelId);
            }
        }

        public static class Open
        extends Method
        implements AMQP.Channel.Open {
            public static final int INDEX = 10;
            public String outOfBand;

            public String getOutOfBand() {
                return this.outOfBand;
            }

            public Open(String outOfBand) {
                this.outOfBand = outOfBand;
            }

            public Open() {
            }

            public int protocolClassId() {
                return 20;
            }

            public int protocolMethodId() {
                return 10;
            }

            public String protocolMethodName() {
                return "channel.open";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("out-of-band=");
                acc.append(this.outOfBand);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.outOfBand = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.outOfBand);
            }
        }
    }

    public static class Connection {
        public static final int INDEX = 10;

        public static class CloseOk
        extends Method
        implements AMQP.Connection.CloseOk {
            public static final int INDEX = 51;

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 51;
            }

            public String protocolMethodName() {
                return "connection.close-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
            }
        }

        public static class Close
        extends Method
        implements AMQP.Connection.Close {
            public static final int INDEX = 50;
            public int replyCode;
            public String replyText;
            public int classId;
            public int methodId;

            public int getReplyCode() {
                return this.replyCode;
            }

            public String getReplyText() {
                return this.replyText;
            }

            public int getClassId() {
                return this.classId;
            }

            public int getMethodId() {
                return this.methodId;
            }

            public Close(int replyCode, String replyText, int classId, int methodId) {
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.classId = classId;
                this.methodId = methodId;
            }

            public Close() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 50;
            }

            public String protocolMethodName() {
                return "connection.close";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("reply-code=");
                acc.append(this.replyCode);
                acc.append(",");
                acc.append("reply-text=");
                acc.append(this.replyText);
                acc.append(",");
                acc.append("class-id=");
                acc.append(this.classId);
                acc.append(",");
                acc.append("method-id=");
                acc.append(this.methodId);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.replyCode = reader.readShort();
                this.replyText = reader.readShortstr();
                this.classId = reader.readShort();
                this.methodId = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShort(this.classId);
                writer.writeShort(this.methodId);
            }
        }

        public static class OpenOk
        extends Method
        implements AMQP.Connection.OpenOk {
            public static final int INDEX = 41;
            public String knownHosts;

            public String getKnownHosts() {
                return this.knownHosts;
            }

            public OpenOk(String knownHosts) {
                this.knownHosts = knownHosts;
            }

            public OpenOk() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 41;
            }

            public String protocolMethodName() {
                return "connection.open-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("known-hosts=");
                acc.append(this.knownHosts);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.knownHosts = reader.readShortstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.knownHosts);
            }
        }

        public static class Open
        extends Method
        implements AMQP.Connection.Open {
            public static final int INDEX = 40;
            public String virtualHost;
            public String capabilities;
            public boolean insist;

            public String getVirtualHost() {
                return this.virtualHost;
            }

            public String getCapabilities() {
                return this.capabilities;
            }

            public boolean getInsist() {
                return this.insist;
            }

            public Open(String virtualHost, String capabilities, boolean insist) {
                this.virtualHost = virtualHost;
                this.capabilities = capabilities;
                this.insist = insist;
            }

            public Open() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 40;
            }

            public String protocolMethodName() {
                return "connection.open";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("virtual-host=");
                acc.append(this.virtualHost);
                acc.append(",");
                acc.append("capabilities=");
                acc.append(this.capabilities);
                acc.append(",");
                acc.append("insist=");
                acc.append(this.insist);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.virtualHost = reader.readShortstr();
                this.capabilities = reader.readShortstr();
                this.insist = reader.readBit();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShortstr(this.virtualHost);
                writer.writeShortstr(this.capabilities);
                writer.writeBit(this.insist);
            }
        }

        public static class TuneOk
        extends Method
        implements AMQP.Connection.TuneOk {
            public static final int INDEX = 31;
            public int channelMax;
            public int frameMax;
            public int heartbeat;

            public int getChannelMax() {
                return this.channelMax;
            }

            public int getFrameMax() {
                return this.frameMax;
            }

            public int getHeartbeat() {
                return this.heartbeat;
            }

            public TuneOk(int channelMax, int frameMax, int heartbeat) {
                this.channelMax = channelMax;
                this.frameMax = frameMax;
                this.heartbeat = heartbeat;
            }

            public TuneOk() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 31;
            }

            public String protocolMethodName() {
                return "connection.tune-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("channel-max=");
                acc.append(this.channelMax);
                acc.append(",");
                acc.append("frame-max=");
                acc.append(this.frameMax);
                acc.append(",");
                acc.append("heartbeat=");
                acc.append(this.heartbeat);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.channelMax = reader.readShort();
                this.frameMax = reader.readLong();
                this.heartbeat = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.channelMax);
                writer.writeLong(this.frameMax);
                writer.writeShort(this.heartbeat);
            }
        }

        public static class Tune
        extends Method
        implements AMQP.Connection.Tune {
            public static final int INDEX = 30;
            public int channelMax;
            public int frameMax;
            public int heartbeat;

            public int getChannelMax() {
                return this.channelMax;
            }

            public int getFrameMax() {
                return this.frameMax;
            }

            public int getHeartbeat() {
                return this.heartbeat;
            }

            public Tune(int channelMax, int frameMax, int heartbeat) {
                this.channelMax = channelMax;
                this.frameMax = frameMax;
                this.heartbeat = heartbeat;
            }

            public Tune() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 30;
            }

            public String protocolMethodName() {
                return "connection.tune";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("channel-max=");
                acc.append(this.channelMax);
                acc.append(",");
                acc.append("frame-max=");
                acc.append(this.frameMax);
                acc.append(",");
                acc.append("heartbeat=");
                acc.append(this.heartbeat);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.channelMax = reader.readShort();
                this.frameMax = reader.readLong();
                this.heartbeat = reader.readShort();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeShort(this.channelMax);
                writer.writeLong(this.frameMax);
                writer.writeShort(this.heartbeat);
            }
        }

        public static class SecureOk
        extends Method
        implements AMQP.Connection.SecureOk {
            public static final int INDEX = 21;
            public LongString response;

            public LongString getResponse() {
                return this.response;
            }

            public SecureOk(LongString response) {
                this.response = response;
            }

            public SecureOk() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 21;
            }

            public String protocolMethodName() {
                return "connection.secure-ok";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("response=");
                acc.append(this.response);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.response = reader.readLongstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.response);
            }
        }

        public static class Secure
        extends Method
        implements AMQP.Connection.Secure {
            public static final int INDEX = 20;
            public LongString challenge;

            public LongString getChallenge() {
                return this.challenge;
            }

            public Secure(LongString challenge) {
                this.challenge = challenge;
            }

            public Secure() {
            }

            public int protocolClassId() {
                return 10;
            }

            public int protocolMethodId() {
                return 20;
            }

            public String protocolMethodName() {
                return "connection.secure";
            }

            public boolean hasContent() {
                return false;
            }

            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("challenge=");
                acc.append(this.challenge);
                acc.append(")");
            }

            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.challenge = reader.readLongstr();
            }

            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeLongstr(this.challenge);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class StartOk
        extends Method
        implements AMQP.Connection.StartOk {
            public static final int INDEX = 11;
            public Map<String, Object> clientProperties;
            public String mechanism;
            public LongString response;
            public String locale;

            @Override
            public Map<String, Object> getClientProperties() {
                return this.clientProperties;
            }

            @Override
            public String getMechanism() {
                return this.mechanism;
            }

            @Override
            public LongString getResponse() {
                return this.response;
            }

            @Override
            public String getLocale() {
                return this.locale;
            }

            public StartOk(Map<String, Object> clientProperties, String mechanism, LongString response, String locale) {
                this.clientProperties = clientProperties;
                this.mechanism = mechanism;
                this.response = response;
                this.locale = locale;
            }

            public StartOk() {
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 11;
            }

            @Override
            public String protocolMethodName() {
                return "connection.start-ok";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("client-properties=");
                acc.append(this.clientProperties);
                acc.append(",");
                acc.append("mechanism=");
                acc.append(this.mechanism);
                acc.append(",");
                acc.append("response=");
                acc.append(this.response);
                acc.append(",");
                acc.append("locale=");
                acc.append(this.locale);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.clientProperties = reader.readTable();
                this.mechanism = reader.readShortstr();
                this.response = reader.readLongstr();
                this.locale = reader.readShortstr();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeTable(this.clientProperties);
                writer.writeShortstr(this.mechanism);
                writer.writeLongstr(this.response);
                writer.writeShortstr(this.locale);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Start
        extends Method
        implements AMQP.Connection.Start {
            public static final int INDEX = 10;
            public int versionMajor;
            public int versionMinor;
            public Map<String, Object> serverProperties;
            public LongString mechanisms;
            public LongString locales;

            @Override
            public int getVersionMajor() {
                return this.versionMajor;
            }

            @Override
            public int getVersionMinor() {
                return this.versionMinor;
            }

            @Override
            public Map<String, Object> getServerProperties() {
                return this.serverProperties;
            }

            @Override
            public LongString getMechanisms() {
                return this.mechanisms;
            }

            @Override
            public LongString getLocales() {
                return this.locales;
            }

            public Start(int versionMajor, int versionMinor, Map<String, Object> serverProperties, LongString mechanisms, LongString locales) {
                this.versionMajor = versionMajor;
                this.versionMinor = versionMinor;
                this.serverProperties = serverProperties;
                this.mechanisms = mechanisms;
                this.locales = locales;
            }

            public Start() {
            }

            @Override
            public int protocolClassId() {
                return 10;
            }

            @Override
            public int protocolMethodId() {
                return 10;
            }

            @Override
            public String protocolMethodName() {
                return "connection.start";
            }

            @Override
            public boolean hasContent() {
                return false;
            }

            @Override
            public Object visit(MethodVisitor visitor) throws IOException {
                return visitor.visit(this);
            }

            @Override
            public void appendArgumentDebugStringTo(StringBuffer acc) {
                acc.append("(");
                acc.append("version-major=");
                acc.append(this.versionMajor);
                acc.append(",");
                acc.append("version-minor=");
                acc.append(this.versionMinor);
                acc.append(",");
                acc.append("server properties=");
                acc.append(this.serverProperties);
                acc.append(",");
                acc.append("mechanisms=");
                acc.append(this.mechanisms);
                acc.append(",");
                acc.append("locales=");
                acc.append(this.locales);
                acc.append(")");
            }

            @Override
            public void readArgumentsFrom(MethodArgumentReader reader) throws IOException {
                this.versionMajor = reader.readOctet();
                this.versionMinor = reader.readOctet();
                this.serverProperties = reader.readTable();
                this.mechanisms = reader.readLongstr();
                this.locales = reader.readLongstr();
            }

            @Override
            public void writeArgumentsTo(MethodArgumentWriter writer) throws IOException {
                writer.writeOctet(this.versionMajor);
                writer.writeOctet(this.versionMinor);
                writer.writeTable(this.serverProperties);
                writer.writeLongstr(this.mechanisms);
                writer.writeLongstr(this.locales);
            }
        }
    }
}

