/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.MalformedFrameException;
import com.rabbitmq.client.impl.LongString;
import com.rabbitmq.client.impl.LongStringHelper;
import com.rabbitmq.client.impl.TruncatedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueReader {
    private static final long INT_MASK = -1L;
    private final DataInputStream in;

    protected static long unsignedExtend(int value) {
        long extended = value;
        return extended & 0xFFFFFFFFFFFFFFFFL;
    }

    public ValueReader(DataInputStream in) {
        this.in = in;
    }

    public static final String readShortstr(DataInputStream in) throws IOException {
        byte[] b = new byte[in.readUnsignedByte()];
        in.readFully(b);
        return new String(b, "utf-8");
    }

    public final String readShortstr() throws IOException {
        return ValueReader.readShortstr(this.in);
    }

    public static final byte[] readBytes(DataInputStream in) throws IOException {
        long contentLength = ValueReader.unsignedExtend(in.readInt());
        if (contentLength < Integer.MAX_VALUE) {
            byte[] buffer = new byte[(int)contentLength];
            in.readFully(buffer);
            return buffer;
        }
        throw new UnsupportedOperationException("Very long byte vectors and strings not currently supported");
    }

    public byte[] readBytes() throws IOException {
        return ValueReader.readBytes(this.in);
    }

    public static final LongString readLongstr(DataInputStream in) throws IOException {
        return LongStringHelper.asLongString(ValueReader.readBytes(in));
    }

    public final LongString readLongstr() throws IOException {
        return ValueReader.readLongstr(this.in);
    }

    public final int readShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public final int readLong() throws IOException {
        return this.in.readInt();
    }

    public final long readLonglong() throws IOException {
        return this.in.readLong();
    }

    public static final Map<String, Object> readTable(DataInputStream in) throws IOException {
        HashMap<String, Object> table = new HashMap<String, Object>();
        long tableLength = ValueReader.unsignedExtend(in.readInt());
        DataInputStream tableIn = new DataInputStream((InputStream)((Object)new TruncatedInputStream(in, tableLength)));
        Object value = null;
        while (tableIn.available() > 0) {
            String name = ValueReader.readShortstr(tableIn);
            switch (tableIn.readUnsignedByte()) {
                case 83: {
                    value = ValueReader.readLongstr(tableIn);
                    break;
                }
                case 73: {
                    value = tableIn.readInt();
                    break;
                }
                case 68: {
                    int scale = tableIn.readUnsignedByte();
                    byte[] unscaled = new byte[4];
                    tableIn.readFully(unscaled);
                    value = new BigDecimal(new BigInteger(unscaled), scale);
                    break;
                }
                case 84: {
                    value = ValueReader.readTimestamp(tableIn);
                    break;
                }
                case 70: {
                    value = ValueReader.readTable(tableIn);
                    break;
                }
                case 98: {
                    value = tableIn.readByte();
                    break;
                }
                case 100: {
                    value = tableIn.readDouble();
                    break;
                }
                case 102: {
                    value = Float.valueOf(tableIn.readFloat());
                    break;
                }
                case 108: {
                    value = tableIn.readLong();
                    break;
                }
                case 115: {
                    value = tableIn.readShort();
                    break;
                }
                case 116: {
                    value = tableIn.readBoolean();
                    break;
                }
                case 120: {
                    value = ValueReader.readBytes(tableIn);
                    break;
                }
                case 86: {
                    value = null;
                    break;
                }
                default: {
                    throw new MalformedFrameException("Unrecognised type in table");
                }
            }
            if (table.containsKey(name)) continue;
            table.put(name, value);
        }
        return table;
    }

    public final Map<String, Object> readTable() throws IOException {
        return ValueReader.readTable(this.in);
    }

    public final int readOctet() throws IOException {
        return this.in.readUnsignedByte();
    }

    public static final Date readTimestamp(DataInputStream in) throws IOException {
        return new Date(in.readLong() * 1000L);
    }

    public final Date readTimestamp() throws IOException {
        return ValueReader.readTimestamp(this.in);
    }
}

