/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.r0adkll.slidr.model.SlidrConfig;
import com.r0adkll.slidr.widget.SliderPanel;

class FragmentPanelSlideListener
implements SliderPanel.OnPanelSlideListener {
    private final View view;
    private final SlidrConfig config;

    FragmentPanelSlideListener(@NonNull View view, @NonNull SlidrConfig config) {
        this.view = view;
        this.config = config;
    }

    @Override
    public void onStateChanged(int state) {
        if (this.config.getListener() != null) {
            this.config.getListener().onSlideStateChanged(state);
        }
    }

    @Override
    public void onClosed() {
        if (this.config.getListener() != null && this.config.getListener().onSlideClosed()) {
            return;
        }
        if (this.view.getContext() instanceof FragmentActivity) {
            FragmentActivity activity = (FragmentActivity)this.view.getContext();
            if (activity.getSupportFragmentManager().getBackStackEntryCount() == 0) {
                activity.finish();
                activity.overridePendingTransition(0, 0);
            } else {
                activity.getSupportFragmentManager().popBackStack();
            }
        }
    }

    @Override
    public void onOpened() {
        if (this.config.getListener() != null) {
            this.config.getListener().onSlideOpened();
        }
    }

    @Override
    public void onSlideChange(float percent) {
        if (this.config.getListener() != null) {
            this.config.getListener().onSlideChange(percent);
        }
    }
}

