/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr.widget;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.widget.ViewDragHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.r0adkll.slidr.model.SlidrConfig;

public class SliderPanel
extends FrameLayout {
    private static final int MIN_FLING_VELOCITY = 400;
    private static final float MAX_DIM_ALPHA = 0.8f;
    private int mScreenWidth;
    private int mScreenHeight;
    private View mDimView;
    private View mDecorView;
    private ViewDragHelper mDragHelper;
    private OnPanelSlideListener mListener;
    private boolean mIsLocked = false;
    private SlidrConfig mConfig;
    private ViewDragHelper.Callback mLeftCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.mDecorView.getId();
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, 0, SliderPanel.this.mScreenWidth);
        }

        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.mScreenWidth;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            int width = SliderPanel.this.getWidth();
            float offset = width - releasedChild.getLeft();
            int left = xvel < 0.0f || xvel == 0.0f && offset > 0.5f ? 0 : SliderPanel.this.mScreenWidth;
            SliderPanel.this.mDragHelper.settleCapturedViewAt(left, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)left / (float)SliderPanel.this.mScreenWidth;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            float alpha = percent * 0.8f;
            SliderPanel.this.mDimView.setAlpha(alpha);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getLeft() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private ViewDragHelper.Callback mRightCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.mDecorView.getId();
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, -SliderPanel.this.mScreenWidth, 0);
        }

        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.mScreenWidth;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            int width = SliderPanel.this.getWidth();
            float offset = width + releasedChild.getLeft();
            int left = xvel > 0.0f || xvel == 0.0f && offset < (float)SliderPanel.this.mScreenWidth - 0.5f ? 0 : -SliderPanel.this.mScreenWidth;
            SliderPanel.this.mDragHelper.settleCapturedViewAt(left, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(left) / (float)SliderPanel.this.mScreenWidth;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            float alpha = percent * 0.8f;
            SliderPanel.this.mDimView.setAlpha(alpha);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getLeft() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private ViewDragHelper.Callback mTopCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.mDecorView.getId();
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return SliderPanel.clamp(top, 0, SliderPanel.this.mScreenHeight);
        }

        public int getViewVerticalDragRange(View child) {
            return SliderPanel.this.mScreenHeight;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            int height = SliderPanel.this.getHeight();
            float offset = height - releasedChild.getTop();
            int top = yvel < 0.0f || yvel == 0.0f && offset > 0.5f ? 0 : SliderPanel.this.mScreenHeight;
            SliderPanel.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), top);
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(top) / (float)SliderPanel.this.mScreenHeight;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            float alpha = percent * 0.8f;
            SliderPanel.this.mDimView.setAlpha(alpha);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getTop() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };
    private ViewDragHelper.Callback mBottomCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.mDecorView.getId();
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return SliderPanel.clamp(top, -SliderPanel.this.mScreenHeight, 0);
        }

        public int getViewVerticalDragRange(View child) {
            return SliderPanel.this.mScreenHeight;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            int height = SliderPanel.this.getHeight();
            float offset = height - releasedChild.getTop();
            int top = yvel > 0.0f || yvel == 0.0f && offset < (float)SliderPanel.this.mScreenHeight - 0.5f ? 0 : -SliderPanel.this.mScreenHeight;
            SliderPanel.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), top);
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)Math.abs(top) / (float)SliderPanel.this.mScreenHeight;
            if (SliderPanel.this.mListener != null) {
                SliderPanel.this.mListener.onSlideChange(percent);
            }
            float alpha = percent * 0.8f;
            SliderPanel.this.mDimView.setAlpha(alpha);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getTop() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };

    public SliderPanel(Context context, View decorView) {
        super(context);
        this.mDecorView = decorView;
        this.mConfig = new SlidrConfig.Builder().build();
        this.init();
    }

    public SliderPanel(Context context, View decorView, SlidrConfig config) {
        super(context);
        this.mDecorView = decorView;
        this.mConfig = config;
        this.init();
    }

    public void setOnPanelSlideListener(OnPanelSlideListener listener) {
        this.mListener = listener;
    }

    private void init() {
        int position;
        ViewDragHelper.Callback callback;
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        float density = this.getResources().getDisplayMetrics().density;
        float minVel = 400.0f * density;
        switch (this.mConfig.getPosition()) {
            case LEFT: {
                callback = this.mLeftCallback;
                position = 1;
                break;
            }
            case RIGHT: {
                callback = this.mRightCallback;
                position = 2;
                break;
            }
            case TOP: {
                callback = this.mTopCallback;
                position = 4;
                break;
            }
            case BOTTOM: {
                callback = this.mBottomCallback;
                position = 8;
                break;
            }
            default: {
                callback = this.mLeftCallback;
                position = 1;
            }
        }
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)this.mConfig.getSensitivity(), (ViewDragHelper.Callback)callback);
        this.mDragHelper.setMinVelocity(minVel);
        this.mDragHelper.setEdgeTrackingEnabled(position);
        ViewGroupCompat.setMotionEventSplittingEnabled((ViewGroup)this, (boolean)false);
        this.mDimView = new View(this.getContext());
        this.mDimView.setBackgroundColor(-16777216);
        this.mDimView.setAlpha(0.8f);
        this.addView(this.mDimView);
        this.post(new Runnable(){

            @Override
            public void run() {
                SliderPanel.this.mScreenHeight = SliderPanel.this.getHeight();
            }
        });
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean interceptForDrag = this.mDragHelper.shouldInterceptTouchEvent(ev);
        return interceptForDrag && !this.mIsLocked;
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            this.mDragHelper.processTouchEvent(event);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void lock() {
        this.mDragHelper.cancel();
        this.mIsLocked = true;
    }

    public void unlock() {
        this.mDragHelper.cancel();
        this.mIsLocked = false;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static interface OnPanelSlideListener {
        public void onClosed();

        public void onOpened();

        public void onSlideChange(float var1);
    }
}

