/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr;

import android.animation.ArgbEvaluator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.r0adkll.slidr.R;
import com.r0adkll.slidr.SlidrInterface;
import com.r0adkll.slidr.widget.SliderPanel;

public class Slidr {
    public static SlidrInterface attach(Activity activity) {
        return Slidr.attach(activity, -1, -1);
    }

    public static SlidrInterface attach(final Activity activity, final int statusBarColor1, final int statusBarColor2) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View oldScreen = decorView.getChildAt(0);
        decorView.removeViewAt(0);
        final SliderPanel panel = new SliderPanel((Context)activity, oldScreen);
        panel.setId(R.id.slidable_panel);
        panel.addView(oldScreen);
        decorView.addView((View)panel, 0);
        panel.setOnPanelSlideListener(new SliderPanel.OnPanelSlideListener(){
            private final ArgbEvaluator mEvaluator = new ArgbEvaluator();

            @Override
            public void onClosed() {
                activity.finish();
                activity.overridePendingTransition(0, 0);
            }

            @Override
            public void onOpened() {
            }

            @Override
            @TargetApi(value=21)
            public void onSlideChange(float percent) {
                if (Build.VERSION.SDK_INT >= 21 && statusBarColor1 != -1 && statusBarColor2 != -1) {
                    int newColor = (Integer)this.mEvaluator.evaluate(percent, (Object)statusBarColor1, (Object)statusBarColor2);
                    activity.getWindow().setStatusBarColor(newColor);
                }
            }
        });
        SlidrInterface slidrInterface = new SlidrInterface(){

            @Override
            public void lock() {
                panel.lock();
            }

            @Override
            public void unlock() {
                panel.unlock();
            }
        };
        return slidrInterface;
    }
}

