/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidableactivity.widget;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.widget.ViewDragHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class SliderPanel
extends FrameLayout {
    private static final int MIN_FLING_VELOCITY = 400;
    private static final float MAX_DIM_ALPHA = 0.8f;
    private int mScreenWidth;
    private View mDimView;
    private View mDecorView;
    private ViewDragHelper mDragHelper;
    private OnPanelSlideListener mListener;
    private boolean mIsLocked = false;
    private ViewDragHelper.Callback mCallback = new ViewDragHelper.Callback(){

        public boolean tryCaptureView(View child, int pointerId) {
            return child.getId() == SliderPanel.this.mDecorView.getId();
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SliderPanel.clamp(left, 0, SliderPanel.this.mScreenWidth);
        }

        public int getViewHorizontalDragRange(View child) {
            return SliderPanel.this.mScreenWidth;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            int width = SliderPanel.this.getWidth();
            float offset = width - releasedChild.getLeft();
            int left = xvel < 0.0f || xvel == 0.0f && offset > 0.5f ? 0 : SliderPanel.this.mScreenWidth;
            SliderPanel.this.mDragHelper.settleCapturedViewAt(left, releasedChild.getTop());
            SliderPanel.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            float percent = 1.0f - (float)left / (float)SliderPanel.this.mScreenWidth;
            float alpha = percent * 0.8f;
            SliderPanel.this.mDimView.setAlpha(alpha);
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            switch (state) {
                case 0: {
                    if (SliderPanel.this.mDecorView.getLeft() == 0) {
                        if (SliderPanel.this.mListener == null) break;
                        SliderPanel.this.mListener.onOpened();
                        break;
                    }
                    if (SliderPanel.this.mListener == null) break;
                    SliderPanel.this.mListener.onClosed();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    };

    public SliderPanel(Context context, View decorView) {
        super(context);
        this.mDecorView = decorView;
        this.init();
    }

    public void setOnPanelSlideListener(OnPanelSlideListener listener) {
        this.mListener = listener;
    }

    private void init() {
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        float density = this.getResources().getDisplayMetrics().density;
        float minVel = 400.0f * density;
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)this.mCallback);
        this.mDragHelper.setMinVelocity(minVel);
        this.mDragHelper.setEdgeTrackingEnabled(1);
        ViewGroupCompat.setMotionEventSplittingEnabled((ViewGroup)this, (boolean)false);
        this.mDimView = new View(this.getContext());
        this.mDimView.setBackgroundColor(-16777216);
        this.mDimView.setAlpha(0.8f);
        this.addView(this.mDimView);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean interceptForDrag = this.mDragHelper.shouldInterceptTouchEvent(ev);
        return interceptForDrag && !this.mIsLocked;
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            this.mDragHelper.processTouchEvent(event);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void lock() {
        this.mDragHelper.cancel();
        this.mIsLocked = true;
    }

    public void unlock() {
        this.mDragHelper.cancel();
        this.mIsLocked = false;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static interface OnPanelSlideListener {
        public void onClosed();

        public void onOpened();
    }
}

