/*
 * Decompiled with CFR 0.152.
 */
package com.hunter.library.timing.impl;

import android.util.Log;
import com.hunter.library.timing.IBlockHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RankingBlockHandler
implements IBlockHandler {
    private final String TAG = "RankingBlockHandler";
    private String newline = System.getProperty("line.separator");
    private String doubleNewline = this.newline + this.newline;
    private ConcurrentHashMap<String, ArrayList<Integer>> methodBlockDetails = new ConcurrentHashMap();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final int threshold;

    public RankingBlockHandler(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void timingMethod(final String method, final int mills) {
        if (mills < this.threshold()) {
            return;
        }
        Log.i((String)"RankingBlockHandler", (String)(method + " costs " + mills));
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                ArrayList<Integer> costTimeList = (ArrayList<Integer>)RankingBlockHandler.this.methodBlockDetails.get(method);
                if (costTimeList == null) {
                    costTimeList = new ArrayList<Integer>();
                }
                costTimeList.add(mills);
                RankingBlockHandler.this.methodBlockDetails.put(method, costTimeList);
            }
        });
    }

    @Override
    public String dump() {
        String rankingContent = this.getRankingDetail(20);
        String summary = "Total count of found block method is " + this.methodBlockDetails.size() + " (Over " + this.threshold() + "ms)";
        Log.i((String)"RankingBlockHandler", (String)summary);
        Log.i((String)"RankingBlockHandler", (String)rankingContent);
        return summary + rankingContent;
    }

    private String getRankingDetail(int count) {
        HashMap method_block_average_map = new HashMap();
        HashMap method_block_count_map = new HashMap();
        for (String key : this.methodBlockDetails.keySet()) {
            method_block_average_map.put(key, Float.valueOf(RankingBlockHandler.average(this.methodBlockDetails.get(key))));
            method_block_count_map.put(key, this.methodBlockDetails.get(key).size());
        }
        method_block_average_map = (HashMap)RankingBlockHandler.sortByValue(method_block_average_map);
        method_block_count_map = (HashMap)RankingBlockHandler.sortByValue(method_block_count_map);
        int toppestCount = Math.min(count, method_block_average_map.keySet().size());
        int index = 0;
        StringBuilder result = new StringBuilder();
        result.append(this.doubleNewline).append("------Average Block-Time Ranking----").append("Top " + toppestCount).append("----");
        result.append(this.newline);
        for (String key : method_block_average_map.keySet()) {
            if (index++ >= toppestCount) break;
            result.append(key + ": " + this.formatFloat((Float)method_block_average_map.get(key)) + "ms");
            result.append("(Count : " + method_block_count_map.get(key) + ")");
            result.append(this.newline);
        }
        toppestCount = Math.min(count, method_block_count_map.keySet().size());
        index = 0;
        result.append("------Block Count Ranking----").append("Top " + toppestCount).append("----");
        result.append(this.newline);
        for (String key : method_block_count_map.keySet()) {
            if (index++ >= toppestCount) break;
            result.append(key + ": " + method_block_count_map.get(key) + "");
            result.append("(Avg : " + this.formatFloat((Float)method_block_average_map.get(key)) + "ms)");
            result.append(this.newline);
        }
        result.append(this.newline);
        return result.toString();
    }

    private Float formatFloat(Float val) {
        return Float.valueOf((float)Math.round(val.floatValue() * 100.0f) / 100.0f);
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o2.getValue()).compareTo(o1.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static float average(ArrayList<Integer> costTimeList) {
        if (costTimeList == null || costTimeList.size() == 0) {
            return 0.0f;
        }
        int sum = 0;
        for (int val : costTimeList) {
            sum += val;
        }
        return (float)sum / (float)costTimeList.size();
    }

    @Override
    public void clear() {
        this.methodBlockDetails.clear();
    }

    @Override
    public int threshold() {
        return this.threshold;
    }
}

