/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.provider.Settings;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import com.queue_it.androidsdk.QueueActivity;
import com.queue_it.androidsdk.QueueCache;
import com.queue_it.androidsdk.QueueITException;
import com.queue_it.androidsdk.QueueListener;
import com.queue_it.androidsdk.QueueService;
import com.queue_it.androidsdk.QueueServiceListener;
import java.util.Calendar;

public class QueueITEngine {
    private String _customerId;
    private String _eventOrAliasId;
    private String _layoutName;
    private String _language;
    private QueueListener _queueListener;
    private QueueCache _queueCache;
    private Activity _activity;
    private boolean _requestInProgress;
    private boolean _isInQueue;
    private static final int INITIAL_WAIT_RETRY_SEC = 1;
    private static final int MAX_RETRY_SEC = 10;
    private int _deltaSec;
    private int _delayInterval = 0;
    private Handler _checkConnectionHandler;
    private int _isOnlineRetry = 0;
    private Runnable _checkConnection = new Runnable(){

        @Override
        public void run() {
            if (QueueITEngine.this.isOnline()) {
                QueueITEngine.this.runWithConnection();
                return;
            }
            QueueITEngine.this._isOnlineRetry++;
            if (QueueITEngine.this._isOnlineRetry > 5) {
                QueueITEngine.this._queueListener.onError("No connection");
                return;
            }
            QueueITEngine.this._checkConnectionHandler.postDelayed((Runnable)this, 1000L);
        }
    };

    public QueueITEngine(Activity activity, String customerId, String eventOrAliasId, QueueListener queueListener) {
        this(activity, customerId, eventOrAliasId, "", "", queueListener);
    }

    public QueueITEngine(Activity activity, String customerId, String eventOrAliasId, String layoutName, String language, QueueListener queueListener) {
        if (TextUtils.isEmpty((CharSequence)customerId)) {
            throw new IllegalArgumentException("customerId must have a value");
        }
        if (TextUtils.isEmpty((CharSequence)eventOrAliasId)) {
            throw new IllegalArgumentException("eventOrAliasId must have a value");
        }
        this._activity = activity;
        this._customerId = customerId;
        this._eventOrAliasId = eventOrAliasId;
        this._layoutName = layoutName;
        this._language = language;
        this._queueListener = queueListener;
        this._queueCache = new QueueCache((Context)activity, customerId, eventOrAliasId);
        this._deltaSec = 1;
    }

    public void setViewDelay(int delayInterval) {
        this._delayInterval = delayInterval;
    }

    public boolean isInQueue() {
        return this._isInQueue;
    }

    public boolean IsRequestInProgress() {
        return this._requestInProgress;
    }

    private boolean isOnline() {
        ConnectivityManager cm = (ConnectivityManager)this._activity.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected();
    }

    public void run(boolean clearCache) throws QueueITException {
        if (clearCache) {
            this._queueCache.clear();
        }
        this.run();
    }

    public void run() throws QueueITException {
        this.registerReceivers();
        if (this._requestInProgress) {
            throw new QueueITException("Request is already in progress");
        }
        this._checkConnectionHandler = new Handler();
        this._checkConnection.run();
    }

    private void runWithConnection() {
        this._requestInProgress = true;
        if (!this.tryToShowQueueFromCache()) {
            this.tryEnqueue();
        }
    }

    private void registerReceivers() {
        LocalBroadcastManager.getInstance((Context)this._activity).registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                QueueITEngine.this.raiseQueuePassed();
            }
        }, new IntentFilter("on-queue-passed"));
        LocalBroadcastManager.getInstance((Context)this._activity).registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String url = intent.getExtras().getString("url");
                QueueITEngine.this.updateQueuePageUrl(url);
            }
        }, new IntentFilter("on-changed-queue-url"));
    }

    private boolean tryToShowQueueFromCache() {
        if (this._queueCache.isEmpty()) {
            return false;
        }
        Calendar cachedTime = this._queueCache.getUrlTtl();
        Calendar currentTime = Calendar.getInstance();
        if (currentTime.compareTo(cachedTime) == -1) {
            String queueUrl = this._queueCache.getQueueUrl();
            String targetUrl = this._queueCache.getTargetUrl();
            Log.v((String)"QueueITEngine", (String)String.format("Using queueUrl from cache: %s", queueUrl));
            this.showQueueWithOptionalDelay(queueUrl, targetUrl);
            return true;
        }
        return false;
    }

    private void showQueueWithOptionalDelay(final String queueUrl, final String targetUrl) {
        this.raiseQueueViewWillOpen();
        Handler handler = new Handler();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                QueueITEngine.this.showQueue(queueUrl, targetUrl);
            }
        };
        handler.postDelayed(r, (long)this._delayInterval);
    }

    private void showQueue(String queueUrl, String targetUrl) {
        Intent intent = new Intent((Context)this._activity, QueueActivity.class);
        intent.putExtra("queueUrl", queueUrl);
        intent.putExtra("targetUrl", targetUrl);
        this._activity.startActivity(intent);
    }

    private void raiseQueueViewWillOpen() {
        this._queueListener.onQueueViewWillOpen();
        this._isInQueue = true;
    }

    private void raiseQueuePassed() {
        this._queueCache.clear();
        this._queueListener.onQueuePassed();
        this._isInQueue = false;
        this._requestInProgress = false;
    }

    private void raiseQueueDisabled() {
        this._queueListener.onQueueDisabled();
    }

    private void tryEnqueue() {
        String userId = Settings.Secure.getString((ContentResolver)this._activity.getContentResolver(), (String)"android_id");
        String userAgent = new WebView((Context)this._activity).getSettings().getUserAgentString();
        String sdkVersion = this.getSdkVersion();
        QueueServiceListener queueServiceListener = new QueueServiceListener(){

            @Override
            public void onSuccess(String queueId, String queueUrlString, int requeryInterval, int queueUrlTtlInMinutes, String eventTargetUrl) {
                if (!TextUtils.isEmpty((CharSequence)queueId) && TextUtils.isEmpty((CharSequence)queueUrlString) && requeryInterval == 0) {
                    QueueITEngine.this.raiseQueuePassed();
                } else if (!TextUtils.isEmpty((CharSequence)queueId) && !TextUtils.isEmpty((CharSequence)queueUrlString) && requeryInterval == 0) {
                    QueueITEngine.this.showQueueWithOptionalDelay(queueUrlString, eventTargetUrl);
                    Calendar queueUrlTtl = Calendar.getInstance();
                    queueUrlTtl.add(12, queueUrlTtlInMinutes);
                    QueueITEngine.this._queueCache.update(queueUrlString, queueUrlTtl, eventTargetUrl);
                } else if (TextUtils.isEmpty((CharSequence)queueId) && !TextUtils.isEmpty((CharSequence)queueUrlString) && requeryInterval == 0) {
                    QueueITEngine.this.showQueueWithOptionalDelay(queueUrlString, eventTargetUrl);
                } else if (requeryInterval > 0) {
                    QueueITEngine.this._requestInProgress = false;
                    QueueITEngine.this.raiseQueueDisabled();
                }
            }

            @Override
            public void onFailure(String errorMessage, int errorCode) {
                if (errorCode >= 400 && errorCode < 500) {
                    QueueITEngine.this._queueListener.onError(String.format("Error %s (%s)", errorCode, errorMessage));
                } else {
                    QueueITEngine.this.enqueueRetryMonitor();
                }
            }
        };
        QueueService queueService = new QueueService(this._customerId, this._eventOrAliasId, userId, userAgent, sdkVersion, this._layoutName, this._language, queueServiceListener);
        queueService.init((Context)this._activity);
    }

    private void enqueueRetryMonitor() {
        if (this._deltaSec < 10) {
            Handler handler = new Handler();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    QueueITEngine.this.tryEnqueue();
                }
            };
            handler.postDelayed(r, (long)(this._deltaSec * 1000));
            this._deltaSec *= 2;
        } else {
            this._deltaSec = 1;
            this._requestInProgress = false;
            this._queueListener.onQueueItUnavailable();
        }
    }

    private void updateQueuePageUrl(String queueUrl) {
        if (!this._queueCache.isEmpty()) {
            this._queueCache.update(queueUrl, this._queueCache.getUrlTtl(), this._queueCache.getTargetUrl());
        }
    }

    private String getSdkVersion() {
        return "Android-2.0.7";
    }
}

