/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.queue_it.androidsdk.R;
import java.net.MalformedURLException;
import java.net.URL;

public class QueueActivity
extends AppCompatActivity {
    protected void onCreate(Bundle savedInstanceState) {
        String targetUrl;
        String queueUrl;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_queue);
        final ProgressBar progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        final WebView webView = (WebView)this.findViewById(R.id.webView);
        if (savedInstanceState == null) {
            Bundle extras = this.getIntent().getExtras();
            if (extras == null) {
                queueUrl = null;
                targetUrl = null;
            } else {
                queueUrl = extras.getString("queueUrl");
                targetUrl = extras.getString("targetUrl");
            }
        } else {
            queueUrl = (String)((Object)savedInstanceState.getSerializable("queueUrl"));
            targetUrl = (String)((Object)savedInstanceState.getSerializable("targetUrl"));
        }
        Log.v((String)"QueueITEngine", (String)("Loading initial URL: " + queueUrl));
        webView.getSettings().setJavaScriptEnabled(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                Log.v((String)"Progress", (String)Integer.toString(newProgress));
                if (newProgress < 100) {
                    progressBar.setVisibility(0);
                } else {
                    progressBar.setVisibility(8);
                }
                progressBar.setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }
        });
        webView.setWebViewClient(new WebViewClient(){

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                String errorMessage = Build.VERSION.SDK_INT >= 21 ? String.format("%s %s: %s %s", request.getMethod(), request.getUrl(), errorResponse.getStatusCode(), errorResponse.getReasonPhrase()) : errorResponse.toString();
                Log.v((String)"QueueActivity", (String)String.format("%s: %s", "onReceivedHttpError", errorMessage));
                super.onReceivedHttpError(view, request, errorResponse);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                String errorMessage = Build.VERSION.SDK_INT >= 23 ? String.format("%s %s: %s %s", request.getMethod(), request.getUrl(), error.getErrorCode(), error.getDescription()) : error.toString();
                Log.v((String)"QueueActivity", (String)String.format("%s: %s", "onReceivedError", errorMessage));
                super.onReceivedError(view, request, error);
            }

            public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)QueueActivity.this);
                builder.setMessage(R.string.notification_error_ssl_cert_invalid);
                builder.setPositiveButton(17039379, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.proceed();
                    }
                });
                builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        handler.cancel();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.show();
            }

            public boolean shouldOverrideUrlLoading(WebView view, String urlString) {
                Log.v((String)"QueueITEngine", (String)("URL loading: " + urlString));
                try {
                    URL url = new URL(urlString);
                    URL target = new URL(targetUrl);
                    Intent intentChangedQueueUrl = new Intent("on-changed-queue-url");
                    intentChangedQueueUrl.putExtra("url", urlString);
                    LocalBroadcastManager.getInstance((Context)QueueActivity.this).sendBroadcast(intentChangedQueueUrl);
                    if (target.getHost().contains(url.getHost())) {
                        Intent intent = new Intent("on-queue-passed");
                        LocalBroadcastManager.getInstance((Context)QueueActivity.this).sendBroadcast(intent);
                        webView.loadUrl("about:blank");
                        QueueActivity.this.finish();
                        return true;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return false;
            }
        });
        webView.loadUrl(queueUrl);
    }
}

