/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.webkit.WebView;
import com.queue_it.androidsdk.IUriOverrider;
import com.queue_it.androidsdk.QueueUrlHelper;
import com.queue_it.androidsdk.UriOverrideWrapper;

public class UriOverrider
implements IUriOverrider {
    private Uri queue;
    private Uri target;
    private String userId;

    @Override
    public Uri getQueue() {
        return this.queue;
    }

    @Override
    public void setQueue(Uri queue) {
        this.queue = queue;
    }

    @Override
    public Uri getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Uri target) {
        this.target = target;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    private boolean isBlockedUri(Uri uri) {
        String path = uri.getPath();
        return path.startsWith("/what-is-this.html");
    }

    private boolean isTargetUri(Uri destinationUri) {
        String destinationHost = destinationUri.getHost();
        String destinationPath = destinationUri.getPath();
        String targetHost = this.target.getHost();
        String targetPath = destinationUri.getPath();
        return destinationHost.equalsIgnoreCase(targetHost) && destinationPath.equals(targetPath);
    }

    private boolean isCloseLink(Uri uri) {
        if (!uri.getScheme().equals("queueit")) {
            return false;
        }
        return uri.getHost().equals("close");
    }

    private boolean handleDeepLink(WebView webview, Uri destinationUri, UriOverrideWrapper uriOverride) {
        if (this.isCloseLink(destinationUri)) {
            uriOverride.onCloseClicked();
            return true;
        }
        Intent browserIntent = new Intent("android.intent.action.VIEW", destinationUri);
        webview.getContext().startActivity(browserIntent);
        return true;
    }

    @Override
    public boolean handleNavigationRequest(String destinationUrlStr, WebView webview, UriOverrideWrapper uriOverride) {
        boolean isQueueItUrl;
        boolean isWeb;
        Log.v((String)"QueueITEngine", (String)("URI loading: " + destinationUrlStr));
        Uri destinationUri = Uri.parse((String)destinationUrlStr);
        boolean bl = isWeb = destinationUri.getScheme() != null && (destinationUri.getScheme().equals("http") || destinationUri.getScheme().equals("https"));
        if (!isWeb) {
            return this.handleDeepLink(webview, destinationUri, uriOverride);
        }
        if (this.isBlockedUri(destinationUri)) {
            return true;
        }
        String navigationHost = destinationUri.getHost();
        String queueHost = this.queue.getHost();
        boolean bl2 = isQueueItUrl = navigationHost != null && queueHost != null && queueHost.contains(navigationHost);
        if (isQueueItUrl) {
            boolean needsRewrite = QueueUrlHelper.urlUpdateNeeded(destinationUri, this.userId);
            if (needsRewrite) {
                destinationUri = QueueUrlHelper.updateUrl(destinationUri, this.userId);
                Log.v((String)"QueueITEngine", (String)("URL intercepting: " + destinationUri));
            }
            uriOverride.onQueueUrlChange(destinationUri.toString());
            if (needsRewrite) {
                webview.loadUrl(destinationUri.toString());
                return true;
            }
        }
        if (this.isTargetUri(destinationUri)) {
            String queueItToken = destinationUri.getQueryParameter("queueittoken");
            uriOverride.onPassed(queueItToken);
            return true;
        }
        if (!isQueueItUrl) {
            Intent browserIntent = new Intent("android.intent.action.VIEW", destinationUri);
            webview.getContext().startActivity(browserIntent);
            return true;
        }
        return false;
    }
}

