/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.net.Uri;
import okhttp3.HttpUrl;

public abstract class QueueUrlHelper {
    public static Uri updateUrl(String queueUrl, String userId) {
        try {
            return QueueUrlHelper.updateUrl(Uri.parse((String)queueUrl), userId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Uri.parse((String)queueUrl);
        }
    }

    public static Uri updateUrl(Uri queueUrl, String userId) {
        String encodedQuery = queueUrl.getEncodedQuery();
        String updatedUrl = new HttpUrl.Builder().scheme(queueUrl.getScheme()).host(queueUrl.getHost()).encodedPath(queueUrl.getPath()).addQueryParameter("userId", userId).encodedQuery(encodedQuery).build().url().toString();
        return Uri.parse((String)updatedUrl);
    }

    public static boolean urlUpdateNeeded(String queueUrl, String userId) {
        if (queueUrl == null || userId == null) {
            return false;
        }
        Uri uri = Uri.parse((String)queueUrl);
        return QueueUrlHelper.urlUpdateNeeded(uri, userId);
    }

    public static boolean urlUpdateNeeded(Uri queueUrl, String userId) {
        String userIdQuery;
        if (queueUrl == null) {
            return false;
        }
        String query = queueUrl.getQuery();
        if (query == null) {
            query = "";
        }
        boolean containsUserId = query.startsWith(userIdQuery = String.format("userId=%s", userId)) || query.contains("&" + userIdQuery);
        return !containsUserId;
    }
}

