/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.queue_it.androidsdk.IUriOverrider;
import com.queue_it.androidsdk.IWaitingRoomStateBroadcaster;
import com.queue_it.androidsdk.R;
import com.queue_it.androidsdk.UriOverrideWrapper;
import com.queue_it.androidsdk.UriOverrider;
import com.queue_it.androidsdk.UserAgentManager;
import com.queue_it.androidsdk.WaitingRoomStateBroadcaster;

public class QueueActivityBase {
    private final Activity _context;
    private String queueUrl;
    private String targetUrl;
    private WebView webview;
    @SuppressLint(value={"StaticFieldLeak"})
    private static WebView previousWebView;
    private IUriOverrider uriOverrider;
    private final IWaitingRoomStateBroadcaster broadcaster;
    WebViewClient webviewClient = new WebViewClient(){

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            CookieSyncManager.getInstance().sync();
        }

        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            String errorMessage = Build.VERSION.SDK_INT >= 21 ? String.format("%s %s: %s %s", request.getMethod(), request.getUrl(), errorResponse.getStatusCode(), errorResponse.getReasonPhrase()) : errorResponse.toString();
            Log.v((String)"QueueActivity", (String)String.format("%s: %s", "onReceivedHttpError", errorMessage));
            super.onReceivedHttpError(view, request, errorResponse);
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            String errorMessage = Build.VERSION.SDK_INT >= 23 ? String.format("%s %s: %s %s", request.getMethod(), request.getUrl(), error.getErrorCode(), error.getDescription()) : error.toString();
            Log.v((String)"QueueActivity", (String)String.format("%s: %s", "onReceivedError", errorMessage));
            super.onReceivedError(view, request, error);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            handler.cancel();
            QueueActivityBase.this.broadcaster.broadcastQueueError("SslError, code: " + error.getPrimaryError());
            QueueActivityBase.this.disposeWebview(QueueActivityBase.this.webview);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String urlString) {
            return QueueActivityBase.this.uriOverrider.handleNavigationRequest(urlString, QueueActivityBase.this.webview, new UriOverrideWrapper(){

                @Override
                protected void onQueueUrlChange(String uri) {
                    QueueActivityBase.this.broadcaster.broadcastChangedQueueUrl(uri);
                }

                @Override
                protected void onPassed(String queueItToken) {
                    QueueActivityBase.this.broadcaster.broadcastQueuePassed(queueItToken);
                    QueueActivityBase.this.disposeWebview(QueueActivityBase.this.webview);
                }

                @Override
                protected void onCloseClicked() {
                    QueueActivityBase.this.broadcaster.broadcastWebViewClosed();
                    QueueActivityBase.this.disposeWebview(QueueActivityBase.this.webview);
                }
            });
        }
    };

    public QueueActivityBase(Activity context) {
        this._context = context;
        this.broadcaster = new WaitingRoomStateBroadcaster((Context)this._context);
    }

    private static void cleanupWebView() {
        if (previousWebView == null) {
            return;
        }
        previousWebView.destroy();
        previousWebView = null;
    }

    public void initialize(Bundle savedInstanceState) {
        this.uriOverrider = new UriOverrider();
        this._context.setContentView(R.layout.activity_queue);
        this.readActivityUrls(savedInstanceState);
        QueueActivityBase.cleanupWebView();
        final ProgressBar progressBar = (ProgressBar)this._context.findViewById(R.id.progressBar);
        FrameLayout layout2 = (FrameLayout)this._context.findViewById(R.id.relativeLayout);
        this.webview = new WebView((Context)this._context);
        layout2.addView((View)this.webview);
        previousWebView = this.webview;
        this.webview.getSettings().setJavaScriptEnabled(true);
        this.webview.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                Log.v((String)"Progress", (String)Integer.toString(newProgress));
                if (newProgress < 100) {
                    progressBar.setVisibility(0);
                } else {
                    progressBar.setVisibility(8);
                }
                progressBar.setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }
        });
        this.webview.setWebViewClient(this.webviewClient);
        Log.v((String)"QueueITEngine", (String)("Loading initial URL: " + this.queueUrl));
        this.setUserAgent(UserAgentManager.getUserAgent());
        this.webview.loadUrl(this.queueUrl);
    }

    public void saveInstanceState(Bundle outState) {
        outState.putString("queueUrl", this.queueUrl);
        outState.putString("targetUrl", this.targetUrl);
        outState.putString("userId", this.uriOverrider.getUserId());
    }

    public void destroy() {
        if (this._context.isFinishing()) {
            this.broadcaster.broadcastQueueActivityClosed();
        }
    }

    private void readActivityUrls(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            Bundle extras = this._context.getIntent().getExtras();
            if (extras == null) {
                this.queueUrl = null;
                this.targetUrl = null;
            } else {
                this.queueUrl = extras.getString("queueUrl");
                this.targetUrl = extras.getString("targetUrl");
                this.uriOverrider.setUserId(extras.getString("userId"));
            }
        } else {
            this.queueUrl = (String)((Object)savedInstanceState.getSerializable("queueUrl"));
            this.targetUrl = (String)((Object)savedInstanceState.getSerializable("targetUrl"));
            this.uriOverrider.setUserId((String)((Object)savedInstanceState.getSerializable("userId")));
        }
        this.uriOverrider.setTarget(Uri.parse((String)this.targetUrl));
        this.uriOverrider.setQueue(Uri.parse((String)this.queueUrl));
    }

    private void disposeWebview(WebView webView) {
        webView.loadUrl("about:blank");
        this._context.finish();
    }

    private void setUserAgent(String userAgent) {
        System.setProperty("http.agent", userAgent);
        this.webview.getSettings().setUserAgentString(userAgent);
    }
}

