/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.webkit.WebView;
import com.queue_it.androidsdk.IUriOverrider;
import com.queue_it.androidsdk.QueueUrlHelper;
import com.queue_it.androidsdk.UriOverrideWrapper;

public class UriOverrider
implements IUriOverrider {
    private Uri queue;
    private Uri target;
    private String userId;

    @Override
    public Uri getQueue() {
        return this.queue;
    }

    @Override
    public void setQueue(Uri queue) {
        this.queue = queue;
    }

    @Override
    public Uri getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Uri target) {
        this.target = target;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean handleNavigationRequest(String uriString, WebView webview, UriOverrideWrapper uriOverride) {
        boolean isTarget;
        boolean isQueueItUrl;
        boolean isWeb;
        Log.v((String)"QueueITEngine", (String)("URI loading: " + uriString));
        Uri navigationUri = Uri.parse((String)uriString);
        boolean bl = isWeb = navigationUri.getScheme() != null && (navigationUri.getScheme().equals("http") || navigationUri.getScheme().equals("https"));
        if (!isWeb) {
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)uriString));
            webview.getContext().startActivity(browserIntent);
            return true;
        }
        String navigationHost = navigationUri.getHost();
        String queueHost = this.queue.getHost();
        boolean bl2 = isQueueItUrl = navigationHost != null && queueHost != null && queueHost.contains(navigationHost);
        if (isQueueItUrl) {
            boolean needsRewrite = QueueUrlHelper.urlUpdateNeeded(uriString, this.userId);
            if (needsRewrite) {
                uriString = QueueUrlHelper.updateUrl(uriString, this.userId);
                Log.v((String)"QueueITEngine", (String)("URL intercepting: " + uriString));
            }
            uriOverride.onQueueUrlChange(uriString);
            if (needsRewrite) {
                webview.loadUrl(uriString);
                return true;
            }
        }
        String targetHost = this.target.getHost();
        boolean bl3 = isTarget = navigationHost != null && targetHost != null && targetHost.contains(navigationHost);
        if (isTarget) {
            Uri uri = Uri.parse((String)uriString);
            String queueItToken = uri.getQueryParameter("queueittoken");
            uriOverride.onPassed(queueItToken);
            return true;
        }
        if (!isQueueItUrl) {
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)uriString));
            webview.getContext().startActivity(browserIntent);
            return true;
        }
        return false;
    }
}

