/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.queue_it.androidsdk.IUriOverrider;
import com.queue_it.androidsdk.R;
import com.queue_it.androidsdk.UriOverrideWrapper;
import com.queue_it.androidsdk.UriOverrider;

public class QueueActivity
extends AppCompatActivity {
    private String queueUrl;
    private String targetUrl;
    private WebView webview;
    @SuppressLint(value={"StaticFieldLeak"})
    private static WebView previousWebView;
    private IUriOverrider uriOverrider;
    WebViewClient webviewClient = new WebViewClient(){

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            CookieSyncManager.getInstance().sync();
        }

        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            String errorMessage = Build.VERSION.SDK_INT >= 21 ? String.format("%s %s: %s %s", request.getMethod(), request.getUrl(), errorResponse.getStatusCode(), errorResponse.getReasonPhrase()) : errorResponse.toString();
            Log.v((String)"QueueActivity", (String)String.format("%s: %s", "onReceivedHttpError", errorMessage));
            super.onReceivedHttpError(view, request, errorResponse);
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            String errorMessage = Build.VERSION.SDK_INT >= 23 ? String.format("%s %s: %s %s", request.getMethod(), request.getUrl(), error.getErrorCode(), error.getDescription()) : error.toString();
            Log.v((String)"QueueActivity", (String)String.format("%s: %s", "onReceivedError", errorMessage));
            super.onReceivedError(view, request, error);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            handler.cancel();
            QueueActivity.this.broadcastQueueError("SslError, code: " + error.getPrimaryError());
            QueueActivity.this.disposeWebview(QueueActivity.this.webview);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String urlString) {
            return QueueActivity.this.uriOverrider.handleNavigationRequest(urlString, QueueActivity.this.webview, new UriOverrideWrapper(){

                @Override
                void onQueueUrlChange(String uri) {
                    QueueActivity.this.broadcastChangedQueueUrl(uri);
                }

                @Override
                void onPassed(String queueItToken) {
                    QueueActivity.this.broadcastQueuePassed(queueItToken);
                    QueueActivity.this.disposeWebview(QueueActivity.this.webview);
                }
            });
        }
    };

    private static void cleanupWebView() {
        if (previousWebView == null) {
            return;
        }
        previousWebView.destroy();
        previousWebView = null;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.uriOverrider = new UriOverrider();
        this.setContentView(R.layout.activity_queue);
        this.readActivityUrls(savedInstanceState);
        QueueActivity.cleanupWebView();
        final ProgressBar progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        FrameLayout layout2 = (FrameLayout)this.findViewById(R.id.relativeLayout);
        this.webview = new WebView((Context)this);
        layout2.addView((View)this.webview);
        previousWebView = this.webview;
        this.webview.getSettings().setJavaScriptEnabled(true);
        this.webview.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                Log.v((String)"Progress", (String)Integer.toString(newProgress));
                if (newProgress < 100) {
                    progressBar.setVisibility(0);
                } else {
                    progressBar.setVisibility(8);
                }
                progressBar.setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }
        });
        this.webview.setWebViewClient(this.webviewClient);
        Log.v((String)"QueueITEngine", (String)("Loading initial URL: " + this.queueUrl));
        this.webview.loadUrl(this.queueUrl);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("queueUrl", this.queueUrl);
        outState.putString("targetUrl", this.targetUrl);
        outState.putString("userId", this.uriOverrider.getUserId());
    }

    protected void onDestroy() {
        if (this.isFinishing()) {
            this.broadcastQueueActivityClosed();
        }
        super.onDestroy();
    }

    private void readActivityUrls(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            Bundle extras = this.getIntent().getExtras();
            if (extras == null) {
                this.queueUrl = null;
                this.targetUrl = null;
            } else {
                this.queueUrl = extras.getString("queueUrl");
                this.targetUrl = extras.getString("targetUrl");
                this.uriOverrider.setUserId(extras.getString("userId"));
            }
        } else {
            this.queueUrl = (String)((Object)savedInstanceState.getSerializable("queueUrl"));
            this.targetUrl = (String)((Object)savedInstanceState.getSerializable("targetUrl"));
            this.uriOverrider.setUserId((String)((Object)savedInstanceState.getSerializable("userId")));
        }
        this.uriOverrider.setTarget(Uri.parse((String)this.targetUrl));
        this.uriOverrider.setQueue(Uri.parse((String)this.queueUrl));
    }

    private void broadcastChangedQueueUrl(String urlString) {
        Intent intentChangedQueueUrl = new Intent("on-changed-queue-url");
        intentChangedQueueUrl.putExtra("url", urlString);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intentChangedQueueUrl);
    }

    private void broadcastQueuePassed(String queueItToken) {
        Intent intent = new Intent("on-queue-passed");
        intent.putExtra("queue-it-token", queueItToken);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    private void broadcastQueueActivityClosed() {
        Intent intent = new Intent("queue-activity-closed");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    public void broadcastUserExited() {
        Intent intent = new Intent("queue-user-exited");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    private void broadcastQueueError(String errorMessage) {
        Intent intent = new Intent("on-queue-error");
        intent.putExtra("error-message", errorMessage);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    private void disposeWebview(WebView webView) {
        webView.loadUrl("about:blank");
        this.finish();
    }
}

