/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.provider.Settings;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import com.queue_it.androidsdk.Error;
import com.queue_it.androidsdk.QueueActivity;
import com.queue_it.androidsdk.QueueCache;
import com.queue_it.androidsdk.QueueITException;
import com.queue_it.androidsdk.QueueListener;
import com.queue_it.androidsdk.QueuePassedInfo;
import com.queue_it.androidsdk.QueueService;
import com.queue_it.androidsdk.QueueServiceListener;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;

public class QueueITEngine {
    private String _customerId;
    private String _eventOrAliasId;
    private String _layoutName;
    private String _language;
    private QueueListener _queueListener;
    private QueueCache _queueCache;
    private Context _context;
    private AtomicBoolean _requestInProgress;
    private boolean _isInQueue;
    private static final int INITIAL_WAIT_RETRY_SEC = 1;
    private static final int MAX_RETRY_SEC = 10;
    private int _deltaSec;
    private int _delayInterval = 0;
    private Handler _checkConnectionHandler;
    private int _isOnlineRetry = 0;
    private Runnable _checkConnection = new Runnable(){

        @Override
        public void run() {
            if (QueueITEngine.this.isOnline()) {
                QueueITEngine.this.runWithConnection();
                return;
            }
            QueueITEngine.this._isOnlineRetry++;
            if (QueueITEngine.this._isOnlineRetry > 5) {
                QueueITEngine.this._queueListener.onError(Error.NO_CONNECTION, "No connection");
                return;
            }
            QueueITEngine.this._checkConnectionHandler.postDelayed((Runnable)this, 1000L);
        }
    };
    private BroadcastReceiver _queuePassedBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            QueueITEngine.this.raiseQueuePassed(intent.getStringExtra("queue-it-token"));
        }
    };
    private BroadcastReceiver _queueErrorBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            QueueITEngine.this._queueListener.onError(Error.SSL_ERROR, intent.getStringExtra("error-message"));
        }
    };
    private BroadcastReceiver _queueUrlChangedBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String url = intent.getExtras().getString("url");
            QueueITEngine.this.updateQueuePageUrl(url);
        }
    };
    private BroadcastReceiver _queueActivityClosedBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            QueueITEngine.this.unregisterReceivers();
        }
    };

    public QueueITEngine(Activity applicationContext, String customerId, String eventOrAliasId, QueueListener queueListener) {
        this(applicationContext, customerId, eventOrAliasId, "", "", queueListener);
    }

    public QueueITEngine(Activity activityContext, String customerId, String eventOrAliasId, String layoutName, String language, QueueListener queueListener) {
        this._requestInProgress = new AtomicBoolean(false);
        if (TextUtils.isEmpty((CharSequence)customerId)) {
            throw new IllegalArgumentException("customerId must have a value");
        }
        if (TextUtils.isEmpty((CharSequence)eventOrAliasId)) {
            throw new IllegalArgumentException("eventOrAliasId must have a value");
        }
        this._context = activityContext;
        this._customerId = customerId;
        this._eventOrAliasId = eventOrAliasId;
        this._layoutName = layoutName;
        this._language = language;
        this._queueListener = queueListener;
        this._queueCache = new QueueCache(this._context, customerId, eventOrAliasId);
        this._deltaSec = 1;
    }

    public void setViewDelay(int delayInterval) {
        this._delayInterval = delayInterval;
    }

    public boolean isInQueue() {
        return this._isInQueue;
    }

    public boolean IsRequestInProgress() {
        return this._requestInProgress.get();
    }

    private boolean isOnline() {
        ConnectivityManager cm = (ConnectivityManager)this._context.getSystemService("connectivity");
        if (cm == null) {
            return true;
        }
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected();
    }

    public void run(Activity activityContext, boolean clearCache) throws QueueITException {
        if (clearCache) {
            this._queueCache.clear();
        }
        this.run(activityContext);
    }

    public void run(Activity activityContext) throws QueueITException {
        if (this._requestInProgress.getAndSet(true)) {
            throw new QueueITException("Request is already in progress");
        }
        this._context = activityContext;
        this._checkConnectionHandler = new Handler();
        this._checkConnection.run();
    }

    private void runWithConnection() {
        if (!this.tryToShowQueueFromCache()) {
            this.tryEnqueue();
        }
        this._requestInProgress.set(false);
    }

    private void registerReceivers() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this._context);
        localBroadcastManager.registerReceiver(this._queuePassedBroadcastReceiver, new IntentFilter("on-queue-passed"));
        localBroadcastManager.registerReceiver(this._queueUrlChangedBroadcastReceiver, new IntentFilter("on-changed-queue-url"));
        localBroadcastManager.registerReceiver(this._queueActivityClosedBroadcastReceiver, new IntentFilter("queue-activity-closed"));
        localBroadcastManager.registerReceiver(this._queueErrorBroadcastReceiver, new IntentFilter("on-queue-error"));
    }

    private void unregisterReceivers() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this._context);
        localBroadcastManager.unregisterReceiver(this._queuePassedBroadcastReceiver);
        localBroadcastManager.unregisterReceiver(this._queueUrlChangedBroadcastReceiver);
        localBroadcastManager.unregisterReceiver(this._queueActivityClosedBroadcastReceiver);
        localBroadcastManager.unregisterReceiver(this._queueErrorBroadcastReceiver);
    }

    private boolean tryToShowQueueFromCache() {
        if (this._queueCache.isEmpty()) {
            return false;
        }
        Calendar cachedTime = this._queueCache.getUrlTtl();
        Calendar currentTime = Calendar.getInstance();
        if (currentTime.compareTo(cachedTime) < 0) {
            String queueUrl = this._queueCache.getQueueUrl();
            String targetUrl = this._queueCache.getTargetUrl();
            Log.v((String)"QueueITEngine", (String)String.format("Using queueUrl from cache: %s", queueUrl));
            this.showQueueWithOptionalDelay(queueUrl, targetUrl);
            return true;
        }
        return false;
    }

    private void showQueueWithOptionalDelay(final String queueUrl, final String targetUrl) {
        this.raiseQueueViewWillOpen();
        Handler handler = new Handler();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                QueueITEngine.this.showQueue(queueUrl, targetUrl);
            }
        };
        handler.postDelayed(r, (long)this._delayInterval);
    }

    private void showQueue(String queueUrl, String targetUrl) {
        this.registerReceivers();
        Intent intent = new Intent(this._context, QueueActivity.class);
        intent.putExtra("queueUrl", queueUrl);
        intent.putExtra("targetUrl", targetUrl);
        intent.putExtra("userId", this.getUserId());
        this._context.startActivity(intent);
    }

    private void raiseQueueViewWillOpen() {
        this._queueListener.onQueueViewWillOpen();
        this._isInQueue = true;
    }

    private void raiseQueuePassed(String queueItToken) {
        this._queueCache.clear();
        this._queueListener.onQueuePassed(new QueuePassedInfo(queueItToken));
        this._isInQueue = false;
        this._requestInProgress.set(false);
    }

    private void raiseQueueDisabled() {
        this._queueListener.onQueueDisabled();
    }

    private String getUserId() {
        return Settings.Secure.getString((ContentResolver)this._context.getContentResolver(), (String)"android_id");
    }

    private void tryEnqueue() {
        String userId = this.getUserId();
        String userAgent = new WebView(this._context).getSettings().getUserAgentString();
        String sdkVersion = this.getSdkVersion();
        QueueServiceListener queueServiceListener = new QueueServiceListener(){

            @Override
            public void onSuccess(String queueId, String queueUrlString, int queueUrlTtlInMinutes, String eventTargetUrl, String queueItToken) {
                if (QueueITEngine.this.IsSafetyNet(queueId, queueUrlString)) {
                    QueueITEngine.this.raiseQueuePassed(queueItToken);
                } else if (QueueITEngine.this.IsInQueue(queueId, queueUrlString)) {
                    QueueITEngine.this.showQueueWithOptionalDelay(queueUrlString, eventTargetUrl);
                    Calendar queueUrlTtl = Calendar.getInstance();
                    queueUrlTtl.add(12, queueUrlTtlInMinutes);
                    QueueITEngine.this._queueCache.update(queueUrlString, queueUrlTtl, eventTargetUrl);
                } else if (QueueITEngine.this.IsIdle(queueId, queueUrlString)) {
                    QueueITEngine.this.showQueueWithOptionalDelay(queueUrlString, eventTargetUrl);
                } else {
                    QueueITEngine.this.raiseQueueDisabled();
                }
                QueueITEngine.this._requestInProgress.set(false);
            }

            @Override
            public void onFailure(String errorMessage, int errorCode) {
                Log.v((String)"QueueITEngine", (String)String.format("Error: %s: %s", errorCode, errorMessage));
                if (errorCode >= 400 && errorCode < 500) {
                    QueueITEngine.this._queueListener.onError(Error.INVALID_RESPONSE, String.format("Error %s (%s)", errorCode, errorMessage));
                } else {
                    QueueITEngine.this.enqueueRetryMonitor();
                }
            }
        };
        QueueService queueService = new QueueService(this._customerId, this._eventOrAliasId, userId, userAgent, sdkVersion, this._layoutName, this._language, queueServiceListener);
        queueService.init(this._context);
    }

    private boolean IsSafetyNet(String queueId, String queueUrlString) {
        return !TextUtils.isEmpty((CharSequence)queueId) && TextUtils.isEmpty((CharSequence)queueUrlString);
    }

    private boolean IsInQueue(String queueId, String queueUrlString) {
        return !TextUtils.isEmpty((CharSequence)queueId) && !TextUtils.isEmpty((CharSequence)queueUrlString);
    }

    private boolean IsIdle(String queueId, String queueUrlString) {
        return TextUtils.isEmpty((CharSequence)queueId) && !TextUtils.isEmpty((CharSequence)queueUrlString);
    }

    private void enqueueRetryMonitor() {
        if (this._deltaSec < 10) {
            Handler handler = new Handler();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    QueueITEngine.this.tryEnqueue();
                }
            };
            handler.postDelayed(r, (long)(this._deltaSec * 1000));
            this._deltaSec *= 2;
        } else {
            this._deltaSec = 1;
            this._requestInProgress.set(false);
            this._queueListener.onQueueItUnavailable();
        }
    }

    private void updateQueuePageUrl(String queueUrl) {
        if (!this._queueCache.isEmpty()) {
            this._queueCache.update(queueUrl, this._queueCache.getUrlTtl(), this._queueCache.getTargetUrl());
        }
    }

    private String getSdkVersion() {
        return "Android-2.0.22";
    }
}

