/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.queue_it.androidsdk.R;
import java.net.MalformedURLException;
import java.net.URL;

public class QueueActivity
extends AppCompatActivity {
    private String queueUrl;
    private String targetUrl;

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("queueUrl", this.queueUrl);
        outState.putString("targetUrl", this.targetUrl);
    }

    protected void onDestroy() {
        if (this.isFinishing()) {
            this.broadcastQueueActivityClosed();
        }
        super.onDestroy();
    }

    protected void onCreate(Bundle savedInstanceState) {
        URL queue;
        URL target;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_queue);
        final ProgressBar progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        final WebView webView = (WebView)this.findViewById(R.id.webView);
        if (savedInstanceState == null) {
            Bundle extras = this.getIntent().getExtras();
            if (extras == null) {
                this.queueUrl = null;
                this.targetUrl = null;
            } else {
                this.queueUrl = extras.getString("queueUrl");
                this.targetUrl = extras.getString("targetUrl");
            }
        } else {
            this.queueUrl = (String)((Object)savedInstanceState.getSerializable("queueUrl"));
            this.targetUrl = (String)((Object)savedInstanceState.getSerializable("targetUrl"));
        }
        try {
            target = new URL(this.targetUrl);
            queue = new URL(this.queueUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Log.v((String)"QueueITEngine", (String)("Loading initial URL: " + this.queueUrl));
        webView.getSettings().setJavaScriptEnabled(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                Log.v((String)"Progress", (String)Integer.toString(newProgress));
                if (newProgress < 100) {
                    progressBar.setVisibility(0);
                } else {
                    progressBar.setVisibility(8);
                }
                progressBar.setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }
        });
        webView.setWebViewClient(new WebViewClient(){

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                String errorMessage = Build.VERSION.SDK_INT >= 21 ? String.format("%s %s: %s %s", request.getMethod(), request.getUrl(), errorResponse.getStatusCode(), errorResponse.getReasonPhrase()) : errorResponse.toString();
                Log.v((String)"QueueActivity", (String)String.format("%s: %s", "onReceivedHttpError", errorMessage));
                super.onReceivedHttpError(view, request, errorResponse);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                String errorMessage = Build.VERSION.SDK_INT >= 23 ? String.format("%s %s: %s %s", request.getMethod(), request.getUrl(), error.getErrorCode(), error.getDescription()) : error.toString();
                Log.v((String)"QueueActivity", (String)String.format("%s: %s", "onReceivedError", errorMessage));
                super.onReceivedError(view, request, error);
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                handler.cancel();
                QueueActivity.this.broadcastQueueError("SslError, code: " + error.getPrimaryError());
                QueueActivity.this.disposeWebview(webView);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String urlString) {
                URL url;
                Log.v((String)"QueueITEngine", (String)("URL loading: " + urlString));
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                boolean isQueueUrl = queue.getHost().contains(url.getHost());
                if (isQueueUrl) {
                    QueueActivity.this.broadcastChangedQueueUrl(urlString);
                }
                if (target.getHost().contains(url.getHost())) {
                    Uri uri = Uri.parse((String)urlString);
                    String queueItToken = uri.getQueryParameter("queueittoken");
                    QueueActivity.this.broadcastQueuePassed(queueItToken);
                    QueueActivity.this.disposeWebview(webView);
                    return true;
                }
                if (!isQueueUrl) {
                    Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)urlString));
                    QueueActivity.this.startActivity(browserIntent);
                    return true;
                }
                return false;
            }
        });
        webView.loadUrl(this.queueUrl);
    }

    private void broadcastChangedQueueUrl(String urlString) {
        Intent intentChangedQueueUrl = new Intent("on-changed-queue-url");
        intentChangedQueueUrl.putExtra("url", urlString);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intentChangedQueueUrl);
    }

    private void broadcastQueuePassed(String queueItToken) {
        Intent intent = new Intent("on-queue-passed");
        intent.putExtra("queue-it-token", queueItToken);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    private void broadcastQueueActivityClosed() {
        Intent intent = new Intent("queue-activity-closed");
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    private void broadcastQueueError(String errorMessage) {
        Intent intent = new Intent("on-queue-error");
        intent.putExtra("error-message", errorMessage);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    private void disposeWebview(WebView webView) {
        webView.loadUrl("about:blank");
        this.finish();
    }
}

