/*
 * Decompiled with CFR 0.152.
 */
package com.queue_it.androidsdk;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.queue_it.androidsdk.QueueServiceListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class QueueService {
    private String _customerId;
    private String _eventOrAliasId;
    private String _userId;
    private String _userAgent;
    private String _sdkVersion;
    private String _layoutName;
    private String _language;
    private QueueServiceListener _queueServiceListener;
    public static boolean IsTest = false;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    private String getApiUrl() {
        if (IsTest) {
            return "https://%s.test.queue-it.net/api/queue/%s/%s/appenqueue";
        }
        return "https://%s.queue-it.net/api/queue/%s/%s/appenqueue";
    }

    public QueueService(String customerId, String eventOrAliasId, String userId, String userAgent, String sdkVersion, String layoutName, String language, QueueServiceListener queueServiceListener) {
        this._customerId = customerId;
        this._eventOrAliasId = eventOrAliasId;
        this._userId = userId;
        this._userAgent = userAgent;
        this._sdkVersion = sdkVersion;
        this._layoutName = layoutName;
        this._language = language;
        this._queueServiceListener = queueServiceListener;
    }

    public void init(final Context context) {
        String url = String.format(this.getApiUrl(), this._customerId, this._customerId, this._eventOrAliasId);
        OkHttpClient client = new OkHttpClient();
        String putBody = this.getJsonObject().toString();
        RequestBody body = RequestBody.create((MediaType)JSON, (String)putBody);
        Log.v((String)"QueueITEngine", (String)("API call " + QueueService.getISO8601StringForDate(Calendar.getInstance().getTime()) + ": " + url + ": " + putBody));
        Request request = new Request.Builder().url(url).put(body).build();
        client.newCall(request).enqueue(new Callback(){
            Handler mainHandler;
            {
                this.mainHandler = new Handler(context.getMainLooper());
            }

            public void onFailure(Call call, IOException e) {
                final String message = e.toString();
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        QueueService.this._queueServiceListener.onFailure(message, 0);
                    }
                });
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    final String errorMessage = String.format("%s %s", response.message(), response.body().string());
                    final int code = response.code();
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            QueueService.this._queueServiceListener.onFailure(errorMessage, code);
                        }
                    });
                    return;
                }
                final String body = response.body().string();
                try {
                    JSONObject jsonObject = new JSONObject(body);
                    final String queueId = QueueService.this.optString(jsonObject, "QueueId");
                    final String queueUrl = QueueService.this.optString(jsonObject, "QueueUrl");
                    final int queueUrlTtlInMinutes = QueueService.this.optInt(jsonObject, "QueueUrlTTLInMinutes");
                    final String eventTargetUrl = QueueService.this.optString(jsonObject, "EventTargetUrl");
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            QueueService.this._queueServiceListener.onSuccess(queueId, queueUrl, queueUrlTtlInMinutes, eventTargetUrl);
                        }
                    });
                }
                catch (JSONException e) {
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            QueueService.this._queueServiceListener.onFailure("Server did not return valid JSON: " + body, 0);
                        }
                    });
                }
            }
        });
    }

    private static String getISO8601StringForDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    private String optString(JSONObject json, String key) {
        if (json.isNull(key)) {
            return null;
        }
        return json.optString(key, null);
    }

    private int optInt(JSONObject json, String key) {
        if (json.isNull(key)) {
            return 0;
        }
        return json.optInt(key, 0);
    }

    private JSONObject getJsonObject() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("userId", (Object)this._userId);
            jsonObject.put("userAgent", (Object)this._userAgent);
            jsonObject.put("sdkVersion", (Object)this._sdkVersion);
            if (!TextUtils.isEmpty((CharSequence)this._layoutName)) {
                jsonObject.put("layoutName", (Object)this._layoutName);
            }
            if (!TextUtils.isEmpty((CharSequence)this._language)) {
                jsonObject.put("language", (Object)this._language);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

