/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.types;

import com.querydsl.sql.types.AbstractJSR310DateTimeType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import org.jetbrains.annotations.Nullable;

public class JSR310LocalTimeType
extends AbstractJSR310DateTimeType<LocalTime> {
    public JSR310LocalTimeType() {
        super(92);
    }

    public JSR310LocalTimeType(int type) {
        super(type);
    }

    @Override
    public String getLiteral(LocalTime value) {
        return timeFormatter.format(value);
    }

    @Override
    public Class<LocalTime> getReturnedClass() {
        return LocalTime.class;
    }

    @Override
    @Nullable
    public LocalTime getValue(ResultSet rs, int startIndex) throws SQLException {
        Time time = rs.getTime(startIndex, JSR310LocalTimeType.utc());
        return time != null ? LocalTime.ofNanoOfDay(time.getTime() * 1000000L) : null;
    }

    @Override
    public void setValue(PreparedStatement st, int startIndex, LocalTime value) throws SQLException {
        st.setTime(startIndex, new Time(value.get(ChronoField.MILLI_OF_DAY)), JSR310LocalTimeType.utc());
    }
}

