/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.mongodb.morphia;

import com.mongodb.DBRef;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.mongodb.MongodbSerializer;
import java.lang.reflect.AnnotatedElement;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Property;
import org.mongodb.morphia.annotations.Reference;

public class MorphiaSerializer
extends MongodbSerializer {
    private final Morphia morphia;

    public MorphiaSerializer(Morphia morphia) {
        this.morphia = morphia;
    }

    @Override
    protected String getKeyForPath(Path<?> expr, PathMetadata metadata) {
        Reference reference;
        AnnotatedElement annotations = expr.getAnnotatedElement();
        if (annotations.isAnnotationPresent(Id.class)) {
            Path parent = expr.getMetadata().getParent();
            if (parent.getAnnotatedElement().isAnnotationPresent(Reference.class)) {
                return null;
            }
            return "_id";
        }
        if (annotations.isAnnotationPresent(Property.class)) {
            Property property = annotations.getAnnotation(Property.class);
            if (!property.value().equals(".")) {
                return property.value();
            }
        } else if (annotations.isAnnotationPresent(Reference.class) && !(reference = annotations.getAnnotation(Reference.class)).value().equals(".")) {
            return reference.value();
        }
        return super.getKeyForPath(expr, metadata);
    }

    @Override
    protected boolean isReference(Path<?> arg) {
        return arg.getAnnotatedElement().isAnnotationPresent(Reference.class);
    }

    @Override
    protected boolean isId(Path<?> arg) {
        return arg.getAnnotatedElement().isAnnotationPresent(Id.class);
    }

    @Override
    protected DBRef asReference(Object constant) {
        Key key = this.morphia.getMapper().getKey(constant);
        return this.morphia.getMapper().keyToRef(key);
    }

    @Override
    protected DBRef asReferenceKey(Class<?> entity, Object id) {
        Key key = new Key(entity, id);
        return this.morphia.getMapper().keyToRef(key);
    }
}

