/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.collections;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.util.MathUtils;
import com.querydsl.core.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class CollQueryFunctions {
    private static final BinaryFunction SUM = new BinaryFunction(){

        @Override
        public Number apply(Number num1, Number num2) {
            return MathUtils.sum((Number)num1, (Number)num2);
        }
    };
    private static final BinaryFunction MAX = new BinaryFunction(){

        @Override
        public Number apply(Number num1, Number num2) {
            BigDecimal n2;
            if (num1.getClass().equals(num2.getClass()) && num1 instanceof Comparable) {
                Comparable left = (Comparable)((Object)num1);
                return left.compareTo(num2) < 0 ? (Number)num2 : (Number)num1;
            }
            BigDecimal n1 = new BigDecimal(num1.toString());
            return n1.compareTo(n2 = new BigDecimal(num2.toString())) < 0 ? (Number)num2 : (Number)num1;
        }
    };
    private static final BinaryFunction MIN = new BinaryFunction(){

        @Override
        public Number apply(Number num1, Number num2) {
            BigDecimal n2;
            if (num1.getClass().equals(num2.getClass()) && num1 instanceof Comparable) {
                Comparable left = (Comparable)((Object)num1);
                return left.compareTo(num2) < 0 ? (Number)num1 : (Number)num2;
            }
            BigDecimal n1 = new BigDecimal(num1.toString());
            return n1.compareTo(n2 = new BigDecimal(num2.toString())) < 0 ? (Number)num1 : (Number)num2;
        }
    };
    private static final List<Object> nullList = Arrays.asList(new Object[]{null});

    public static boolean equals(Object o1, Object o2) {
        return Objects.equal((Object)o1, (Object)o2);
    }

    public static <T extends Comparable<? super T>> int compareTo(T c1, T c2) {
        if (c1 == null) {
            return c2 == null ? 0 : -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public static <A extends Comparable<? super A>> boolean between(A a, A b, A c) {
        return CollQueryFunctions.compareTo(a, b) >= 0 && CollQueryFunctions.compareTo(a, c) <= 0;
    }

    public static double cot(double x) {
        return Math.cos(x) / Math.sin(x);
    }

    public static double coth(double x) {
        return Math.cosh(x) / Math.sinh(x);
    }

    public static double degrees(double x) {
        return x * 180.0 / Math.PI;
    }

    public static double radians(double x) {
        return x * Math.PI / 180.0;
    }

    public static double log(double x, int y) {
        return Math.log(x) / Math.log(y);
    }

    @Nullable
    public static <T> T coalesce(T ... args) {
        for (T arg : args) {
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public static <T> T nullif(T first, T second) {
        if (first.equals(second)) {
            return null;
        }
        return first;
    }

    public static int getYearMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1) * 100 + cal.get(2) + 1;
    }

    public static int getDayOfMonth(Date date) {
        return CollQueryFunctions.getField(date, 5);
    }

    public static int getDayOfWeek(Date date) {
        return CollQueryFunctions.getField(date, 7);
    }

    public static int getDayOfYear(Date date) {
        return CollQueryFunctions.getField(date, 6);
    }

    private static int getField(Date date, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(field);
    }

    public static int getHour(Date date) {
        return CollQueryFunctions.getField(date, 11);
    }

    public static int getMilliSecond(Date date) {
        return CollQueryFunctions.getField(date, 14);
    }

    public static int getMinute(Date date) {
        return CollQueryFunctions.getField(date, 12);
    }

    public static int getMonth(Date date) {
        return CollQueryFunctions.getField(date, 2) + 1;
    }

    public static int getSecond(Date date) {
        return CollQueryFunctions.getField(date, 13);
    }

    public static int getWeek(Date date) {
        return CollQueryFunctions.getField(date, 3);
    }

    public static int getYear(Date date) {
        return CollQueryFunctions.getField(date, 1);
    }

    public static int getYearWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1) * 100 + cal.get(3);
    }

    public static <T> Collection<T> leftJoin(Collection<T> coll) {
        if (coll == null || coll.isEmpty()) {
            List<Object> rv = nullList;
            return rv;
        }
        return coll;
    }

    private static Number reduce(Iterable<Number> source, BinaryFunction f) {
        Iterator<Number> it = source.iterator();
        Number result = it.next();
        while (it.hasNext()) {
            result = f.apply(result, it.next());
        }
        return result;
    }

    public static Number aggregate(Collection<Number> source, Expression<?> expr, Operator aggregator) {
        Class numberType = expr.getType();
        if (aggregator == Ops.AggOps.AVG_AGG) {
            Number sum = CollQueryFunctions.reduce(source, SUM);
            return sum.doubleValue() / (double)source.size();
        }
        if (aggregator == Ops.AggOps.COUNT_AGG) {
            return (long)source.size();
        }
        if (aggregator == Ops.AggOps.COUNT_DISTINCT_AGG) {
            if (!Set.class.isInstance(source)) {
                source = Sets.newHashSet(source);
            }
            return (long)source.size();
        }
        if (aggregator == Ops.AggOps.MAX_AGG) {
            return MathUtils.cast((Number)CollQueryFunctions.reduce(source, MAX), (Class)numberType);
        }
        if (aggregator == Ops.AggOps.MIN_AGG) {
            return MathUtils.cast((Number)CollQueryFunctions.reduce(source, MIN), (Class)numberType);
        }
        if (aggregator == Ops.AggOps.SUM_AGG) {
            return MathUtils.cast((Number)CollQueryFunctions.reduce(source, SUM), (Class)numberType);
        }
        throw new IllegalArgumentException("Unknown operator " + aggregator);
    }

    public static boolean like(String str, String like) {
        StringBuilder pattern = new StringBuilder(like.length() + 4);
        for (int i = 0; i < like.length(); ++i) {
            char ch = like.charAt(i);
            if (ch == '%') {
                pattern.append(".*");
                continue;
            }
            if (ch == '_') {
                pattern.append('.');
                continue;
            }
            if (ch == '.' || ch == '$' || ch == '^') {
                pattern.append('\\');
            }
            pattern.append(ch);
        }
        if (pattern.toString().equals(like)) {
            return str.equals(like);
        }
        return str.matches(pattern.toString());
    }

    public static boolean like(String str, String like, char escape) {
        return CollQueryFunctions.like(str, like);
    }

    public static boolean likeIgnoreCase(String str, String like) {
        StringBuilder pattern = new StringBuilder(like.length() + 4);
        for (int i = 0; i < like.length(); ++i) {
            char ch = like.charAt(i);
            if (ch == '%') {
                pattern.append(".*");
                continue;
            }
            if (ch == '_') {
                pattern.append('.');
                continue;
            }
            if (ch == '.' || ch == '$' || ch == '^') {
                pattern.append('\\');
            }
            pattern.append(ch);
        }
        if (pattern.toString().equals(like)) {
            return str.equalsIgnoreCase(like);
        }
        return Pattern.compile(pattern.toString(), 2).matcher(str).matches();
    }

    public static boolean likeIgnoreCase(String str, String like, char escape) {
        return CollQueryFunctions.likeIgnoreCase(str, like);
    }

    public static <T> T get(Object parent, String f) {
        try {
            Field field = ReflectionUtils.getFieldOrNull(parent.getClass(), (String)f);
            if (field != null) {
                field.setAccessible(true);
                Object rv = field.get(parent);
                return (T)rv;
            }
            throw new IllegalArgumentException("No field " + f + " for " + parent.getClass());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private CollQueryFunctions() {
    }

    private static interface BinaryFunction {
        public Number apply(Number var1, Number var2);
    }
}

