/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.util;

import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailUtil {
    private static JavaMailSenderImpl javaMailSender = new JavaMailSenderImpl();
    private static String from;
    private static String alias;
    private static Environment env;

    public static boolean send(String to, String subject, String content) {
        try {
            if (javaMailSender.getHost() == null) {
                MailUtil.init();
            }
            MimeMessage message = javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(new InternetAddress(from, alias));
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            javaMailSender.send(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (javaMailSender.getHost() == null) {
            JavaMailSenderImpl javaMailSenderImpl = javaMailSender;
            synchronized (javaMailSenderImpl) {
                if (javaMailSender.getHost() == null) {
                    String host = env.getProperty("com.qsyout.sdk.mail.host");
                    String userName = env.getProperty("com.qsyout.sdk.mail.userName");
                    String password = env.getProperty("com.qsyout.sdk.mail.password");
                    String encoding = env.getProperty("com.qsyout.sdk.mail.encoding", "UTF-8");
                    javaMailSender = new JavaMailSenderImpl();
                    javaMailSender.setHost(host);
                    javaMailSender.setUsername(userName);
                    javaMailSender.setPassword(password);
                    javaMailSender.setDefaultEncoding(encoding);
                    from = userName;
                    alias = env.getProperty("com.qsyout.sdk.mail.alias", "qsyout\u8f6f\u4ef6\u5e73\u53f0");
                }
            }
        }
    }

    public static void setEnv(Environment environment) {
        env = environment;
    }
}

