/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.service;

import com.qsyout.sdk.declare.IbatisDao;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.CollectionUtils;

public class AsyncQueryDao
implements DisposableBean {
    ExecutorService executor;
    IbatisDao ibatisDao;

    public AsyncQueryDao(Integer count, IbatisDao ibatisDao) {
        this.executor = Executors.newFixedThreadPool(count);
        this.ibatisDao = ibatisDao;
    }

    public Object excute(List<MutiDataQuery> mutiData) {
        if (CollectionUtils.isEmpty(mutiData)) {
            return null;
        }
        LinkedList fs = new LinkedList();
        mutiData.forEach(data -> fs.add(this.executor.submit(data)));
        LinkedList result = new LinkedList();
        fs.forEach(item -> {
            try {
                result.add(item.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        });
        return result;
    }

    public MutiDataQuery build(String statementName, Object param, boolean flagArray) {
        return new MutiDataQuery(statementName, param, flagArray);
    }

    public void destroy() throws Exception {
        try {
            this.executor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class MutiDataQuery
    implements Callable {
        private String statementName;
        private Object param;
        private boolean flagArray;

        public MutiDataQuery(String statementName, Object param, boolean flagArray) {
            this.statementName = statementName;
            this.param = param;
            this.flagArray = flagArray;
        }

        public Object call() throws Exception {
            if (this.flagArray) {
                return AsyncQueryDao.this.ibatisDao.queryForList(this.statementName, this.param);
            }
            return AsyncQueryDao.this.ibatisDao.load(this.statementName, this.param);
        }
    }
}

