/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.intercept;

import com.qsyout.sdk.annotation.Api;
import com.qsyout.sdk.declare.AuthInterceptor;
import com.qsyout.sdk.declare.BaseException;
import com.qsyout.sdk.ex.ForbiddenException;
import com.qsyout.sdk.intercept.LogRecord;
import com.qsyout.sdk.util.MailUtil;
import com.qsyout.sdk.util.StringUtil;
import com.qsyout.sdk.util.SubjectUtil;
import com.qsyout.sdk.util.WebUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class WebInterceptor
implements HandlerInterceptor {
    private AuthInterceptor authInterceptor;
    private LogRecord record;
    private boolean dev;
    private String adminMail;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String START_LINE = "**************************START**************************";
    private final String END_LINE = "**************************END**************************";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        SubjectUtil.init(request, response, this.dev);
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        request.getSession().setAttribute("", null);
        MDC.put((String)"sn", (String)StringUtil.uuid());
        this.logger.info("\n");
        this.logger.info("**************************START**************************");
        String url = WebUtil.getPathWithinApplication(request);
        if (url != null && url.indexOf(".") != -1) {
            url = url.substring(0, url.lastIndexOf("."));
        }
        MDC.put((String)"path", (String)url);
        request.setAttribute("start", (Object)System.currentTimeMillis());
        Api api = (Api)((HandlerMethod)handler).getMethodAnnotation(Api.class);
        if (api != null) {
            this.logger.info("The request name is \uff1a{}", (Object)api.desc());
        }
        if (api == null || api.open()) {
            this.logger.info("The request is open.");
            return true;
        }
        if (this.dev && this.authInterceptor != null) {
            this.authInterceptor.setDevPerssion();
        }
        if (!(SubjectUtil.isLogin() || this.dev || this.authInterceptor != null && this.authInterceptor.login(request.getCookies()))) {
            this.logger.info("The request[{}] is not open and the current user is not login or the session is invalid.", (Object)api.desc());
            if (this.authInterceptor != null) {
                response.sendRedirect(String.valueOf(request.getContextPath()) + "/" + this.authInterceptor.loginUrl());
            }
            return false;
        }
        if (!(this.dev || this.authInterceptor == null || "".equals(api.permission().trim()) || this.authInterceptor.handle(api.permission()))) {
            throw new ForbiddenException(String.format("%s is forbidden for the current user", api.desc()));
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (handler instanceof HandlerMethod) {
            long start = (Long)request.getAttribute("start");
            long end = System.currentTimeMillis();
            if (this.record != null) {
                this.record.record(request, (HandlerMethod)handler, ex, end - start);
            }
            if (!this.dev && ex != null) {
                StackTraceElement[] traces;
                StringBuilder stack = new StringBuilder(ex.getMessage());
                StackTraceElement[] stackTraceElementArray = traces = ex.getStackTrace();
                int n = traces.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement trace = stackTraceElementArray[n2];
                    stack.append("\n\t");
                    stack.append("at ");
                    stack.append(trace.getClassName());
                    stack.append(".");
                    stack.append(trace.getMethodName());
                    stack.append("(");
                    stack.append(trace.getFileName());
                    stack.append(":");
                    stack.append(trace.getLineNumber());
                    stack.append(")");
                    ++n2;
                }
                this.logger.error(stack.toString());
                if (!this.dev && this.adminMail != null && !(ex instanceof BaseException)) {
                    StringBuilder content = new StringBuilder("\u7cfb\u7edf\u9519\u8bef\uff1a");
                    content.append(ex.getMessage());
                    content.append("<br/>");
                    StackTraceElement[] stackTraceElementArray2 = traces;
                    int n3 = traces.length;
                    n = 0;
                    while (n < n3) {
                        StackTraceElement trace = stackTraceElementArray2[n];
                        content.append("&nbsp;&nbsp;");
                        content.append("at ");
                        content.append(trace.getClassName());
                        content.append(".");
                        content.append(trace.getMethodName());
                        content.append("(");
                        content.append(trace.getFileName());
                        content.append(":");
                        content.append(trace.getLineNumber());
                        content.append(")");
                        content.append("<br/>");
                        ++n;
                    }
                    content.append("\u6b64\u90ae\u4ef6\u4e3a\u7cfb\u7edf\u90ae\u4ef6,\u8bf7\u52ff\u56de\u590d!<br/>");
                    content.append("\u5982\u9700\u6280\u672f\u652f\u6301\uff0c\u8bf7\u53d1\u9001\u90ae\u4ef6\u81f32375276632@qq.com!<br/>");
                    MailUtil.send(this.adminMail, String.format("\u7ebf\u4e0a\u670d\u52a1\u9519\u8bef[%s]", request.getServerName()), content.toString());
                }
            }
            this.logger.info("The request taked {} millisecond", (Object)(end - start));
            this.logger.info("The maxMemory of java virtual machine is {}M", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
            this.logger.info("The usedMemory of java virtual machine is {}M", (Object)(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
            this.logger.info("**************************END**************************");
        }
    }

    public void setAuthInterceptor(AuthInterceptor authInterceptor) {
        this.authInterceptor = authInterceptor;
    }

    public void setDev(boolean dev) {
        this.dev = dev;
    }

    public void setRecord(LogRecord record) {
        this.record = record;
    }

    public void setAdminMail(String adminMail) {
        this.adminMail = adminMail;
    }
}

