/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SubjectUtil {
    private static ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> response = new ThreadLocal();
    private static final String RESPONSE_MESSAGE = "responseMessage";
    private static final String LOGIN_MARKED = "loginMarked";
    private static boolean dev;

    public static void init(HttpServletRequest r, HttpServletResponse q, boolean devMode) {
        request.set(r);
        response.set(q);
        dev = devMode;
    }

    public static boolean isDevMode() {
        return dev;
    }

    public static boolean isLogin() {
        return SubjectUtil.getSession(LOGIN_MARKED) != null;
    }

    public static void login() {
        SubjectUtil.setSession(LOGIN_MARKED, true);
    }

    public static void logout() {
        request.get().getSession().removeAttribute(LOGIN_MARKED);
    }

    public static void setSession(String key, Object value) {
        request.get().getSession().setAttribute(key, value);
    }

    public static Object getSession(String key) {
        return request.get().getSession().getAttribute(key);
    }

    public static void setAttribute(String key, Object value) {
        request.get().setAttribute(key, value);
    }

    public static Object getAttribute(String key) {
        return request.get().getAttribute(key);
    }

    public static void setCookie(Cookie cookie) {
        response.get().addCookie(cookie);
    }

    public static void message(String message) {
        SubjectUtil.setAttribute(RESPONSE_MESSAGE, message);
    }

    public static String message() {
        return (String)SubjectUtil.getAttribute(RESPONSE_MESSAGE);
    }

    public static void removeAttribute(String key) {
        request.get().removeAttribute(key);
    }

    public static void removeSession(String key) {
        request.get().getSession().removeAttribute(key);
    }

    public static HttpServletRequest getRequest() {
        return request.get();
    }

    public static HttpServletResponse getRespone() {
        return response.get();
    }
}

