/*
 * Decompiled with CFR 0.152.
 */
package com.qsyout.sdk.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;

public class StringUtil {
    private static final char[] codeSequences = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] charSequences = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] allChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String randomInt(int length) {
        StringBuffer randomCode = new StringBuffer(length);
        Random random = new Random();
        int i = 0;
        while (i < length) {
            String strRand = String.valueOf(codeSequences[random.nextInt(10)]);
            randomCode.append(strRand);
            ++i;
        }
        return randomCode.toString();
    }

    public static String randomString(int length) {
        StringBuffer randomCode = new StringBuffer(length);
        Random random = new Random();
        int i = 0;
        while (i < length) {
            String strRand = String.valueOf(charSequences[random.nextInt(20)]);
            randomCode.append(strRand);
            ++i;
        }
        return randomCode.toString();
    }

    public static String random(int length) {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            sb.append(allChar[random.nextInt(allChar.length)]);
            ++i;
        }
        return sb.toString();
    }

    public static String createTransSeq() {
        String random = StringUtil.randomInt(8);
        return String.format("%d%s", System.currentTimeMillis(), random);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean match(String val, String regex) {
        try {
            return Pattern.compile(regex).matcher(val).matches();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String repeatString(String src, int repeats) {
        if (src == null || repeats <= 0) {
            return src;
        }
        StringBuffer bf = new StringBuffer();
        int i = 0;
        while (i < repeats) {
            bf.append(src);
            ++i;
        }
        return bf.toString();
    }

    public static String lpadString(String src, int length, String single) {
        if (src == null || length <= src.getBytes().length) {
            return src;
        }
        return String.valueOf(StringUtil.repeatString(single, length - src.getBytes().length)) + src;
    }

    public static String lpadString(String src, int length) {
        return StringUtil.lpadString(src, length, " ");
    }

    public static String rpadString(String src, int byteLength) {
        return StringUtil.rpadString(src, byteLength, " ");
    }

    public static String rpadString(String src, int length, String single) {
        if (src == null || length <= src.getBytes().length) {
            return src;
        }
        return String.valueOf(src) + StringUtil.repeatString(single, length - src.getBytes().length);
    }

    public static String decimal(String value) {
        if (value == null || "".equals(value.trim())) {
            return "0";
        }
        return value.replaceAll(",", "");
    }

    public static int indexOf(String[] params, String name, boolean ignoreCase) {
        if (params == null) {
            return -1;
        }
        int i = 0;
        int j = params.length;
        while (i < j) {
            if (ignoreCase && params[i].equalsIgnoreCase(name)) {
                return i;
            }
            if (params[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Map gerneryParams(String params) {
        HashMap<String, String> args = new HashMap<String, String>();
        if (!StringUtil.isBlank(params)) {
            try {
                StringTokenizer st = new StringTokenizer(params, "&");
                while (st.hasMoreTokens()) {
                    String map = st.nextToken();
                    if (!StringUtil.isBlank(map.trim())) {
                        String key;
                        StringTokenizer stMap = new StringTokenizer(map, "=");
                        String string = key = stMap.hasMoreTokens() ? stMap.nextToken() : "";
                        if (StringUtil.isBlank(key.trim())) continue;
                        String value = stMap.hasMoreTokens() ? stMap.nextToken() : "";
                        args.put(key, value);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return args;
    }

    public static String getFileExtName(String fileName) {
        String ext = "";
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex > 0) {
            ext = fileName.substring(lastIndex);
        }
        return ext;
    }

    public static boolean isFloat(String s) {
        return s.matches("[0-9\\.]+");
    }

    public static boolean isNumber(String s) {
        return s.matches("[0-9]+");
    }

    public static boolean isMonth(String s) {
        return s.matches("[1-9]?|1[12]?");
    }

    public static boolean isDay(String s) {
        return s.matches("[1-9]?|[12][\\d]?|3[01]");
    }

    public static boolean isHour(String s) {
        return s.matches("[0-9]|1[0-9]|2[0-3]");
    }

    public static boolean checkEmail(String email) {
        return Pattern.compile("^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$").matcher(email).matches();
    }

    public static boolean checkIdCardNo(String idCardNo) {
        return Pattern.compile("^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$|^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$").matcher(idCardNo).matches();
    }

    public static boolean checkPhone(String phone) {
        return Pattern.compile("^(1[3-9][0-9])\\d{8}$").matcher(phone).matches();
    }

    public static boolean checkIpv4(String ip) {
        return Pattern.compile("^((\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])$").matcher(ip).matches();
    }
}

