/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.webview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.core.view.WindowInsetsCompat;
import com.qmuiteam.qmui.layout.QMUIFrameLayout;
import com.qmuiteam.qmui.util.QMUIWindowInsetHelper;
import com.qmuiteam.qmui.widget.webview.QMUIWebView;

public class QMUIWebViewContainer
extends QMUIFrameLayout {
    private QMUIWebView mWebView;
    private QMUIWebView.OnScrollChangeListener mOnScrollChangeListener;

    public QMUIWebViewContainer(Context context) {
        super(context);
    }

    public QMUIWebViewContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void addWebView(@NonNull QMUIWebView webView, boolean needDispatchSafeAreaInset) {
        this.mWebView = webView;
        this.mWebView.setNeedDispatchSafeAreaInset(needDispatchSafeAreaInset);
        this.mWebView.addCustomOnScrollChangeListener(new QMUIWebView.OnScrollChangeListener(){

            @Override
            public void onScrollChange(WebView webView, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                if (QMUIWebViewContainer.this.mOnScrollChangeListener != null) {
                    QMUIWebViewContainer.this.mOnScrollChangeListener.onScrollChange(webView, scrollX, scrollY, oldScrollX, oldScrollY);
                }
            }
        });
        this.addView((View)this.mWebView, (ViewGroup.LayoutParams)this.getWebViewLayoutParams());
        QMUIWindowInsetHelper.handleWindowInsets((View)this, WindowInsetsCompat.Type.statusBars() | WindowInsetsCompat.Type.displayCutout());
    }

    protected FrameLayout.LayoutParams getWebViewLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    public void setNeedDispatchSafeAreaInset(boolean needDispatchSafeAreaInset) {
        if (this.mWebView != null) {
            this.mWebView.setNeedDispatchSafeAreaInset(needDispatchSafeAreaInset);
        }
    }

    public void destroy() {
        this.removeView((View)this.mWebView);
        this.removeAllViews();
        this.mWebView.setWebChromeClient(null);
        this.mWebView.setWebViewClient(null);
        this.mWebView.destroy();
    }

    public void setCustomOnScrollChangeListener(QMUIWebView.OnScrollChangeListener onScrollChangeListener) {
        this.mOnScrollChangeListener = onScrollChangeListener;
    }
}

