/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.tab;

import android.graphics.Typeface;
import android.view.View;
import androidx.annotation.NonNull;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.widget.tab.QMUITabIcon;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class QMUITab {
    public static final int ICON_POSITION_LEFT = 0;
    public static final int ICON_POSITION_TOP = 1;
    public static final int ICON_POSITION_RIGHT = 2;
    public static final int ICON_POSITION_BOTTOM = 3;
    public static final int SIGN_COUNT_VERTICAL_ALIGN_BOTTOM_TO_CONTENT_TOP = 0;
    public static final int SIGN_COUNT_VERTICAL_ALIGN_TOP_TO_CONTENT_TOP = 1;
    public static final int SIGN_COUNT_VERTICAL_ALIGN_MIDDLE_TO_CONTENT = 2;
    public static final int NO_SIGN_COUNT_AND_RED_POINT = 0;
    public static final int RED_POINT_SIGN_COUNT = -1;
    boolean allowIconDrawOutside;
    int iconTextGap;
    int normalTextSize;
    int selectedTextSize;
    Typeface normalTypeface;
    Typeface selectedTypeface;
    float typefaceUpdateAreaPercent;
    int normalColor;
    int selectColor;
    int normalColorAttr;
    int selectedColorAttr;
    int normalTabIconWidth = -1;
    int normalTabIconHeight = -1;
    float selectedTabIconScale = 1.0f;
    QMUITabIcon tabIcon = null;
    boolean skinChangeWithTintColor;
    boolean skinChangeNormalWithTintColor;
    boolean skinChangeSelectedWithTintColor;
    int normalIconAttr;
    int selectedIconAttr;
    int contentWidth = 0;
    int contentLeft = 0;
    int iconPosition = 1;
    int gravity = 17;
    private CharSequence text;
    int signCountDigits = 2;
    int signCountHorizontalOffset = 0;
    int signCountVerticalOffset = 0;
    int signCountVerticalAlign = 0;
    int signCount = 0;
    float rightSpaceWeight = 0.0f;
    float leftSpaceWeight = 0.0f;
    int leftAddonMargin = 0;
    int rightAddonMargin = 0;

    QMUITab(CharSequence text) {
        this.text = text;
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence text) {
        this.text = text;
    }

    public int getIconPosition() {
        return this.iconPosition;
    }

    public void setIconPosition(int iconPosition) {
        this.iconPosition = iconPosition;
    }

    public void setSpaceWeight(float leftWeight, float rightWeight) {
        this.leftSpaceWeight = leftWeight;
        this.rightSpaceWeight = rightWeight;
    }

    public void setTypefaceUpdateAreaPercent(float typefaceUpdateAreaPercent) {
        this.typefaceUpdateAreaPercent = typefaceUpdateAreaPercent;
    }

    public float getTypefaceUpdateAreaPercent() {
        return this.typefaceUpdateAreaPercent;
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
    }

    public void setSignCount(int signCount) {
        this.signCount = signCount;
    }

    public void setRedPoint() {
        this.signCount = -1;
    }

    public int getSignCount() {
        return this.signCount;
    }

    public boolean isRedPointShowing() {
        return this.signCount == -1;
    }

    public void clearSignCountOrRedPoint() {
        this.signCount = 0;
    }

    public int getNormalColor(@NonNull View skinFollowView) {
        if (this.normalColorAttr == 0) {
            return this.normalColor;
        }
        return QMUISkinHelper.getSkinColor(skinFollowView, this.normalColorAttr);
    }

    public int getSelectColor(@NonNull View skinFollowView) {
        if (this.selectedColorAttr == 0) {
            return this.selectColor;
        }
        return QMUISkinHelper.getSkinColor(skinFollowView, this.selectedColorAttr);
    }

    public int getNormalColorAttr() {
        return this.normalColorAttr;
    }

    public int getSelectedColorAttr() {
        return this.selectedColorAttr;
    }

    public int getNormalIconAttr() {
        return this.normalIconAttr;
    }

    public int getSelectedIconAttr() {
        return this.selectedIconAttr;
    }

    public int getNormalTextSize() {
        return this.normalTextSize;
    }

    public int getSelectedTextSize() {
        return this.selectedTextSize;
    }

    public QMUITabIcon getTabIcon() {
        return this.tabIcon;
    }

    public Typeface getNormalTypeface() {
        return this.normalTypeface;
    }

    public Typeface getSelectedTypeface() {
        return this.selectedTypeface;
    }

    public int getNormalTabIconWidth() {
        if (this.normalTabIconWidth == -1 && this.tabIcon != null) {
            return this.tabIcon.getIntrinsicWidth();
        }
        return this.normalTabIconWidth;
    }

    public int getNormalTabIconHeight() {
        if (this.normalTabIconHeight == -1 && this.tabIcon != null) {
            return this.tabIcon.getIntrinsicWidth();
        }
        return this.normalTabIconHeight;
    }

    public float getSelectedTabIconScale() {
        return this.selectedTabIconScale;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public boolean isAllowIconDrawOutside() {
        return this.allowIconDrawOutside;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconPosition {
    }
}

