/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.tab;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.qmuiteam.qmui.QMUIInterpolatorStaticHolder;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.IQMUILayout;
import com.qmuiteam.qmui.layout.QMUILayoutHelper;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerView;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.skin.defaultAttr.IQMUISkinDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIColorHelper;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabAdapter;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabIndicator;
import com.qmuiteam.qmui.widget.tab.QMUITabView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QMUIBasicTabSegment
extends HorizontalScrollView
implements IQMUILayout,
IQMUISkinHandlerView,
IQMUISkinDefaultAttrProvider {
    private static final String TAG = "QMUIBasicTabSegment";
    public static final int MODE_SCROLLABLE = 0;
    public static final int MODE_FIXED = 1;
    public static final int NO_POSITION = -1;
    private final ArrayList<OnTabSelectedListener> mSelectedListeners = new ArrayList();
    private Container mContentLayout;
    protected int mCurrentSelectedIndex = -1;
    protected int mPendingSelectedIndex = -1;
    private QMUITabIndicator mIndicator = null;
    private boolean mHideIndicatorWhenTabCountLessTwo = true;
    private int mMode = 1;
    private int mItemSpaceInScrollMode;
    private QMUITabAdapter mTabAdapter;
    protected QMUITabBuilder mTabBuilder;
    private boolean mSelectNoAnimation;
    protected Animator mSelectAnimator;
    private OnTabClickListener mOnTabClickListener;
    private boolean mIsInSelectTab = false;
    private QMUILayoutHelper mLayoutHelper;
    private static SimpleArrayMap<String, Integer> sDefaultSkinAttrs = new SimpleArrayMap(3);

    public QMUIBasicTabSegment(Context context) {
        this(context, null);
    }

    public QMUIBasicTabSegment(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUITabSegmentStyle);
    }

    public QMUIBasicTabSegment(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.mLayoutHelper = new QMUILayoutHelper(context, attrs, defStyleAttr, (View)this);
        this.init(context, attrs, defStyleAttr);
        this.setHorizontalScrollBarEnabled(false);
        this.setClipToPadding(false);
        this.setClipChildren(false);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUITabSegment, defStyleAttr, 0);
        boolean hasIndicator = array.getBoolean(R.styleable.QMUITabSegment_qmui_tab_has_indicator, false);
        int indicatorHeight = array.getDimensionPixelSize(R.styleable.QMUITabSegment_qmui_tab_indicator_height, this.getResources().getDimensionPixelSize(R.dimen.qmui_tab_segment_indicator_height));
        boolean indicatorTop = array.getBoolean(R.styleable.QMUITabSegment_qmui_tab_indicator_top, false);
        boolean indicatorWidthFollowContent = array.getBoolean(R.styleable.QMUITabSegment_qmui_tab_indicator_with_follow_content, false);
        this.mIndicator = this.createTabIndicatorFromXmlInfo(hasIndicator, indicatorHeight, indicatorTop, indicatorWidthFollowContent);
        int normalTextSize = array.getDimensionPixelSize(R.styleable.QMUITabSegment_android_textSize, this.getResources().getDimensionPixelSize(R.dimen.qmui_tab_segment_text_size));
        int selectedTextSize = normalTextSize = array.getDimensionPixelSize(R.styleable.QMUITabSegment_qmui_tab_normal_text_size, normalTextSize);
        selectedTextSize = array.getDimensionPixelSize(R.styleable.QMUITabSegment_qmui_tab_selected_text_size, selectedTextSize);
        this.mTabBuilder = new QMUITabBuilder(context).setTextSize(normalTextSize, selectedTextSize).setIconPosition(array.getInt(R.styleable.QMUITabSegment_qmui_tab_icon_position, 0));
        this.mMode = array.getInt(R.styleable.QMUITabSegment_qmui_tab_mode, 1);
        this.mItemSpaceInScrollMode = array.getDimensionPixelSize(R.styleable.QMUITabSegment_qmui_tab_space, QMUIDisplayHelper.dp2px(context, 10));
        this.mSelectNoAnimation = array.getBoolean(R.styleable.QMUITabSegment_qmui_tab_select_no_animation, false);
        array.recycle();
        this.mContentLayout = new Container(context);
        this.addView((View)this.mContentLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        this.mTabAdapter = this.createTabAdapter(this.mContentLayout);
    }

    public void setDefaultTextSize(int normalTextSize, int selectedTextSize) {
        this.mTabBuilder.setTextSize(normalTextSize, selectedTextSize);
    }

    public void setDefaultTabIconPosition(int iconPosition) {
        this.mTabBuilder.setIconPosition(iconPosition);
    }

    public void updateParentTabBuilder(TabBuilderUpdater updater) {
        updater.update(this.mTabBuilder);
    }

    protected QMUITabAdapter createTabAdapter(ViewGroup tabParentView) {
        return new QMUITabAdapter(this, tabParentView);
    }

    protected QMUITabIndicator createTabIndicatorFromXmlInfo(boolean hasIndicator, int indicatorHeight, boolean indicatorTop, boolean indicatorWidthFollowContent) {
        if (!hasIndicator) {
            return null;
        }
        return new QMUITabIndicator(indicatorHeight, indicatorTop, indicatorWidthFollowContent);
    }

    public QMUITabBuilder tabBuilder() {
        return new QMUITabBuilder(this.mTabBuilder);
    }

    public void setIndicator(@Nullable QMUITabIndicator indicator) {
        this.mIndicator = indicator;
        this.mContentLayout.requestLayout();
    }

    public void setHideIndicatorWhenTabCountLessTwo(boolean hideIndicatorWhenTabCountLessTwo) {
        this.mHideIndicatorWhenTabCountLessTwo = hideIndicatorWhenTabCountLessTwo;
    }

    public void setItemSpaceInScrollMode(int itemSpaceInScrollMode) {
        this.mItemSpaceInScrollMode = itemSpaceInScrollMode;
    }

    public void reset() {
        this.mTabAdapter.clear();
        this.mCurrentSelectedIndex = -1;
        if (this.mSelectAnimator != null) {
            this.mSelectAnimator.cancel();
            this.mSelectAnimator = null;
        }
    }

    public void resetSelect() {
        this.mCurrentSelectedIndex = -1;
        if (this.mSelectAnimator != null) {
            this.mSelectAnimator.cancel();
            this.mSelectAnimator = null;
        }
    }

    public QMUIBasicTabSegment addTab(QMUITab tab) {
        this.mTabAdapter.addItem(tab);
        return this;
    }

    public void notifyDataChanged() {
        int current = this.mCurrentSelectedIndex;
        this.resetSelect();
        this.mTabAdapter.setup();
        this.selectTab(current);
    }

    public void addOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        if (!this.mSelectedListeners.contains(listener)) {
            this.mSelectedListeners.add(listener);
        }
    }

    public void removeOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        this.mSelectedListeners.remove(listener);
    }

    public void clearOnTabSelectedListeners() {
        this.mSelectedListeners.clear();
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int mode) {
        if (this.mMode != mode) {
            this.mMode = mode;
            if (mode == 0) {
                this.mTabBuilder.setGravity(3);
            }
            this.mContentLayout.invalidate();
        }
    }

    protected void onClickTab(QMUITabView view, int index) {
        if (this.mSelectAnimator != null || this.needPreventEvent()) {
            return;
        }
        if (this.mOnTabClickListener != null && this.mOnTabClickListener.onTabClick(view, index)) {
            return;
        }
        QMUITab model = (QMUITab)this.mTabAdapter.getItem(index);
        if (model != null) {
            this.selectTab(index, this.mSelectNoAnimation, true);
        }
    }

    protected boolean needPreventEvent() {
        return false;
    }

    void onDoubleClick(int index) {
        if (this.mSelectedListeners.isEmpty()) {
            return;
        }
        QMUITab model = (QMUITab)this.mTabAdapter.getItem(index);
        if (model != null) {
            this.dispatchTabDoubleTap(index);
        }
    }

    private void dispatchTabSelected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabSelected(index);
        }
    }

    private void dispatchTabUnselected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabUnselected(index);
        }
    }

    private void dispatchTabReselected(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabReselected(index);
        }
    }

    private void dispatchTabDoubleTap(int index) {
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onDoubleTap(index);
        }
    }

    public void setSelectNoAnimation(boolean noAnimation) {
        this.mSelectNoAnimation = noAnimation;
    }

    public void selectTab(int index) {
        this.selectTab(index, this.mSelectNoAnimation, false);
    }

    public void selectTab(final int index, boolean noAnimation, boolean fromTabClick) {
        if (this.mIsInSelectTab) {
            return;
        }
        this.mIsInSelectTab = true;
        List listViews = this.mTabAdapter.getViews();
        if (listViews.size() != this.mTabAdapter.getSize()) {
            this.mTabAdapter.setup();
            listViews = this.mTabAdapter.getViews();
        }
        if (listViews.size() == 0 || listViews.size() <= index) {
            this.mIsInSelectTab = false;
            return;
        }
        if (this.mSelectAnimator != null || this.needPreventEvent()) {
            this.mPendingSelectedIndex = index;
            this.mIsInSelectTab = false;
            return;
        }
        if (this.mCurrentSelectedIndex == index) {
            if (fromTabClick) {
                this.dispatchTabReselected(index);
            }
            this.mIsInSelectTab = false;
            this.mContentLayout.invalidate();
            return;
        }
        if (this.mCurrentSelectedIndex > listViews.size()) {
            Log.i((String)TAG, (String)"selectTab: current selected index is bigger than views size.");
            this.mCurrentSelectedIndex = -1;
        }
        if (this.mCurrentSelectedIndex == -1) {
            QMUITab model = (QMUITab)this.mTabAdapter.getItem(index);
            this.layoutIndicator(model, true);
            QMUITabView tabView = (QMUITabView)listViews.get(index);
            tabView.setSelected(true);
            tabView.setSelectFraction(1.0f);
            this.dispatchTabSelected(index);
            this.mCurrentSelectedIndex = index;
            this.mIsInSelectTab = false;
            return;
        }
        final int prev = this.mCurrentSelectedIndex;
        final QMUITab prevModel = (QMUITab)this.mTabAdapter.getItem(prev);
        final QMUITabView prevView = (QMUITabView)listViews.get(prev);
        final QMUITab nowModel = (QMUITab)this.mTabAdapter.getItem(index);
        final QMUITabView nowView = (QMUITabView)listViews.get(index);
        if (noAnimation) {
            this.dispatchTabUnselected(prev);
            this.dispatchTabSelected(index);
            prevView.setSelectFraction(0.0f);
            prevView.setSelected(false);
            nowView.setSelectFraction(1.0f);
            nowView.setSelected(true);
            if (this.mMode == 0) {
                int scrollX = this.getScrollX();
                int w = this.getWidth();
                int cw = this.mContentLayout.getWidth();
                int nl = nowView.getLeft();
                int nw = nowView.getWidth();
                int paddingHor = this.getPaddingLeft() + this.getPaddingRight();
                int size = this.mTabAdapter.getSize();
                int maxScrollX = cw - w + paddingHor;
                if (index > prev) {
                    if (index >= size - 2) {
                        this.smoothScrollBy(maxScrollX - scrollX, 0);
                    } else {
                        int nextWidth = ((QMUITabView)listViews.get(index + 1)).getWidth();
                        int targetScrollX = Math.min(maxScrollX, nl - (w - this.getPaddingRight() * 2 - nextWidth - nw - this.mItemSpaceInScrollMode));
                        if (scrollX < (targetScrollX -= nextWidth - nw)) {
                            this.smoothScrollBy(targetScrollX - scrollX, 0);
                        }
                    }
                } else if (index <= 1) {
                    this.smoothScrollBy(-scrollX, 0);
                } else {
                    int prevWidth = ((QMUITabView)listViews.get(index - 1)).getWidth();
                    int targetScrollX = Math.max(0, nl - prevWidth - this.mItemSpaceInScrollMode);
                    if (targetScrollX < scrollX) {
                        this.smoothScrollBy(targetScrollX - scrollX, 0);
                    }
                }
            }
            this.mCurrentSelectedIndex = index;
            this.mIsInSelectTab = false;
            this.layoutIndicator(nowModel, true);
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setInterpolator((TimeInterpolator)QMUIInterpolatorStaticHolder.LINEAR_INTERPOLATOR);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animValue = ((Float)animation.getAnimatedValue()).floatValue();
                prevView.setSelectFraction(1.0f - animValue);
                nowView.setSelectFraction(animValue);
                QMUIBasicTabSegment.this.layoutIndicatorInTransition(prevModel, nowModel, animValue);
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                QMUIBasicTabSegment.this.mSelectAnimator = animation;
            }

            public void onAnimationEnd(Animator animation) {
                prevView.setSelectFraction(0.0f);
                prevView.setSelected(false);
                nowView.setSelectFraction(1.0f);
                nowView.setSelected(true);
                QMUIBasicTabSegment.this.mSelectAnimator = null;
                QMUIBasicTabSegment.this.mCurrentSelectedIndex = index;
                QMUIBasicTabSegment.this.dispatchTabSelected(index);
                QMUIBasicTabSegment.this.dispatchTabUnselected(prev);
                if (QMUIBasicTabSegment.this.mPendingSelectedIndex != -1 && !QMUIBasicTabSegment.this.needPreventEvent()) {
                    QMUIBasicTabSegment.this.selectTab(QMUIBasicTabSegment.this.mPendingSelectedIndex, true, false);
                    QMUIBasicTabSegment.this.mPendingSelectedIndex = -1;
                }
            }

            public void onAnimationCancel(Animator animation) {
                QMUIBasicTabSegment.this.mSelectAnimator = null;
                prevView.setSelectFraction(1.0f);
                prevView.setSelected(true);
                nowView.setSelectFraction(0.0f);
                nowView.setSelected(false);
                QMUIBasicTabSegment.this.layoutIndicator(prevModel, true);
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.setDuration(200L);
        animator.start();
        this.mIsInSelectTab = false;
    }

    private void layoutIndicator(QMUITab model, boolean invalidate) {
        if (model == null || this.mIndicator == null) {
            return;
        }
        this.mIndicator.updateInfo(model.contentLeft, model.contentWidth, model.selectedColorAttr == 0 ? model.selectColor : QMUISkinHelper.getSkinColor((View)this, model.selectedColorAttr), 0.0f);
        if (invalidate) {
            this.mContentLayout.invalidate();
        }
    }

    private void layoutIndicatorInTransition(QMUITab preModel, QMUITab targetModel, float offsetPercent) {
        if (this.mIndicator == null) {
            return;
        }
        int leftDistance = targetModel.contentLeft - preModel.contentLeft;
        int widthDistance = targetModel.contentWidth - preModel.contentWidth;
        int targetLeft = (int)((float)preModel.contentLeft + (float)leftDistance * offsetPercent);
        int targetWidth = (int)((float)preModel.contentWidth + (float)widthDistance * offsetPercent);
        int indicatorColor = QMUIColorHelper.computeColor(preModel.selectedColorAttr == 0 ? preModel.selectColor : QMUISkinHelper.getSkinColor((View)this, preModel.selectedColorAttr), targetModel.selectedColorAttr == 0 ? targetModel.selectColor : QMUISkinHelper.getSkinColor((View)this, targetModel.selectedColorAttr), offsetPercent);
        this.mIndicator.updateInfo(targetLeft, targetWidth, indicatorColor, offsetPercent);
        this.mContentLayout.invalidate();
    }

    public void updateIndicatorPosition(int index, float offsetPercent) {
        int targetIndex;
        if (this.mSelectAnimator != null || this.mIsInSelectTab || offsetPercent == 0.0f) {
            return;
        }
        if (offsetPercent < 0.0f) {
            targetIndex = index - 1;
            offsetPercent = -offsetPercent;
        } else {
            targetIndex = index + 1;
        }
        List listViews = this.mTabAdapter.getViews();
        if (listViews.size() <= index || listViews.size() <= targetIndex) {
            return;
        }
        QMUITab preModel = (QMUITab)this.mTabAdapter.getItem(index);
        QMUITab targetModel = (QMUITab)this.mTabAdapter.getItem(targetIndex);
        QMUITabView preView = (QMUITabView)listViews.get(index);
        QMUITabView targetView = (QMUITabView)listViews.get(targetIndex);
        preView.setSelectFraction(1.0f - offsetPercent);
        targetView.setSelectFraction(offsetPercent);
        this.layoutIndicatorInTransition(preModel, targetModel, offsetPercent);
    }

    public void updateTabText(int index, String text) {
        QMUITab model = (QMUITab)this.mTabAdapter.getItem(index);
        if (model == null) {
            return;
        }
        model.setText(text);
        this.notifyDataChanged();
    }

    public void replaceTab(int index, QMUITab model) {
        try {
            if (this.mCurrentSelectedIndex == index) {
                this.mCurrentSelectedIndex = -1;
            }
            this.mTabAdapter.replaceItem(index, model);
            this.notifyDataChanged();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setOnTabClickListener(OnTabClickListener onTabClickListener) {
        this.mOnTabClickListener = onTabClickListener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            int paddingHor = this.getPaddingLeft() + this.getPaddingRight();
            child.measure(View.MeasureSpec.makeMeasureSpec((int)(widthSize - paddingHor), (int)0x40000000), heightMeasureSpec);
            if (widthMode == Integer.MIN_VALUE) {
                this.setMeasuredDimension(Math.min(widthSize, child.getMeasuredWidth() + paddingHor), heightMeasureSpec);
                return;
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    public int getSelectedIndex() {
        return this.mCurrentSelectedIndex;
    }

    public int getTabCount() {
        return this.mTabAdapter.getSize();
    }

    public QMUITab getTab(int index) {
        return (QMUITab)this.mTabAdapter.getItem(index);
    }

    public void showSignCountView(Context context, int index, int count) {
        QMUITab tab = (QMUITab)this.mTabAdapter.getItem(index);
        tab.setSignCount(count);
        this.notifyDataChanged();
    }

    public void clearSignCountView(int index) {
        QMUITab tab = (QMUITab)this.mTabAdapter.getItem(index);
        tab.clearSignCountOrRedPoint();
        this.notifyDataChanged();
    }

    public int getSignCount(int index) {
        QMUITab tab = (QMUITab)this.mTabAdapter.getItem(index);
        return tab.getSignCount();
    }

    public boolean isRedPointShowing(int index) {
        return ((QMUITab)this.mTabAdapter.getItem(index)).isRedPointShowing();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mCurrentSelectedIndex != -1 && this.mMode == 0) {
            QMUITabView view = (QMUITabView)this.mTabAdapter.getViews().get(this.mCurrentSelectedIndex);
            if (this.getScrollX() > view.getLeft()) {
                this.scrollTo(view.getLeft(), 0);
            } else {
                int realWidth = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
                if (this.getScrollX() + realWidth < view.getRight()) {
                    this.scrollBy(view.getRight() - realWidth - this.getScrollX(), 0);
                }
            }
        }
    }

    @Override
    public void updateTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mLayoutHelper.updateTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.invalidate();
    }

    @Override
    public void updateBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mLayoutHelper.updateBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.invalidate();
    }

    @Override
    public void updateLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLayoutHelper.updateLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.invalidate();
    }

    @Override
    public void updateRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mLayoutHelper.updateRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mLayoutHelper.onlyShowTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mLayoutHelper.onlyShowBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLayoutHelper.onlyShowLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mLayoutHelper.onlyShowRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.invalidate();
    }

    @Override
    public void setTopDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setTopDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setBottomDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setBottomDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setLeftDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setLeftDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setRightDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setRightDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setRadiusAndShadow(int radius, int shadowElevation, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, int shadowColor, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, shadowColor, shadowAlpha);
    }

    @Override
    public void setRadius(int radius) {
        this.mLayoutHelper.setRadius(radius);
    }

    @Override
    public void setRadius(int radius, int hideRadiusSide) {
        this.mLayoutHelper.setRadius(radius, hideRadiusSide);
    }

    @Override
    public int getRadius() {
        return this.mLayoutHelper.getRadius();
    }

    @Override
    public void setOutlineInset(int left, int top, int right, int bottom) {
        this.mLayoutHelper.setOutlineInset(left, top, right, bottom);
    }

    @Override
    public void setHideRadiusSide(int hideRadiusSide) {
        this.mLayoutHelper.setHideRadiusSide(hideRadiusSide);
    }

    @Override
    public int getHideRadiusSide() {
        return this.mLayoutHelper.getHideRadiusSide();
    }

    @Override
    public void setBorderColor(@ColorInt int borderColor) {
        this.mLayoutHelper.setBorderColor(borderColor);
        this.invalidate();
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.mLayoutHelper.setBorderWidth(borderWidth);
        this.invalidate();
    }

    @Override
    public void setShowBorderOnlyBeforeL(boolean showBorderOnlyBeforeL) {
        this.mLayoutHelper.setShowBorderOnlyBeforeL(showBorderOnlyBeforeL);
        this.invalidate();
    }

    @Override
    public boolean setWidthLimit(int widthLimit) {
        if (this.mLayoutHelper.setWidthLimit(widthLimit)) {
            this.requestLayout();
            this.invalidate();
        }
        return true;
    }

    @Override
    public boolean setHeightLimit(int heightLimit) {
        if (this.mLayoutHelper.setHeightLimit(heightLimit)) {
            this.requestLayout();
            this.invalidate();
        }
        return true;
    }

    @Override
    public void setUseThemeGeneralShadowElevation() {
        this.mLayoutHelper.setUseThemeGeneralShadowElevation();
    }

    @Override
    public void setOutlineExcludePadding(boolean outlineExcludePadding) {
        this.mLayoutHelper.setOutlineExcludePadding(outlineExcludePadding);
    }

    @Override
    public void setShadowElevation(int elevation) {
        this.mLayoutHelper.setShadowElevation(elevation);
    }

    @Override
    public int getShadowElevation() {
        return this.mLayoutHelper.getShadowElevation();
    }

    @Override
    public void setShadowAlpha(float shadowAlpha) {
        this.mLayoutHelper.setShadowAlpha(shadowAlpha);
    }

    @Override
    public float getShadowAlpha() {
        return this.mLayoutHelper.getShadowAlpha();
    }

    @Override
    public void setShadowColor(int shadowColor) {
        this.mLayoutHelper.setShadowColor(shadowColor);
    }

    @Override
    public int getShadowColor() {
        return this.mLayoutHelper.getShadowColor();
    }

    @Override
    public void setOuterNormalColor(int color2) {
        this.mLayoutHelper.setOuterNormalColor(color2);
    }

    @Override
    public void updateBottomSeparatorColor(int color2) {
        this.mLayoutHelper.updateBottomSeparatorColor(color2);
    }

    @Override
    public void updateLeftSeparatorColor(int color2) {
        this.mLayoutHelper.updateLeftSeparatorColor(color2);
    }

    @Override
    public void updateRightSeparatorColor(int color2) {
        this.mLayoutHelper.updateRightSeparatorColor(color2);
    }

    @Override
    public void updateTopSeparatorColor(int color2) {
        this.mLayoutHelper.updateTopSeparatorColor(color2);
    }

    protected void onDraw(Canvas canvas) {
        this.mLayoutHelper.drawDividers(canvas, this.getWidth(), this.getHeight());
        this.mLayoutHelper.dispatchRoundBorderDraw(canvas);
        super.onDraw(canvas);
    }

    @Override
    public SimpleArrayMap<String, Integer> getDefaultSkinAttrs() {
        return sDefaultSkinAttrs;
    }

    @Override
    public void handle(@NotNull QMUISkinManager manager, int skinIndex, @NotNull Resources.Theme theme, @Nullable SimpleArrayMap<String, Integer> attrs) {
        manager.defaultHandleSkinAttrs((View)this, theme, attrs);
        if (this.mIndicator != null) {
            this.mIndicator.handleSkinChange(manager, skinIndex, theme, (QMUITab)this.mTabAdapter.getItem(this.mCurrentSelectedIndex));
            this.mContentLayout.invalidate();
        }
    }

    @Override
    public boolean hasBorder() {
        return this.mLayoutHelper.hasBorder();
    }

    @Override
    public boolean hasLeftSeparator() {
        return this.mLayoutHelper.hasLeftSeparator();
    }

    @Override
    public boolean hasTopSeparator() {
        return this.mLayoutHelper.hasTopSeparator();
    }

    @Override
    public boolean hasRightSeparator() {
        return this.mLayoutHelper.hasRightSeparator();
    }

    @Override
    public boolean hasBottomSeparator() {
        return this.mLayoutHelper.hasBottomSeparator();
    }

    static {
        sDefaultSkinAttrs.put((Object)"bottomSeparator", (Object)R.attr.qmui_skin_support_tab_separator_color);
        sDefaultSkinAttrs.put((Object)"topSeparator", (Object)R.attr.qmui_skin_support_tab_separator_color);
        sDefaultSkinAttrs.put((Object)"background", (Object)R.attr.qmui_skin_support_tab_bg);
    }

    public static interface TabBuilderUpdater {
        public void update(QMUITabBuilder var1);
    }

    private final class Container
    extends ViewGroup {
        public Container(Context context) {
            super(context);
            this.setClipChildren(false);
            this.setWillNotDraw(false);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int i;
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            List childViews = QMUIBasicTabSegment.this.mTabAdapter.getViews();
            int size = childViews.size();
            int visibleChild = 0;
            for (i = 0; i < size; ++i) {
                View child = (View)childViews.get(i);
                if (child.getVisibility() != 0) continue;
                ++visibleChild;
            }
            if (size == 0 || visibleChild == 0) {
                this.setMeasuredDimension(widthSpecSize, heightSpecSize);
                return;
            }
            int childHeight = heightSpecSize - this.getPaddingTop() - this.getPaddingBottom();
            int resultWidthSize = 0;
            if (QMUIBasicTabSegment.this.mMode == 1) {
                resultWidthSize = widthSpecSize;
                int modeFixItemWidth = widthSpecSize / visibleChild;
                for (i = 0; i < size; ++i) {
                    View child = (View)childViews.get(i);
                    if (child.getVisibility() != 0) continue;
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)modeFixItemWidth, (int)0x40000000);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    QMUITab tab = (QMUITab)QMUIBasicTabSegment.this.mTabAdapter.getItem(i);
                    tab.leftAddonMargin = 0;
                    tab.rightAddonMargin = 0;
                }
            } else {
                float totalWeight = 0.0f;
                for (i = 0; i < size; ++i) {
                    View child = (View)childViews.get(i);
                    if (child.getVisibility() != 0) continue;
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSpecSize, (int)Integer.MIN_VALUE);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    resultWidthSize += child.getMeasuredWidth() + QMUIBasicTabSegment.this.mItemSpaceInScrollMode;
                    QMUITab tab = (QMUITab)QMUIBasicTabSegment.this.mTabAdapter.getItem(i);
                    totalWeight += tab.leftSpaceWeight + tab.rightSpaceWeight;
                    tab.leftAddonMargin = 0;
                    tab.rightAddonMargin = 0;
                }
                if (totalWeight > 0.0f && (resultWidthSize -= QMUIBasicTabSegment.this.mItemSpaceInScrollMode) < widthSpecSize) {
                    int remain = widthSpecSize - resultWidthSize;
                    resultWidthSize = widthSpecSize;
                    for (i = 0; i < size; ++i) {
                        View child = (View)childViews.get(i);
                        if (child.getVisibility() != 0) continue;
                        QMUITab tab = (QMUITab)QMUIBasicTabSegment.this.mTabAdapter.getItem(i);
                        tab.leftAddonMargin = (int)((float)remain * tab.leftSpaceWeight / totalWeight);
                        tab.rightAddonMargin = (int)((float)remain * tab.rightSpaceWeight / totalWeight);
                    }
                }
            }
            this.setMeasuredDimension(resultWidthSize, heightSpecSize);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            int i;
            List childViews = QMUIBasicTabSegment.this.mTabAdapter.getViews();
            int size = childViews.size();
            int visibleChild = 0;
            for (i = 0; i < size; ++i) {
                View child = (View)childViews.get(i);
                if (child.getVisibility() != 0) continue;
                ++visibleChild;
            }
            if (size == 0 || visibleChild == 0) {
                return;
            }
            int usedLeft = this.getPaddingLeft();
            for (i = 0; i < size; ++i) {
                int newWidth;
                int newLeft;
                QMUITabView childView = (QMUITabView)childViews.get(i);
                if (childView.getVisibility() != 0) continue;
                int childMeasureWidth = childView.getMeasuredWidth();
                QMUITab model = (QMUITab)QMUIBasicTabSegment.this.mTabAdapter.getItem(i);
                childView.layout(usedLeft += model.leftAddonMargin, this.getPaddingTop(), usedLeft + childMeasureWidth, b - t - this.getPaddingBottom());
                int oldLeft = model.contentLeft;
                int oldWidth = model.contentWidth;
                if (QMUIBasicTabSegment.this.mMode == 1 && QMUIBasicTabSegment.this.mIndicator != null && QMUIBasicTabSegment.this.mIndicator.isIndicatorWidthFollowContent()) {
                    newLeft = usedLeft + childView.getContentViewLeft();
                    newWidth = childView.getContentViewWidth();
                } else {
                    newLeft = usedLeft;
                    newWidth = childMeasureWidth;
                }
                if (oldLeft != newLeft || oldWidth != newWidth) {
                    model.contentLeft = newLeft;
                    model.contentWidth = newWidth;
                }
                usedLeft = usedLeft + childMeasureWidth + model.rightAddonMargin + (QMUIBasicTabSegment.this.mMode == 0 ? QMUIBasicTabSegment.this.mItemSpaceInScrollMode : 0);
            }
            if (QMUIBasicTabSegment.this.mCurrentSelectedIndex != -1 && QMUIBasicTabSegment.this.mSelectAnimator == null && !QMUIBasicTabSegment.this.needPreventEvent()) {
                QMUIBasicTabSegment.this.layoutIndicator((QMUITab)QMUIBasicTabSegment.this.mTabAdapter.getItem(QMUIBasicTabSegment.this.mCurrentSelectedIndex), false);
            }
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (!(QMUIBasicTabSegment.this.mIndicator == null || QMUIBasicTabSegment.this.mHideIndicatorWhenTabCountLessTwo && QMUIBasicTabSegment.this.mTabAdapter.getSize() <= 1)) {
                QMUIBasicTabSegment.this.mIndicator.draw((View)this, canvas, this.getPaddingTop(), this.getHeight() - this.getPaddingBottom());
            }
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(int var1);

        public void onTabUnselected(int var1);

        public void onTabReselected(int var1);

        public void onDoubleTap(int var1);
    }

    public static interface OnTabClickListener {
        public boolean onTabClick(QMUITabView var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

