/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.section;

import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUISectionDiffCallback;
import java.util.ArrayList;
import java.util.List;

public abstract class QMUIStickySectionAdapter<H extends QMUISection.Model<H>, T extends QMUISection.Model<T>, VH extends ViewHolder>
extends RecyclerView.Adapter<VH> {
    private static final String TAG = "StickySectionAdapter";
    public static final int ITEM_TYPE_UNKNOWN = -1;
    public static final int ITEM_TYPE_SECTION_HEADER = 0;
    public static final int ITEM_TYPE_SECTION_ITEM = 1;
    public static final int ITEM_TYPE_SECTION_LOADING = 2;
    public static final int ITEM_TYPE_CUSTOM_OFFSET = 1000;
    private List<QMUISection<H, T>> mBackupData = new ArrayList<QMUISection<H, T>>();
    private List<QMUISection<H, T>> mCurrentData = new ArrayList<QMUISection<H, T>>();
    private SparseIntArray mSectionIndex = new SparseIntArray();
    private SparseIntArray mItemIndex = new SparseIntArray();
    private ArrayList<QMUISection<H, T>> mLoadingBeforeSections = new ArrayList(2);
    private ArrayList<QMUISection<H, T>> mLoadingAfterSections = new ArrayList(2);
    private Callback<H, T> mCallback;
    private ViewCallback mViewCallback;
    private final boolean mRemoveSectionTitleIfOnlyOneSection;

    public QMUIStickySectionAdapter() {
        this(false);
    }

    public QMUIStickySectionAdapter(boolean removeSectionTitleIfOnlyOneSection) {
        this.mRemoveSectionTitleIfOnlyOneSection = removeSectionTitleIfOnlyOneSection;
    }

    public final void setData(@Nullable List<QMUISection<H, T>> data) {
        this.setData(data, true);
    }

    public final void setData(@Nullable List<QMUISection<H, T>> data, boolean onlyMutateState) {
        this.setData(data, onlyMutateState, true);
    }

    public final void setData(@Nullable List<QMUISection<H, T>> data, boolean onlyMutateState, boolean checkLock) {
        this.mLoadingBeforeSections.clear();
        this.mLoadingAfterSections.clear();
        this.mCurrentData.clear();
        if (data != null) {
            this.mCurrentData.addAll(data);
        }
        this.beforeDiffInSet(this.mBackupData, this.mCurrentData);
        if (!this.mCurrentData.isEmpty() && checkLock) {
            this.lock(this.mCurrentData.get(0));
        }
        this.diff(true, onlyMutateState);
    }

    protected void beforeDiffInSet(List<QMUISection<H, T>> oldData, List<QMUISection<H, T>> newData) {
    }

    public final void setDataWithoutDiff(@Nullable List<QMUISection<H, T>> data, boolean onlyMutateState) {
        this.setDataWithoutDiff(data, onlyMutateState, true);
    }

    public final void setDataWithoutDiff(@Nullable List<QMUISection<H, T>> data, boolean onlyMutateState, boolean checkLock) {
        this.mLoadingBeforeSections.clear();
        this.mLoadingAfterSections.clear();
        this.mCurrentData.clear();
        if (data != null) {
            this.mCurrentData.addAll(data);
        }
        if (checkLock && !this.mCurrentData.isEmpty()) {
            this.lock(this.mCurrentData.get(0));
        }
        QMUISectionDiffCallback<H, T> callback = this.createDiffCallback(this.mBackupData, this.mCurrentData);
        callback.generateIndex(this.mRemoveSectionTitleIfOnlyOneSection);
        callback.cloneNewIndexTo(this.mSectionIndex, this.mItemIndex);
        this.notifyDataSetChanged();
        this.mBackupData.clear();
        for (QMUISection<H, T> section : this.mCurrentData) {
            this.mBackupData.add(onlyMutateState ? section.mutate() : section.cloneForDiff());
        }
    }

    private void diff(boolean newDataSet, boolean onlyMutateState) {
        QMUISectionDiffCallback<H, T> callback = this.createDiffCallback(this.mBackupData, this.mCurrentData);
        callback.generateIndex(this.mRemoveSectionTitleIfOnlyOneSection);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff(callback, (boolean)false);
        callback.cloneNewIndexTo(this.mSectionIndex, this.mItemIndex);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
        if (newDataSet || this.mBackupData.size() != this.mCurrentData.size()) {
            this.mBackupData.clear();
            for (QMUISection<H, T> section : this.mCurrentData) {
                this.mBackupData.add(onlyMutateState ? section.mutate() : section.cloneForDiff());
            }
        } else {
            for (int i = 0; i < this.mCurrentData.size(); ++i) {
                this.mCurrentData.get(i).cloneStatusTo(this.mBackupData.get(i));
            }
        }
    }

    public void refreshCustomData() {
        QMUISectionDiffCallback<H, T> callback = this.createDiffCallback(this.mBackupData, this.mCurrentData);
        callback.generateIndex(this.mRemoveSectionTitleIfOnlyOneSection);
        DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff(callback, (boolean)false);
        callback.cloneNewIndexTo(this.mSectionIndex, this.mItemIndex);
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    protected QMUISectionDiffCallback<H, T> createDiffCallback(List<QMUISection<H, T>> lastData, List<QMUISection<H, T>> currentData) {
        return new QMUISectionDiffCallback<H, T>(lastData, currentData);
    }

    public void setCallback(Callback<H, T> callback) {
        this.mCallback = callback;
    }

    void setViewCallback(ViewCallback viewCallback) {
        this.mViewCallback = viewCallback;
    }

    public int getSectionCount() {
        return this.mCurrentData.size();
    }

    public int getItemIndex(int position) {
        if (position < 0 || position >= this.mItemIndex.size()) {
            return -1;
        }
        return this.mItemIndex.get(position);
    }

    public int getSectionIndex(int position) {
        if (position < 0 || position >= this.mSectionIndex.size()) {
            return -1;
        }
        return this.mSectionIndex.get(position);
    }

    @Nullable
    public QMUISection<H, T> getSection(int position) {
        if (position < 0 || position >= this.mSectionIndex.size()) {
            return null;
        }
        int sectionIndex = this.mSectionIndex.get(position);
        if (sectionIndex < 0 || sectionIndex >= this.mCurrentData.size()) {
            return null;
        }
        return this.mCurrentData.get(sectionIndex);
    }

    @Nullable
    public QMUISection<H, T> getSectionDirectly(int index) {
        if (index < 0 || index >= this.mCurrentData.size()) {
            return null;
        }
        return this.mCurrentData.get(index);
    }

    public boolean isSectionFold(int position) {
        QMUISection<H, T> section = this.getSection(position);
        if (section == null) {
            return false;
        }
        return section.isFold();
    }

    @Nullable
    public T getSectionItem(int position) {
        int itemIndex = this.getItemIndex(position);
        if (itemIndex < 0) {
            return null;
        }
        QMUISection<H, T> section = this.getSection(position);
        if (section == null) {
            return null;
        }
        return section.getItemAt(itemIndex);
    }

    public void finishLoadMore(QMUISection<H, T> section, List<T> itemList, boolean isLoadBefore, boolean existMoreData) {
        if (isLoadBefore) {
            this.mLoadingBeforeSections.remove(section);
        } else {
            this.mLoadingAfterSections.remove(section);
        }
        if (this.mCurrentData.indexOf(section) < 0) {
            return;
        }
        if (isLoadBefore && !section.isFold()) {
            for (int i = 0; i < this.mItemIndex.size(); ++i) {
                RecyclerView.ViewHolder focusViewHolder;
                int position = this.mItemIndex.keyAt(i);
                int itemIndex = this.mItemIndex.valueAt(i);
                if (itemIndex != 0 || section != this.getSection(position)) continue;
                RecyclerView.ViewHolder viewHolder = focusViewHolder = this.mViewCallback == null ? null : this.mViewCallback.findViewHolderForAdapterPosition(position);
                if (focusViewHolder == null) break;
                this.mViewCallback.requestChildFocus(focusViewHolder.itemView);
                break;
            }
        }
        section.finishLoadMore(itemList, isLoadBefore, existMoreData);
        this.lock(section);
        this.diff(true, true);
    }

    private void lock(QMUISection<H, T> section) {
        boolean lockPrevious = !section.isFold() && section.isExistBeforeDataToLoad() && !section.isErrorToLoadBefore();
        boolean lockAfter = !section.isFold() && section.isExistAfterDataToLoad() && !section.isErrorToLoadAfter();
        int index = this.mCurrentData.indexOf(section);
        if (index < 0 || index >= this.mCurrentData.size()) {
            return;
        }
        section.setLocked(false);
        this.lockBefore(index - 1, lockPrevious);
        this.lockAfter(index + 1, lockAfter);
    }

    private void lockBefore(int current, boolean needLock) {
        while (current >= 0) {
            QMUISection<H, T> section = this.mCurrentData.get(current);
            if (needLock) {
                section.setLocked(true);
            } else {
                section.setLocked(false);
                needLock = !section.isFold() && section.isExistBeforeDataToLoad() && !section.isErrorToLoadBefore();
            }
            --current;
        }
    }

    private void lockAfter(int current, boolean needLock) {
        while (current < this.mCurrentData.size()) {
            QMUISection<H, T> section = this.mCurrentData.get(current);
            if (needLock) {
                section.setLocked(true);
            } else {
                section.setLocked(false);
                needLock = !section.isFold() && section.isExistAfterDataToLoad() && !section.isErrorToLoadAfter();
            }
            ++current;
        }
    }

    public void scrollToSectionHeader(@NonNull QMUISection<H, T> targetSection, boolean scrollToTop) {
        if (this.mViewCallback == null) {
            return;
        }
        for (int i = 0; i < this.mCurrentData.size(); ++i) {
            QMUISection<H, T> section = this.mCurrentData.get(i);
            if (!targetSection.getHeader().isSameItem(section.getHeader())) continue;
            if (section.isLocked()) {
                this.lock(section);
                this.diff(false, true);
                this.safeScrollToSection(section, scrollToTop);
            } else {
                this.safeScrollToSection(section, scrollToTop);
            }
            return;
        }
    }

    private void safeScrollToSection(@NonNull QMUISection<H, T> targetSection, boolean scrollToTop) {
        for (int i = 0; i < this.mSectionIndex.size(); ++i) {
            QMUISection<H, T> temp;
            int itemIndex;
            int position = this.mSectionIndex.keyAt(i);
            int sectionIndex = this.mSectionIndex.valueAt(i);
            if (sectionIndex < 0 || sectionIndex >= this.mCurrentData.size() || (itemIndex = this.mItemIndex.get(position)) != -2 || !(temp = this.mCurrentData.get(sectionIndex)).getHeader().isSameItem(targetSection.getHeader())) continue;
            this.mViewCallback.scrollToPosition(position, true, scrollToTop);
            return;
        }
    }

    public void scrollToSectionItem(@Nullable QMUISection<H, T> targetSection, @NonNull T targetItem, boolean scrollToTop) {
        if (this.mViewCallback == null) {
            return;
        }
        for (int i = 0; i < this.mCurrentData.size(); ++i) {
            QMUISection<H, T> section = this.mCurrentData.get(i);
            if ((targetSection != null || !section.existItem(targetItem)) && targetSection != section) continue;
            if (section.isFold() || section.isLocked()) {
                section.setFold(false);
                this.lock(section);
                this.diff(false, true);
                this.safeScrollToSectionItem(section, targetItem, scrollToTop);
            } else {
                this.safeScrollToSectionItem(section, targetItem, scrollToTop);
            }
            return;
        }
    }

    private void safeScrollToSectionItem(@NonNull QMUISection<H, T> targetSection, @NonNull T item, boolean scrollToTop) {
        for (int i = 0; i < this.mItemIndex.size(); ++i) {
            QMUISection<H, T> section;
            int position = this.mItemIndex.keyAt(i);
            int itemIndex = this.mItemIndex.valueAt(i);
            if (itemIndex < 0 || (section = this.getSection(position)) != targetSection || !section.getItemAt(itemIndex).isSameItem(item)) continue;
            this.mViewCallback.scrollToPosition(position, false, scrollToTop);
            return;
        }
    }

    public int findCustomPosition(int sectionIndex, int customItemIndex, boolean unFoldTargetSection) {
        int itemIndex = -1000 + customItemIndex;
        return this.findPosition(sectionIndex, itemIndex, unFoldTargetSection);
    }

    public int findPosition(int sectionIndex, int itemIndex, boolean unFoldTargetSection) {
        QMUISection<H, T> section;
        if (unFoldTargetSection && sectionIndex >= 0 && (section = this.mCurrentData.get(sectionIndex)) != null && section.isFold()) {
            section.setFold(false);
            this.lock(section);
            this.diff(false, true);
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.mSectionIndex.get(i) != sectionIndex || this.mItemIndex.get(i) != itemIndex) continue;
            return i;
        }
        return -1;
    }

    public int findPosition(PositionFinder<H, T> positionFinder, boolean unFoldTargetSection) {
        QMUISection<H, T> section;
        int i;
        if (!unFoldTargetSection) {
            for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
                int itemIndex;
                QMUISection<H, T> section2 = this.getSection(i2);
                if (section2 == null || !((itemIndex = this.getItemIndex(i2)) == -2 ? positionFinder.find(section2, null) : itemIndex >= 0 && positionFinder.find(section2, section2.getItemAt(itemIndex)))) continue;
                return i2;
            }
            return -1;
        }
        QMUISection<H, T> targetSection = null;
        Object targetItem = null;
        block1: for (i = 0; i < this.mCurrentData.size(); ++i) {
            section = this.mCurrentData.get(i);
            if (positionFinder.find(section, null)) {
                targetSection = section;
                break;
            }
            for (int j = 0; j < section.getItemCount(); ++j) {
                if (!positionFinder.find(section, section.getItemAt(j))) continue;
                targetSection = section;
                targetItem = section.getItemAt(j);
                boolean isFold = section.isFold();
                if (!isFold) break block1;
                section.setFold(false);
                this.lock(section);
                this.diff(false, true);
                break block1;
            }
        }
        for (i = 0; i < this.getItemCount(); ++i) {
            section = this.getSection(i);
            if (section != targetSection) continue;
            int itemIndex = this.getItemIndex(i);
            if (itemIndex == -2 && targetItem == null) {
                return i;
            }
            if (itemIndex < 0 || !section.getItemAt(itemIndex).isSameItem(targetItem)) continue;
            return i;
        }
        return -1;
    }

    public void toggleFold(int position, boolean scrollToTop) {
        QMUISection<H, T> section = this.getSection(position);
        if (section == null) {
            return;
        }
        section.setFold(!section.isFold());
        this.lock(section);
        this.diff(false, true);
        if (scrollToTop && !section.isFold() && this.mViewCallback != null) {
            for (int i = 0; i < this.mSectionIndex.size(); ++i) {
                int pos = this.mSectionIndex.keyAt(i);
                int itemIndex = this.getItemIndex(pos);
                if (itemIndex != -2 || this.getSection(pos) != section) continue;
                this.mViewCallback.scrollToPosition(pos, true, true);
                return;
            }
        }
    }

    public int getRelativeStickyPosition(int position) {
        while (this.getItemViewType(position) != 0) {
            if (--position >= 0) continue;
            return -1;
        }
        return position;
    }

    public boolean isRemoveSectionTitleIfOnlyOneSection() {
        return this.mRemoveSectionTitleIfOnlyOneSection;
    }

    public final int getItemCount() {
        return this.mItemIndex.size();
    }

    @NonNull
    public final VH onCreateViewHolder(@NonNull ViewGroup viewGroup, int type) {
        if (type == 0) {
            return this.onCreateSectionHeaderViewHolder(viewGroup);
        }
        if (type == 1) {
            return this.onCreateSectionItemViewHolder(viewGroup);
        }
        if (type == 2) {
            return this.onCreateSectionLoadingViewHolder(viewGroup);
        }
        return this.onCreateCustomItemViewHolder(viewGroup, type - 1000);
    }

    public final void onBindViewHolder(@NonNull VH vh, int position) {
        int stickyPosition = position;
        QMUISection<H, T> section = this.getSection(position);
        int itemIndex = this.getItemIndex(position);
        if (itemIndex == -2) {
            this.onBindSectionHeader(vh, position, section);
        } else if (itemIndex >= 0) {
            this.onBindSectionItem(vh, position, section, itemIndex);
        } else if (itemIndex == -3 || itemIndex == -4) {
            this.onBindSectionLoadingItem(vh, position, section, itemIndex == -3);
        } else {
            this.onBindCustomItem(vh, position, section, itemIndex - -1000);
        }
        if (itemIndex == -4) {
            ((ViewHolder)((Object)vh)).isLoadBefore = false;
        } else if (itemIndex == -3) {
            ((ViewHolder)((Object)vh)).isLoadBefore = true;
        }
        ((ViewHolder)((Object)vh)).itemView.setOnClickListener(new View.OnClickListener((ViewHolder)((Object)vh), stickyPosition){
            final /* synthetic */ ViewHolder val$vh;
            final /* synthetic */ int val$stickyPosition;
            {
                this.val$vh = viewHolder;
                this.val$stickyPosition = n;
            }

            public void onClick(View v) {
                int pos;
                int n = pos = this.val$vh.isForStickyHeader ? this.val$stickyPosition : this.val$vh.getAdapterPosition();
                if (pos != -1 && QMUIStickySectionAdapter.this.mCallback != null) {
                    QMUIStickySectionAdapter.this.mCallback.onItemClick(this.val$vh, pos);
                }
            }
        });
        ((ViewHolder)((Object)vh)).itemView.setOnLongClickListener(new View.OnLongClickListener((ViewHolder)((Object)vh), stickyPosition){
            final /* synthetic */ ViewHolder val$vh;
            final /* synthetic */ int val$stickyPosition;
            {
                this.val$vh = viewHolder;
                this.val$stickyPosition = n;
            }

            public boolean onLongClick(View v) {
                int pos;
                int n = pos = this.val$vh.isForStickyHeader ? this.val$stickyPosition : this.val$vh.getAdapterPosition();
                if (pos != -1 && QMUIStickySectionAdapter.this.mCallback != null) {
                    return QMUIStickySectionAdapter.this.mCallback.onItemLongClick(this.val$vh, pos);
                }
                return false;
            }
        });
    }

    @NonNull
    protected abstract VH onCreateSectionHeaderViewHolder(@NonNull ViewGroup var1);

    @NonNull
    protected abstract VH onCreateSectionItemViewHolder(@NonNull ViewGroup var1);

    @NonNull
    protected abstract VH onCreateSectionLoadingViewHolder(@NonNull ViewGroup var1);

    @NonNull
    protected abstract VH onCreateCustomItemViewHolder(@NonNull ViewGroup var1, int var2);

    protected void onBindSectionHeader(VH holder, int position, QMUISection<H, T> section) {
    }

    protected void onBindSectionItem(VH holder, int position, QMUISection<H, T> section, int itemIndex) {
    }

    protected void onBindSectionLoadingItem(VH holder, int position, QMUISection<H, T> section, boolean loadingBefore) {
    }

    protected void onBindCustomItem(VH holder, int position, @Nullable QMUISection<H, T> section, int itemIndex) {
    }

    public final int getItemViewType(int position) {
        int itemIndex = this.getItemIndex(position);
        if (itemIndex == -1) {
            Log.e((String)TAG, (String)"the item index is undefined, you may need to check your data if not called by QMUIStickySectionItemDecoration.");
            return -1;
        }
        if (itemIndex == -2) {
            return 0;
        }
        if (itemIndex == -3 || itemIndex == -4) {
            return 2;
        }
        if (itemIndex >= 0) {
            return 1;
        }
        return 1000 + this.getCustomItemViewType(itemIndex - -1000, position);
    }

    public void onViewAttachedToWindow(@NonNull VH holder) {
        QMUISection<H, T> section;
        if (holder.getItemViewType() == 2 && this.mCallback != null && !((ViewHolder)((Object)holder)).isLoadError && (section = this.getSection(holder.getAdapterPosition())) != null) {
            if (((ViewHolder)((Object)holder)).isLoadBefore) {
                if (this.mLoadingBeforeSections.contains(section)) {
                    return;
                }
                this.mLoadingBeforeSections.add(section);
                this.mCallback.loadMore(section, true);
            } else {
                if (this.mLoadingAfterSections.contains(section)) {
                    return;
                }
                this.mLoadingAfterSections.add(section);
                this.mCallback.loadMore(section, false);
            }
        }
    }

    protected int getCustomItemViewType(int itemIndex, int position) {
        return -1;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public boolean isLoadError = false;
        public boolean isLoadBefore = false;
        public boolean isForStickyHeader = false;

        public ViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static interface PositionFinder<H extends QMUISection.Model<H>, T extends QMUISection.Model<T>> {
        public boolean find(@NonNull QMUISection<H, T> var1, @Nullable T var2);
    }

    public static interface ViewCallback {
        public void scrollToPosition(int var1, boolean var2, boolean var3);

        @Nullable
        public RecyclerView.ViewHolder findViewHolderForAdapterPosition(int var1);

        public void requestChildFocus(View var1);
    }

    public static interface Callback<H extends QMUISection.Model<H>, T extends QMUISection.Model<T>> {
        public void loadMore(QMUISection<H, T> var1, boolean var2);

        public void onItemClick(ViewHolder var1, int var2);

        public boolean onItemLongClick(ViewHolder var1, int var2);
    }
}

