/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.pullLayout;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.collection.SimpleArrayMap;
import androidx.core.content.ContextCompat;
import androidx.swiperefreshlayout.widget.CircularProgressDrawable;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.defaultAttr.IQMUISkinDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.pullLayout.QMUIPullLayout;

public class QMUIPullRefreshView
extends AppCompatImageView
implements QMUIPullLayout.ActionPullWatcherView,
IQMUISkinDefaultAttrProvider {
    private static final int MAX_ALPHA = 255;
    private static final float TRIM_RATE = 0.85f;
    private static final float TRIM_OFFSET = 0.4f;
    static final int CIRCLE_DIAMETER = 40;
    static final int CIRCLE_DIAMETER_LARGE = 56;
    private CircularProgressDrawable mProgress;
    private int mCircleDiameter;
    private static SimpleArrayMap<String, Integer> sDefaultSkinAttrs = new SimpleArrayMap(4);

    public QMUIPullRefreshView(Context context) {
        this(context, null);
    }

    public QMUIPullRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mProgress = new CircularProgressDrawable(context);
        this.setColorSchemeColors(QMUIResHelper.getAttrColor(context, R.attr.qmui_skin_support_pull_refresh_view_color));
        this.mProgress.setStyle(0);
        this.mProgress.setAlpha(255);
        this.mProgress.setArrowScale(0.8f);
        this.setImageDrawable((Drawable)this.mProgress);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mCircleDiameter = (int)(40.0f * metrics.density);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mCircleDiameter, this.mCircleDiameter);
    }

    @Override
    public void onActionTriggered() {
        this.mProgress.start();
    }

    @Override
    public void onActionFinished() {
        this.mProgress.stop();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mProgress.stop();
    }

    @Override
    public void onPull(QMUIPullLayout.PullAction pullAction, int currentTargetOffset) {
        if (this.mProgress.isRunning()) {
            return;
        }
        int targetOffset = pullAction.getTargetTriggerOffset();
        float end = 0.85f * (float)Math.min(targetOffset, currentTargetOffset) / (float)targetOffset;
        float rotate = 0.4f * (float)currentTargetOffset / (float)targetOffset;
        this.mProgress.setArrowEnabled(true);
        this.mProgress.setStartEndTrim(0.0f, end);
        this.mProgress.setProgressRotation(rotate);
    }

    public void setSize(int size) {
        if (size != 0 && size != 1) {
            return;
        }
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mCircleDiameter = size == 0 ? (int)(56.0f * metrics.density) : (int)(40.0f * metrics.density);
        this.setImageDrawable(null);
        this.mProgress.setStyle(size);
        this.setImageDrawable((Drawable)this.mProgress);
    }

    public void stop() {
        this.mProgress.stop();
    }

    public void doRefresh() {
    }

    public void setColorSchemeResources(int ... colorResIds) {
        Context context = this.getContext();
        int[] colorRes = new int[colorResIds.length];
        for (int i = 0; i < colorResIds.length; ++i) {
            colorRes[i] = ContextCompat.getColor((Context)context, (int)colorResIds[i]);
        }
        this.setColorSchemeColors(colorRes);
    }

    public void setColorSchemeColors(int ... colors) {
        this.mProgress.setColorSchemeColors(colors);
    }

    @Override
    public SimpleArrayMap<String, Integer> getDefaultSkinAttrs() {
        return sDefaultSkinAttrs;
    }

    static {
        sDefaultSkinAttrs.put((Object)"tintColor", (Object)R.attr.qmui_skin_support_pull_refresh_view_color);
    }
}

